/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.bukkit.feature.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.sayandev.sayanvanish.api.Permission;
import org.sayandev.sayanvanish.api.VanishOptions;
import org.sayandev.sayanvanish.api.feature.Configurable;
import org.sayandev.sayanvanish.api.feature.RegisteredFeature;
import org.sayandev.sayanvanish.bukkit.api.BukkitUser;
import org.sayandev.sayanvanish.bukkit.api.SayanVanishBukkitAPI;
import org.sayandev.sayanvanish.bukkit.config.LanguageConfigKt;
import org.sayandev.sayanvanish.bukkit.feature.ListenedFeature;
import org.sayandev.sayanvanish.lib.sayanventure.adventure.text.minimessage.tag.resolver.Placeholder;
import org.sayandev.sayanvanish.lib.sayanventure.adventure.text.minimessage.tag.resolver.TagResolver;
import org.sayandev.sayanvanish.lib.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.sayandev.sayanvanish.lib.spongepowered.configurate.objectmapping.meta.Comment;

@RegisteredFeature
@ConfigSerializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B9\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0003R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0016\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/sayandev/sayanvanish/bukkit/feature/features/FeatureState;", "Lorg/sayandev/sayanvanish/bukkit/feature/ListenedFeature;", "remember", "", "vanishOnJoin", "reappearOnQuit", "checkPermissionOnQuit", "checkPermissionOnJoin", "<init>", "(ZZZZZ)V", "getRemember", "()Z", "getVanishOnJoin", "getReappearOnQuit", "getCheckPermissionOnQuit", "getCheckPermissionOnJoin", "onJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "updateUserOnQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "sayanvanish-bukkit"})
@SourceDebugExtension(value={"SMAP\nFeatureState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureState.kt\norg/sayandev/sayanvanish/bukkit/feature/features/FeatureState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n774#2:112\n865#2,2:113\n774#2:115\n865#2,2:116\n*S KotlinDebug\n*F\n+ 1 FeatureState.kt\norg/sayandev/sayanvanish/bukkit/feature/features/FeatureState\n*L\n80#1:112\n80#1:113,2\n97#1:115\n97#1:116,2\n*E\n"})
public final class FeatureState
extends ListenedFeature {
    @Configurable
    private final boolean remember;
    @Configurable
    private final boolean vanishOnJoin;
    @Configurable
    private final boolean reappearOnQuit;
    @Configurable
    private final boolean checkPermissionOnQuit;
    @Configurable
    private final boolean checkPermissionOnJoin;

    public FeatureState(@Comment(value="\n    This is a CRITICAL feature. It is responsible for handling the state of the player when they join or quit the server.\n    do NOT disable this feature if you don't know what you're doing.\n    \n    If true, players will be remembered when they join the server. (if they were vanished before quitting)\n    ") boolean remember, @Comment(value="Whether to vanish players when they join the server (they also need vanish on join permission)") boolean vanishOnJoin, @Comment(value="Whether to reappear players when they quit the server") boolean reappearOnQuit, @Comment(value="Whether to check permission when a player joins the server") boolean checkPermissionOnQuit, @Comment(value="Whether to check permission when a player quits the server") boolean checkPermissionOnJoin) {
        super("state", false, null, null, true, 14, null);
        this.remember = remember;
        this.vanishOnJoin = vanishOnJoin;
        this.reappearOnQuit = reappearOnQuit;
        this.checkPermissionOnQuit = checkPermissionOnQuit;
        this.checkPermissionOnJoin = checkPermissionOnJoin;
    }

    public /* synthetic */ FeatureState(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = true;
        }
        if ((n & 0x10) != 0) {
            bl5 = true;
        }
        this(bl, bl2, bl3, bl4, bl5);
    }

    public final boolean getRemember() {
        return this.remember;
    }

    public final boolean getVanishOnJoin() {
        return this.vanishOnJoin;
    }

    public final boolean getReappearOnQuit() {
        return this.reappearOnQuit;
    }

    public final boolean getCheckPermissionOnQuit() {
        return this.checkPermissionOnQuit;
    }

    public final boolean getCheckPermissionOnJoin() {
        return this.checkPermissionOnJoin;
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler(priority=EventPriority.LOWEST)
    private final void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        BukkitUser user2 = SayanVanishBukkitAPI.Companion.user((OfflinePlayer)player2);
        if (user2 != null && !this.isActive(user2) || !this.isActive()) {
            return;
        }
        VanishOptions vanishJoinOptions = new VanishOptions.Builder().sendMessage(false).notifyStatusChangeToOthers(false).isOnJoin(true).build();
        if (user2 == null) {
            if (!player2.hasPermission(Permission.VANISH.permission())) {
                return;
            }
            BukkitUser tempUser = SayanVanishBukkitAPI.Companion.getOrAddUser((OfflinePlayer)player2);
            tempUser.setOnline(true);
            if (tempUser.hasPermission(Permission.VANISH_ON_JOIN) || this.vanishOnJoin) {
                tempUser.setVanished(true);
                tempUser.vanish(vanishJoinOptions);
                tempUser.save();
            }
            return;
        }
        user2.setOnline(true);
        if (this.checkPermissionOnJoin && !user2.hasPermission(Permission.VANISH)) {
            TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.unparsed((String)"permission", (String)Permission.VANISH.permission())};
            user2.sendComponent(LanguageConfigKt.getLanguage().getVanish().getNoPermissionToKeepVanished(), tagResolverArray);
            user2.unVanish(vanishJoinOptions);
            user2.delete();
            return;
        }
        if (user2.hasPermission(Permission.VANISH_ON_JOIN) || user2.isVanished() && this.remember || this.vanishOnJoin) {
            user2.setVanished(true);
            user2.vanish(vanishJoinOptions);
        }
        if (user2.isVanished() && user2.getCurrentOptions().getNotifyJoinQuitVanished()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = SayanVanishBukkitAPI.Companion.getInstance().getDatabase().getUsers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BukkitUser it = (BukkitUser)element$iv$iv;
                boolean bl = false;
                if (!(it.hasPermission(Permission.VANISH) && it.getVanishLevel() >= user2.getVanishLevel())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (BukkitUser vanishedUser : (List)destination$iv$iv) {
                TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.unparsed((String)"player", (String)user2.getUsername())};
                vanishedUser.sendComponent(LanguageConfigKt.getLanguage().getVanish().getJoinedTheServerWhileVanished(), tagResolverArray);
            }
        }
        user2.save();
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler(priority=EventPriority.LOWEST)
    private final void updateUserOnQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        BukkitUser bukkitUser = SayanVanishBukkitAPI.Companion.user((OfflinePlayer)player2);
        if (bukkitUser == null) {
            return;
        }
        BukkitUser user2 = bukkitUser;
        if (user2.isVanished() && user2.getCurrentOptions().getNotifyJoinQuitVanished()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = SayanVanishBukkitAPI.Companion.getInstance().getDatabase().getUsers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BukkitUser it = (BukkitUser)element$iv$iv;
                boolean bl = false;
                if (!(it.hasPermission(Permission.VANISH) && it.getVanishLevel() >= user2.getVanishLevel())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (BukkitUser vanishedUser : (List)destination$iv$iv) {
                TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.unparsed((String)"player", (String)user2.getUsername())};
                vanishedUser.sendComponent(LanguageConfigKt.getLanguage().getVanish().getLeftTheServerWhileVanished(), tagResolverArray);
            }
        }
        if (this.reappearOnQuit && user2.isVanished() || this.checkPermissionOnQuit && !user2.hasPermission(Permission.VANISH)) {
            user2.unVanish(new VanishOptions.Builder().isOnQuit(true).build());
        }
        user2.setOnline(false);
        user2.save();
    }

    public FeatureState() {
        this(false, false, false, false, false, 31, null);
    }
}

