/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.lib.loader.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.Nullable;

public class Dependency
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String group;
    private String name;
    private String version;
    private String relocation;
    private boolean stickyLoad;
    private boolean transitiveResolved;
    private List<Dependency> transitiveDependencies;

    public Dependency(String group, String name, String version, String relocation, boolean stickyLoad) {
        this.group = group;
        this.name = name;
        this.version = version;
        this.stickyLoad = stickyLoad;
        this.relocation = relocation;
        this.transitiveResolved = false;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getRelocation() {
        return this.relocation;
    }

    public boolean isStickyLoad() {
        return this.stickyLoad;
    }

    public void setStickyLoad(boolean stickyLoad) {
        this.stickyLoad = stickyLoad;
    }

    public boolean isTransitiveResolved() {
        return this.transitiveResolved;
    }

    public void setTransitiveResolved(boolean transitiveResolved) {
        this.transitiveResolved = transitiveResolved;
    }

    public List<Dependency> getTransitiveDependencies() {
        return this.transitiveDependencies;
    }

    public void setTransitiveDependencies(List<Dependency> transitiveDependencies) {
        this.transitiveDependencies = transitiveDependencies;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Dependency) {
            Dependency other = (Dependency)obj;
            return this.group.equals(other.group) && this.name.equals(other.name) && this.version.equals(other.version);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.group, this.name, this.version);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.group);
        oos.writeUTF(this.name);
        oos.writeUTF(this.version);
        oos.writeObject(this.relocation);
        oos.writeBoolean(this.stickyLoad);
        oos.writeBoolean(this.transitiveResolved);
        oos.writeObject(this.transitiveDependencies);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        try {
            this.group = ois.readUTF();
            this.name = ois.readUTF();
            this.version = ois.readUTF();
            this.relocation = (String)ois.readObject();
            this.stickyLoad = ois.readBoolean();
            this.transitiveResolved = ois.readBoolean();
            this.transitiveDependencies = (List)ois.readObject();
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
    }
}

