/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.lib.loader.common;

import com.alessiodp.libby.Library;
import com.alessiodp.libby.LibraryManager;
import com.alessiodp.libby.logging.LogLevel;
import com.alessiodp.libby.transitive.TransitiveDependencyHelper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.sayandev.sayanvanish.lib.loader.common.Dependency;
import org.sayandev.sayanvanish.lib.loader.common.DependencyCache;

public abstract class StickyNoteLoader {
    private final String projectName;
    private static final ConcurrentHashMap<Dependency, CompletableFuture<Void>> loadingLibraries = new ConcurrentHashMap();
    private static final ExecutorService executorService = Executors.newWorkStealingPool(Runtime.getRuntime().availableProcessors());
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    public static final List<String> exclusions = Arrays.asList("takenaka", "mappings", "gson", "adventure");
    public static final Map<String, String> relocations = new HashMap<String, String>();
    private final List<String> transitiveExcluded = Arrays.asList("xseries", "stickynote");
    Class<?> stickyNotes = Class.forName("org.sayandev.sayanvanish.lib.stickynote.generated.StickyNotes");
    Boolean relocate = (Boolean)this.stickyNotes.getField("RELOCATE").get(this.stickyNotes);
    final boolean checkTimeBeforeDelete = true;

    protected StickyNoteLoader(String projectName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        this.projectName = projectName;
    }

    protected abstract void onComplete();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String id, File dataDirectory, Logger logger, LibraryManager libraryManager, boolean withLibDirectory) {
        File libDirectory = StickyNoteLoader.generateLibDirectory(dataDirectory, withLibDirectory);
        File[] files = libDirectory.listFiles();
        logger.info("Loading libraries... this might take up to a few minutes depending on your connection.");
        long startTime = System.currentTimeMillis();
        try {
            boolean bl;
            ArrayList<Dependency> generatedDependencies = new ArrayList<Dependency>(this.getDependencies(this.stickyNotes));
            List<String> repositories = this.getRepositories(this.stickyNotes);
            Object relocation = this.stickyNotes.getField("RELOCATION").get(this.stickyNotes);
            String relocationFrom = (String)relocation.getClass().getMethod("getFrom", new Class[0]).invoke(relocation, new Object[0]);
            String relocationTo = (String)relocation.getClass().getMethod("getTo", new Class[0]).invoke(relocation, new Object[0]);
            StickyNoteLoader.configureLibraryManager(libraryManager, repositories);
            TransitiveDependencyHelper transitiveDependencyHelper = new TransitiveDependencyHelper(libraryManager, libDirectory.toPath());
            relocations.put("com{}mysql", relocationTo + "{}lib{}mysql");
            relocations.put("kotlinx{}coroutines", relocationTo + "{}lib{}kotlinx{}coroutines");
            relocations.put("org{}jetbrains{}exposed", relocationTo + "{}lib{}exposed");
            DependencyCache dependencyCache = new DependencyCache(id, libDirectory);
            HashSet<Dependency> cachedDependencies = new HashSet<Dependency>(dependencyCache.loadCache());
            HashSet<Dependency> missingDependencies = new HashSet<Dependency>(this.getMissingDependencies(generatedDependencies, cachedDependencies));
            if (!missingDependencies.isEmpty()) {
                logger.info(String.format("There are %d missing dependencies:", missingDependencies.size()));
                for (Dependency dependency : generatedDependencies) {
                    String symbol = missingDependencies.contains(dependency) ? "[New]   +" : (cachedDependencies.contains(dependency) ? "[Cache] #" : "[Old]   -");
                    logger.info(String.format("%s %s (%s) version %s", symbol, dependency.getName(), dependency.getGroup().replace("{}", "."), dependency.getVersion()));
                }
                logger.info("Missing dependencies will be downloaded and cached.");
            }
            ArrayList<Dependency> allDependencies = new ArrayList<Dependency>();
            allDependencies.addAll(generatedDependencies);
            allDependencies.addAll(this.getTransitiveDependencies(this.stickyNotes));
            for (Dependency generatedDependency : allDependencies) {
                String name = generatedDependency.getName();
                String group = generatedDependency.getGroup();
                if (exclusions.stream().anyMatch(excluded -> generatedDependency.getName().contains((CharSequence)excluded))) continue;
                if (generatedDependency.isStickyLoad()) {
                    if (generatedDependency.getRelocation() == null) continue;
                    String[] splitted = generatedDependency.getGroup().split("\\{}");
                    relocations.put(generatedDependency.getRelocation(), relocationTo + "{}lib{}" + splitted[splitted.length - 1]);
                    continue;
                }
                if (name.contains("adventure")) continue;
                if (name.contains("stickynote")) {
                    relocations.put(relocationFrom, relocationTo + "{}lib{}stickynote");
                }
                String[] groupParts = group.split("\\{}");
                relocations.put(group, relocationTo + "{}lib{}" + groupParts[groupParts.length - 1]);
            }
            relocations.remove("org{}sayandev");
            relocations.put("org{}sayandev{}loader", relocationTo + "{}lib{}stickynote");
            relocations.put("org{}sayandev{}stickynote", relocationTo + "{}lib{}stickynote");
            boolean bl2 = bl = !missingDependencies.isEmpty();
            if (bl) {
                this.loadMissingDependencies(libDirectory, id, logger, libraryManager, transitiveDependencyHelper, dependencyCache, generatedDependencies, missingDependencies, relocationFrom, relocationTo);
            } else {
                this.loadCachedDependencies(id, logger, libraryManager, cachedDependencies, relocationFrom, relocationTo);
            }
            long endTime = System.currentTimeMillis();
            logger.info("Loaded " + generatedDependencies.size() + " library in " + (endTime - startTime) + " ms.");
            List<Dependency> allProjectsCachedDependencies = this.getAllProjectsCachedDependencies(logger, libDirectory);
            File[] libDirectoryFiles = libDirectory.listFiles();
            if (libDirectoryFiles != null) {
                for (Dependency projectDependency : allProjectsCachedDependencies) {
                    List<String> versions = this.getAllVersions(libDirectory, projectDependency.getGroup(), projectDependency.getName());
                    List<Dependency> toBeRemovedVersions = versions.stream().map(version -> new Dependency(projectDependency.getGroup(), projectDependency.getName(), (String)version, projectDependency.getRelocation(), projectDependency.isStickyLoad())).filter(dependencyOfVersion -> !allProjectsCachedDependencies.contains(dependencyOfVersion)).toList();
                    for (Dependency dependency : toBeRemovedVersions) {
                        this.deleteOldVersionDirectory(libDirectory, dependency.getGroup(), dependency.getName(), dependency.getVersion());
                    }
                }
            }
            this.onComplete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            executorService.shutdown();
            scheduler.shutdown();
        }
    }

    private List<File> getVersionFiles(File libDirectory, String group, String name) {
        File[] files = this.versionsDirectory(libDirectory, group, name).listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(File::isDirectory).collect(Collectors.toList());
    }

    private static void configureLibraryManager(LibraryManager libraryManager, List<String> repositories) {
        libraryManager.setLogLevel(LogLevel.WARN);
        libraryManager.addMavenCentral();
        libraryManager.addRepository("https://repo.sayandev.org/snapshots");
        libraryManager.addMavenLocal();
        repositories.forEach(libraryManager::addRepository);
    }

    private Set<Dependency> getMissingDependencies(List<Dependency> generatedDependencies, Set<Dependency> cachedDependencies) {
        HashSet<Dependency> missingDependencies = new HashSet<Dependency>(generatedDependencies);
        missingDependencies.removeIf(missingDependency -> cachedDependencies.stream().toList().contains(missingDependency));
        return missingDependencies;
    }

    private void loadMissingDependencies(File libDirectory, String id, Logger logger, LibraryManager libraryManager, TransitiveDependencyHelper transitiveDependencyHelper, DependencyCache dependencyCache, List<Dependency> dependencies, Set<Dependency> missingDependencies, String relocationFrom, String relocationTo) throws InterruptedException, ExecutionException {
        List<CompletableFuture> resolveFutures = dependencies.stream().map(dependency -> this.resolveTransitiveDependenciesAsync(id, transitiveDependencyHelper, (Dependency)dependency)).toList();
        CompletableFuture<Void> resolveAll = CompletableFuture.allOf(resolveFutures.toArray(new CompletableFuture[0]));
        scheduler.scheduleAtFixedRate(() -> this.logProgress(logger, resolveFutures, dependencies.size()), 3L, 5L, TimeUnit.SECONDS);
        ((CompletableFuture)resolveAll.thenRunAsync(() -> {
            dependencyCache.saveCache(new HashSet<Dependency>(dependencies));
            List futures = dependencies.stream().map(dependency -> this.loadDependencyAndTransitives(id, libraryManager, (Dependency)dependency, relocationFrom, relocationTo)).flatMap(Collection::stream).toList();
            CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            allOf.join();
        }, executorService)).join();
    }

    private List<CompletableFuture<Void>> loadDependencyAndTransitives(String id, LibraryManager libraryManager, Dependency dependency, String relocationFrom, String relocationTo) {
        ArrayList<CompletableFuture<Void>> loadingFutures = new ArrayList<CompletableFuture<Void>>();
        for (Dependency transitiveDependency : dependency.getTransitiveDependencies()) {
            loadingFutures.add(this.loadDependencyAsync(id, transitiveDependency, libraryManager));
        }
        loadingFutures.add(this.loadDependencyAsync(id, dependency, libraryManager));
        return loadingFutures;
    }

    private void loadCachedDependencies(String id, Logger logger, LibraryManager libraryManager, Set<Dependency> cachedDependencies, String relocationFrom, String relocationTo) {
        logger.info("Library cache found, loading cached libraries...");
        for (Dependency dependency : cachedDependencies) {
            try {
                Library library = this.createLibraryBuilder(dependency).build();
                libraryManager.loadLibrary(library);
                if (dependency.getTransitiveDependencies() == null) continue;
                for (Dependency transitiveDependency : dependency.getTransitiveDependencies()) {
                    Library transitiveLibrary = this.createLibraryBuilder(transitiveDependency).build();
                    libraryManager.loadLibrary(transitiveLibrary);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<Dependency> getDependencies(Class<?> stickyNotes) {
        return Arrays.stream(stickyNotes.getFields()).filter(field -> field.getName().startsWith("DEPENDENCY_")).map(field -> {
            try {
                Object dependencyObject = field.get(null);
                Class<?> dependencyFieldClass = dependencyObject.getClass();
                return new Dependency((String)dependencyFieldClass.getMethod("getGroup", new Class[0]).invoke(dependencyObject, new Object[0]), (String)dependencyFieldClass.getMethod("getName", new Class[0]).invoke(dependencyObject, new Object[0]), (String)dependencyFieldClass.getMethod("getVersion", new Class[0]).invoke(dependencyObject, new Object[0]), (String)dependencyFieldClass.getMethod("getRelocation", new Class[0]).invoke(dependencyObject, new Object[0]), (Boolean)dependencyFieldClass.getMethod("isStickyLoad", new Class[0]).invoke(dependencyObject, new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).toList();
    }

    private List<Dependency> getTransitiveDependencies(Class<?> stickyNotes) {
        return Arrays.stream(stickyNotes.getFields()).filter(field -> field.getName().startsWith("TRANSITIVE_DEPENDENCY_")).map(field -> {
            try {
                Object dependencyObject = field.get(null);
                Class<?> dependencyFieldClass = dependencyObject.getClass();
                return new Dependency((String)dependencyFieldClass.getMethod("getGroup", new Class[0]).invoke(dependencyObject, new Object[0]), (String)dependencyFieldClass.getMethod("getName", new Class[0]).invoke(dependencyObject, new Object[0]), (String)dependencyFieldClass.getMethod("getVersion", new Class[0]).invoke(dependencyObject, new Object[0]), (String)dependencyFieldClass.getMethod("getRelocation", new Class[0]).invoke(dependencyObject, new Object[0]), (Boolean)dependencyFieldClass.getMethod("isStickyLoad", new Class[0]).invoke(dependencyObject, new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).toList();
    }

    private List<String> getRepositories(Class<?> stickyNotes) {
        return Arrays.stream(stickyNotes.getFields()).filter(field -> field.getName().startsWith("REPOSITORY_")).map(field -> {
            try {
                return (String)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).toList();
    }

    private CompletableFuture<Void> loadDependencyAsync(String id, Dependency dependency, LibraryManager libraryManager) {
        return loadingLibraries.computeIfAbsent(dependency, key -> CompletableFuture.runAsync(() -> {
            try {
                Library.Builder libraryBuilder = this.createLibraryBuilder(dependency);
                Library library = libraryBuilder.build();
                this.retryWithDelay(() -> libraryManager.loadLibrary(library), 5, 1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, executorService));
    }

    private void retryWithDelay(Runnable task, int maxRetries, long delayMillis) throws Exception {
        int attempt = 0;
        while (attempt < maxRetries) {
            try {
                task.run();
                return;
            }
            catch (UncheckedIOException e) {
                if (e.getCause() instanceof FileSystemException) {
                    if (++attempt >= maxRetries) {
                        throw e;
                    }
                    Thread.sleep(delayMillis);
                    continue;
                }
                throw e;
            }
        }
    }

    private Library.Builder createLibraryBuilder(Dependency dependency) {
        Library.Builder libraryBuilder = Library.builder().groupId(dependency.getGroup()).artifactId(dependency.getName()).version(dependency.getVersion()).resolveTransitiveDependencies(false);
        if (this.relocate.booleanValue() && (dependency.getRelocation() != null || !dependency.isStickyLoad())) {
            for (Map.Entry<String, String> relocation : relocations.entrySet()) {
                libraryBuilder.relocate(relocation.getKey(), relocation.getValue());
            }
        }
        return libraryBuilder;
    }

    private CompletableFuture<Void> resolveTransitiveDependenciesAsync(String id, TransitiveDependencyHelper transitiveDependencyHelper, Dependency dependency) {
        return CompletableFuture.runAsync(() -> {
            dependency.setTransitiveResolved(this.transitiveExcluded.stream().anyMatch(excluded -> dependency.getName().contains((CharSequence)excluded)));
            dependency.setTransitiveDependencies(this.resolveTransitiveLibraries(id, transitiveDependencyHelper, dependency).stream().map(library -> new Dependency(library.getGroupId(), library.getArtifactId(), library.getVersion(), dependency.getRelocation(), dependency.isStickyLoad())).toList());
        }, executorService);
    }

    private List<Library> resolveTransitiveLibraries(String id, TransitiveDependencyHelper transitiveDependencyHelper, Dependency dependency) {
        ArrayList<Library> transitiveDependencies = new ArrayList<Library>();
        if (this.transitiveExcluded.stream().anyMatch(excluded -> dependency.getName().toLowerCase().contains((CharSequence)excluded))) {
            return Collections.emptyList();
        }
        try {
            Collection<Library> libraries = transitiveDependencyHelper.findTransitiveLibraries(this.createLibraryBuilder(dependency).build());
            transitiveDependencies.addAll(libraries);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return transitiveDependencies;
    }

    private String getLatestVersion(List<String> versions) {
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        return versions.stream().max((v1, v2) -> {
            String[] parts1 = v1.split("\\.");
            String[] parts2 = v2.split("\\.");
            for (int i = 0; i < Math.min(parts1.length, parts2.length); ++i) {
                try {
                    int num1 = Integer.parseInt(parts1[i]);
                    int num2 = Integer.parseInt(parts2[i]);
                    if (num1 == num2) continue;
                    return Integer.compare(num1, num2);
                }
                catch (NumberFormatException e) {
                    int compare = parts1[i].compareTo(parts2[i]);
                    if (compare == 0) continue;
                    return compare;
                }
            }
            return Integer.compare(parts1.length, parts2.length);
        }).orElse(null);
    }

    private List<String> getAllVersions(File libDirectory, String group, String name) {
        File[] files = this.versionsDirectory(libDirectory, group, name).listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).map(File::getName).collect(Collectors.toList());
    }

    private List<Dependency> getAllProjectsCachedDependencies(Logger logger, File libDirectory) {
        ArrayList<Dependency> allDependencies = new ArrayList<Dependency>();
        File[] cacheFiles = libDirectory.listFiles((dir, name) -> name.endsWith(".dat"));
        if (cacheFiles == null) {
            return allDependencies;
        }
        for (File cacheFile : cacheFiles) {
            try {
                Set<Dependency> cachedDependencies = new DependencyCache("temp", libDirectory).loadCacheFromFile(logger, cacheFile);
                allDependencies.addAll(cachedDependencies);
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
        }
        return allDependencies;
    }

    private void deleteOldVersionDirectory(File libFolder, String group, String name, String version) {
        String groupPath = group.replace("{}", "/").replace(".", "/");
        String path = groupPath + "/" + name + "/" + version;
        File versionDir = new File(libFolder, path);
        if (versionDir.exists() && versionDir.isDirectory()) {
            try {
                this.deleteDirectory(versionDir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File versionsDirectory(File libFolder, String group, String name) {
        String groupPath = group.replace("{}", "/").replace(".", "/");
        File dependencyVersionsFile = new File(libFolder, groupPath + "/" + name);
        return dependencyVersionsFile;
    }

    private File versionDirectory(File libFolder, String group, String name, String version) {
        String groupPath = group.replace("{}", "/").replace(".", "/");
        return new File(libFolder, groupPath + "/" + name + "/" + version);
    }

    private boolean isFileInUse(File file) {
        boolean bl;
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        raf.close();
        return bl;
    }

    private void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        long now = System.currentTimeMillis();
        long fiveMinutesMillis = 900000L;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                if (this.isFileInUse(file) || file.lastModified() > now - fiveMinutesMillis) continue;
                file.delete();
            }
        }
        if (this.isFileInUse(directory) || directory.lastModified() > now - fiveMinutesMillis) {
            return;
        }
        if (!directory.delete()) {
            directory.deleteOnExit();
            System.err.println("Warning: Failed to delete directory (in use?): " + directory.getAbsolutePath());
        }
    }

    private void logProgress(Logger logger, List<CompletableFuture<Void>> futures, int totalDependencies) {
        long completed = futures.stream().filter(CompletableFuture::isDone).count();
        int percentage = (int)(completed * 100L / (long)totalDependencies);
        logger.info(String.format("Progress: %d%% (%d/%d dependencies loaded)", percentage, completed, totalDependencies));
    }

    public static File generateLibDirectory(File root, boolean withLibDirectory) {
        File file = !withLibDirectory ? new File(root, "stickynote") : new File(new File(root, "stickynote"), "lib");
        return file;
    }
}

