/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.bukkit.api;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\n\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "serviceId", "", "<init>", "(Lorg/bukkit/plugin/Plugin;I)V", "metricsBase", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$MetricsBase;", "shutdown", "", "addCustomChart", "chart", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$CustomChart;", "appendPlatformData", "builder", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder;", "appendServiceData", "playerAmount", "getPlayerAmount", "()I", "MetricsBase", "AdvancedBarChart", "SimplePie", "DrilldownPie", "SingleLineChart", "MultiLineChart", "AdvancedPie", "CustomChart", "SimpleBarChart", "JsonObjectBuilder", "sayanvanish-bukkit"})
public final class Metrics {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final MetricsBase metricsBase;

    public Metrics(@NotNull Plugin plugin, int serviceId) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
        File bStatsFolder = new File(this.plugin.getDataFolder().getParentFile(), "bStats");
        File configFile = new File(bStatsFolder, "config.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)configFile);
        Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration, (String)"loadConfiguration(...)");
        YamlConfiguration config = yamlConfiguration;
        if (!config.isSet("serverUuid")) {
            config.addDefault("enabled", (Object)true);
            config.addDefault("serverUuid", (Object)UUID.randomUUID().toString());
            config.addDefault("logFailedRequests", (Object)false);
            config.addDefault("logSentData", (Object)false);
            config.addDefault("logResponseStatusText", (Object)false);
            config.options().header("bStats (https://bStats.org) collects some basic information for plugin authors, like how\nmany people use their plugin and their total player count. It's recommended to keep bStats\nenabled, but if you're not comfortable with this, you can turn this setting off. There is no\nperformance penalty associated with having metrics enabled, and data sent to bStats is fully\nanonymous.").copyDefaults(true);
            try {
                config.save(configFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean enabled = config.getBoolean("enabled", true);
        String serverUUID = config.getString("serverUuid");
        boolean logErrors = config.getBoolean("logFailedRequests", false);
        boolean logSentData = config.getBoolean("logSentData", false);
        boolean logResponseStatusText = config.getBoolean("logResponseStatusText", false);
        boolean isFolia = false;
        try {
            isFolia = Class.forName("io.papermc.paper.threadedregions.RegionizedServer") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.metricsBase = new MetricsBase("bukkit", serverUUID, serviceId, enabled, arg_0 -> Metrics._init_$lambda$0(this, arg_0), arg_0 -> Metrics._init_$lambda$1(this, arg_0), isFolia ? null : arg_0 -> Metrics._init_$lambda$2(this, arg_0), () -> Metrics._init_$lambda$3(this), (arg_0, arg_1) -> Metrics._init_$lambda$4(this, arg_0, arg_1), arg_0 -> Metrics._init_$lambda$5(this, arg_0), logErrors, logSentData, logResponseStatusText, false);
    }

    public final void shutdown() {
        this.metricsBase.shutdown();
    }

    public final void addCustomChart(@NotNull CustomChart chart) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        this.metricsBase.addCustomChart(chart);
    }

    private final void appendPlatformData(JsonObjectBuilder builder) {
        builder.appendField("playerAmount", this.getPlayerAmount());
        builder.appendField("onlineMode", Bukkit.getOnlineMode() ? 1 : 0);
        String string = Bukkit.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
        builder.appendField("bukkitVersion", string);
        String string2 = Bukkit.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        builder.appendField("bukkitName", string2);
        String string3 = System.getProperty("java.version");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
        builder.appendField("javaVersion", string3);
        String string4 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
        builder.appendField("osName", string4);
        String string5 = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getProperty(...)");
        builder.appendField("osArch", string5);
        String string6 = System.getProperty("os.version");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getProperty(...)");
        builder.appendField("osVersion", string6);
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    private final void appendServiceData(JsonObjectBuilder builder) {
        String string = this.plugin.getDescription().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
        builder.appendField("pluginVersion", string);
    }

    private final int getPlayerAmount() {
        try {
            int n;
            Method onlinePlayersMethod = Class.forName("org.bukkit.Server").getMethod("getOnlinePlayers", new Class[0]);
            if (Intrinsics.areEqual(onlinePlayersMethod.getReturnType(), Collection.class)) {
                Object object = onlinePlayersMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Collection<*>");
                n = ((Collection)object).size();
            } else {
                Object object = onlinePlayersMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<org.bukkit.entity.Player?>");
                n = ((Player[])object).length;
            }
            return n;
        }
        catch (Exception e) {
            return Bukkit.getOnlinePlayers().size();
        }
    }

    private static final void _init_$lambda$0(Metrics this$0, JsonObjectBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this$0.appendPlatformData(builder);
    }

    private static final void _init_$lambda$1(Metrics this$0, JsonObjectBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this$0.appendServiceData(builder);
    }

    private static final void _init_$lambda$2(Metrics this$0, Runnable submitDataTask) {
        BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
        Plugin plugin = this$0.plugin;
        Runnable runnable = submitDataTask;
        Intrinsics.checkNotNull((Object)runnable);
        bukkitScheduler.runTask(plugin, runnable);
    }

    private static final Boolean _init_$lambda$3(Metrics this$0) {
        return this$0.plugin.isEnabled();
    }

    private static final void _init_$lambda$4(Metrics this$0, String message, Throwable error) {
        this$0.plugin.getLogger().log(Level.WARNING, message, error);
    }

    private static final void _init_$lambda$5(Metrics this$0, String message) {
        this$0.plugin.getLogger().log(Level.INFO, message);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tR \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$AdvancedBarChart;", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$CustomChart;", "chartId", "", "callable", "Ljava/util/concurrent/Callable;", "", "", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/Callable;)V", "chartData", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "getChartData", "()Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "sayanvanish-bukkit"})
    public static final class AdvancedBarChart
    extends CustomChart {
        @NotNull
        private final Callable<Map<String, int[]>> callable;

        public AdvancedBarChart(@NotNull String chartId, @NotNull Callable<Map<String, int[]>> callable) {
            Intrinsics.checkNotNullParameter((Object)chartId, (String)"chartId");
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            super(chartId);
            this.callable = callable;
        }

        @Override
        @Nullable
        protected JsonObjectBuilder.JsonObject getChartData() throws Exception {
            JsonObjectBuilder valuesBuilder = new JsonObjectBuilder();
            Map<String, int[]> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, int[]> entry : map.entrySet()) {
                String key = entry.getKey();
                int[] value = entry.getValue();
                if (value.length == 0) continue;
                allSkipped = false;
                valuesBuilder.appendField(key, value);
            }
            if (allSkipped) {
                return null;
            }
            return new JsonObjectBuilder().appendField("values", valuesBuilder.build()).build();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tR \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$AdvancedPie;", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$CustomChart;", "chartId", "", "callable", "Ljava/util/concurrent/Callable;", "", "", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/Callable;)V", "chartData", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "getChartData", "()Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "sayanvanish-bukkit"})
    public static final class AdvancedPie
    extends CustomChart {
        @NotNull
        private final Callable<Map<String, Integer>> callable;

        public AdvancedPie(@NotNull String chartId, @NotNull Callable<Map<String, Integer>> callable) {
            Intrinsics.checkNotNullParameter((Object)chartId, (String)"chartId");
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            super(chartId);
            this.callable = callable;
        }

        @Override
        @Nullable
        protected JsonObjectBuilder.JsonObject getChartData() throws Exception {
            JsonObjectBuilder valuesBuilder = new JsonObjectBuilder();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                String key = entry.getKey();
                int value = ((Number)entry.getValue()).intValue();
                if (value == 0) continue;
                allSkipped = false;
                valuesBuilder.appendField(key, value);
            }
            if (allSkipped) {
                return null;
            }
            return new JsonObjectBuilder().appendField("values", valuesBuilder.build()).build();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0016\u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$CustomChart;", "", "chartId", "", "<init>", "(Ljava/lang/String;)V", "getRequestJsonObject", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "errorLogger", "Ljava/util/function/BiConsumer;", "", "logErrors", "", "chartData", "getChartData", "()Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "sayanvanish-bukkit"})
    @SourceDebugExtension(value={"SMAP\nMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Metrics.kt\norg/sayandev/sayanvanish/bukkit/api/Metrics$CustomChart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,875:1\n1#2:876\n*E\n"})
    public static abstract class CustomChart {
        @NotNull
        private final String chartId;

        protected CustomChart(@NotNull String chartId) {
            Intrinsics.checkNotNullParameter((Object)chartId, (String)"chartId");
            this.chartId = chartId;
        }

        @Nullable
        public final JsonObjectBuilder.JsonObject getRequestJsonObject(@NotNull BiConsumer<String, Throwable> errorLogger, boolean logErrors) {
            Intrinsics.checkNotNullParameter(errorLogger, (String)"errorLogger");
            JsonObjectBuilder builder = new JsonObjectBuilder();
            builder.appendField("chartId", this.chartId);
            try {
                JsonObjectBuilder.JsonObject jsonObject = this.getChartData();
                if (jsonObject == null) {
                    return null;
                }
                JsonObjectBuilder.JsonObject data = jsonObject;
                builder.appendField("data", data);
            }
            catch (Throwable t) {
                if (logErrors) {
                    errorLogger.accept("Failed to get data for custom chart with id " + this.chartId, t);
                }
                return null;
            }
            return builder.build();
        }

        @Nullable
        protected abstract JsonObjectBuilder.JsonObject getChartData() throws Exception;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012$\u0010\u0004\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tR,\u0010\u0004\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$DrilldownPie;", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$CustomChart;", "chartId", "", "callable", "Ljava/util/concurrent/Callable;", "", "", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/Callable;)V", "chartData", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "getChartData", "()Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "sayanvanish-bukkit"})
    public static final class DrilldownPie
    extends CustomChart {
        @NotNull
        private final Callable<Map<String, Map<String, Integer>>> callable;

        public DrilldownPie(@NotNull String chartId, @NotNull Callable<Map<String, Map<String, Integer>>> callable) {
            Intrinsics.checkNotNullParameter((Object)chartId, (String)"chartId");
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            super(chartId);
            this.callable = callable;
        }

        @Override
        @Nullable
        protected JsonObjectBuilder.JsonObject getChartData() throws Exception {
            JsonObjectBuilder valuesBuilder = new JsonObjectBuilder();
            Map<String, Map<String, Integer>> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean reallyAllSkipped = true;
            Iterator<Map.Entry<String, Map<String, Integer>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().getKey();
                JsonObjectBuilder valueBuilder = new JsonObjectBuilder();
                boolean allSkipped = true;
                Map<String, Integer> map2 = map.get(key);
                Intrinsics.checkNotNull(map2);
                for (Map.Entry<String, Integer> entry : map2.entrySet()) {
                    String key1 = entry.getKey();
                    int value = ((Number)entry.getValue()).intValue();
                    valueBuilder.appendField(key1, value);
                    allSkipped = false;
                }
                if (allSkipped) continue;
                reallyAllSkipped = false;
                valuesBuilder.appendField(key, valueBuilder.build());
            }
            if (reallyAllSkipped) {
                return null;
            }
            return new JsonObjectBuilder().appendField("values", valuesBuilder.build()).build();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J!\u0010\f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0014J!\u0010\f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0006\u0010\u0019\u001a\u00020\u0010R\u0016\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder;", "", "<init>", "()V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "hasAtLeastOneField", "", "appendNull", "key", "", "appendField", "value", "", "object", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "values", "", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder;", "", "(Ljava/lang/String;[Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;)Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder;", "appendFieldUnescaped", "", "escapedValue", "build", "JsonObject", "Companion", "sayanvanish-bukkit"})
    @SourceDebugExtension(value={"SMAP\nMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Metrics.kt\norg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,875:1\n1#2:876\n*E\n"})
    public static final class JsonObjectBuilder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private StringBuilder builder = new StringBuilder();
        private boolean hasAtLeastOneField;

        public JsonObjectBuilder() {
            StringBuilder stringBuilder = this.builder;
            Intrinsics.checkNotNull((Object)stringBuilder);
            stringBuilder.append("{");
        }

        @NotNull
        public final JsonObjectBuilder appendNull(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.appendFieldUnescaped(key, "null");
            return this;
        }

        @NotNull
        public final JsonObjectBuilder appendField(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.appendFieldUnescaped(key, "\"" + JsonObjectBuilder.Companion.escape(value) + "\"");
            return this;
        }

        @NotNull
        public final JsonObjectBuilder appendField(@NotNull String key, int value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.appendFieldUnescaped(key, String.valueOf(value));
            return this;
        }

        @NotNull
        public final JsonObjectBuilder appendField(@NotNull String key, @NotNull JsonObject object) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)object, (String)"object");
            this.appendFieldUnescaped(key, object.toString());
            return this;
        }

        @NotNull
        public final JsonObjectBuilder appendField(@NotNull String key, @NotNull String[] values) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            String escapedValues = Arrays.stream(values).map(arg_0 -> JsonObjectBuilder.appendField$lambda$4(JsonObjectBuilder::appendField$lambda$3, arg_0)).collect(Collectors.joining(","));
            this.appendFieldUnescaped(key, "[" + escapedValues + "]");
            return this;
        }

        @NotNull
        public final JsonObjectBuilder appendField(@NotNull String key, @NotNull int[] values) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            String escapedValues = Arrays.stream(values).mapToObj(JsonObjectBuilder::appendField$lambda$6).collect(Collectors.joining(","));
            this.appendFieldUnescaped(key, "[" + escapedValues + "]");
            return this;
        }

        @NotNull
        public final JsonObjectBuilder appendField(@NotNull String key, @NotNull JsonObject[] values) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            String escapedValues = Arrays.stream(values).map(arg_0 -> JsonObjectBuilder.appendField$lambda$9(JsonObjectBuilder::appendField$lambda$8, arg_0)).collect(Collectors.joining(","));
            this.appendFieldUnescaped(key, "[" + escapedValues + "]");
            return this;
        }

        private final void appendFieldUnescaped(String key, String escapedValue) {
            if (this.builder == null) {
                boolean bl = false;
                String string = "JSON has already been built";
                throw new IllegalStateException(string.toString());
            }
            if (key == null) {
                boolean bl = false;
                String string = "JSON key must not be null";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.hasAtLeastOneField) {
                StringBuilder stringBuilder = this.builder;
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.append(",");
            }
            StringBuilder stringBuilder = this.builder;
            Intrinsics.checkNotNull((Object)stringBuilder);
            stringBuilder.append("\"").append(JsonObjectBuilder.Companion.escape(key)).append("\":").append(escapedValue);
            this.hasAtLeastOneField = true;
        }

        @NotNull
        public final JsonObject build() {
            if (this.builder == null) {
                boolean bl = false;
                String string = "JSON has already been built";
                throw new IllegalStateException(string.toString());
            }
            StringBuilder stringBuilder = this.builder;
            Intrinsics.checkNotNull((Object)stringBuilder);
            String string = stringBuilder.append("}").toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            JsonObject object = new JsonObject(string);
            this.builder = null;
            return object;
        }

        private static final String appendField$lambda$3(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return "\"" + JsonObjectBuilder.Companion.escape(value) + "\"";
        }

        private static final String appendField$lambda$4(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final String appendField$lambda$6(int i) {
            return String.valueOf(i);
        }

        private static final String appendField$lambda$8(JsonObject obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj.toString();
        }

        private static final String appendField$lambda$9(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$Companion;", "", "<init>", "()V", "escape", "", "value", "sayanvanish-bukkit"})
        public static final class Companion {
            private Companion() {
            }

            private final String escape(String value) {
                StringBuilder builder = new StringBuilder();
                int n = value.length();
                for (int i = 0; i < n; ++i) {
                    char c = value.charAt(i);
                    StringBuilder stringBuilder = c == '\"' ? builder.append("\\\"") : (c == '\\' ? builder.append("\\\\") : (Intrinsics.compare((int)c, (int)15) <= 0 ? builder.append("\\u000").append(Integer.toHexString(c)) : (Intrinsics.compare((int)c, (int)31) <= 0 ? builder.append("\\u00").append(Integer.toHexString(c)) : builder.append(c))));
                }
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "toString", "sayanvanish-bukkit"})
        public static final class JsonObject {
            @NotNull
            private final String value;

            public JsonObject(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.value = value;
            }

            @NotNull
            public String toString() {
                return this.value;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0001*B\u00ab\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\n\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010\u0012\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012\u0012\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\n\u0012\u0006\u0010\u0015\u001a\u00020\b\u0012\u0006\u0010\u0016\u001a\u00020\b\u0012\u0006\u0010\u0017\u001a\u00020\b\u0012\u0006\u0010\u0018\u001a\u00020\b\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020!J\b\u0010$\u001a\u00020!H\u0002J\b\u0010%\u001a\u00020!H\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020!H\u0002R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$MetricsBase;", "", "platform", "", "serverUuid", "serviceId", "", "enabled", "", "appendPlatformDataConsumer", "Ljava/util/function/Consumer;", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder;", "appendServiceDataConsumer", "submitTaskConsumer", "Ljava/lang/Runnable;", "checkServiceEnabledSupplier", "Ljava/util/function/Supplier;", "errorLogger", "Ljava/util/function/BiConsumer;", "", "infoLogger", "logErrors", "logSentData", "logResponseStatusText", "skipRelocateCheck", "<init>", "(Ljava/lang/String;Ljava/lang/String;IZLjava/util/function/Consumer;Ljava/util/function/Consumer;Ljava/util/function/Consumer;Ljava/util/function/Supplier;Ljava/util/function/BiConsumer;Ljava/util/function/Consumer;ZZZZ)V", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "customCharts", "", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$CustomChart;", "addCustomChart", "", "chart", "shutdown", "startSubmitting", "submitData", "sendData", "data", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "checkRelocation", "Companion", "sayanvanish-bukkit"})
    @SourceDebugExtension(value={"SMAP\nMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Metrics.kt\norg/sayandev/sayanvanish/bukkit/api/Metrics$MetricsBase\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,875:1\n37#2:876\n36#2,3:877\n1#3:880\n*S KotlinDebug\n*F\n+ 1 Metrics.kt\norg/sayandev/sayanvanish/bukkit/api/Metrics$MetricsBase\n*L\n316#1:876\n316#1:877,3\n*E\n"})
    public static final class MetricsBase {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ScheduledExecutorService scheduler;
        @NotNull
        private final String platform;
        @NotNull
        private final String serverUuid;
        private final int serviceId;
        @NotNull
        private final Consumer<JsonObjectBuilder> appendPlatformDataConsumer;
        @NotNull
        private final Consumer<JsonObjectBuilder> appendServiceDataConsumer;
        @Nullable
        private final Consumer<Runnable> submitTaskConsumer;
        @NotNull
        private final Supplier<Boolean> checkServiceEnabledSupplier;
        @NotNull
        private final BiConsumer<String, Throwable> errorLogger;
        @NotNull
        private final Consumer<String> infoLogger;
        private final boolean logErrors;
        private final boolean logSentData;
        private final boolean logResponseStatusText;
        @NotNull
        private final Set<CustomChart> customCharts;
        private final boolean enabled;
        @NotNull
        public static final String METRICS_VERSION = "3.1.0";
        @NotNull
        private static final String REPORT_URL = "https://bStats.org/api/v2/data/%s";

        public MetricsBase(@NotNull String platform, @Nullable String serverUuid, int serviceId, boolean enabled, @NotNull Consumer<JsonObjectBuilder> appendPlatformDataConsumer, @NotNull Consumer<JsonObjectBuilder> appendServiceDataConsumer, @Nullable Consumer<Runnable> submitTaskConsumer, @NotNull Supplier<Boolean> checkServiceEnabledSupplier, @NotNull BiConsumer<String, Throwable> errorLogger, @NotNull Consumer<String> infoLogger, boolean logErrors, boolean logSentData, boolean logResponseStatusText, boolean skipRelocateCheck) {
            Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
            Intrinsics.checkNotNullParameter(appendPlatformDataConsumer, (String)"appendPlatformDataConsumer");
            Intrinsics.checkNotNullParameter(appendServiceDataConsumer, (String)"appendServiceDataConsumer");
            Intrinsics.checkNotNullParameter(checkServiceEnabledSupplier, (String)"checkServiceEnabledSupplier");
            Intrinsics.checkNotNullParameter(errorLogger, (String)"errorLogger");
            Intrinsics.checkNotNullParameter(infoLogger, (String)"infoLogger");
            this.customCharts = new HashSet();
            ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, MetricsBase::_init_$lambda$0);
            scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.scheduler = scheduler;
            this.platform = platform;
            String string = serverUuid;
            Intrinsics.checkNotNull((Object)string);
            this.serverUuid = string;
            this.serviceId = serviceId;
            this.enabled = enabled;
            this.appendPlatformDataConsumer = appendPlatformDataConsumer;
            this.appendServiceDataConsumer = appendServiceDataConsumer;
            this.submitTaskConsumer = submitTaskConsumer;
            this.checkServiceEnabledSupplier = checkServiceEnabledSupplier;
            this.errorLogger = errorLogger;
            this.infoLogger = infoLogger;
            this.logErrors = logErrors;
            this.logSentData = logSentData;
            this.logResponseStatusText = logResponseStatusText;
            if (!skipRelocateCheck) {
                this.checkRelocation();
            }
            if (enabled) {
                this.startSubmitting();
            }
        }

        public final void addCustomChart(@NotNull CustomChart chart) {
            Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
            this.customCharts.add(chart);
        }

        public final void shutdown() {
            this.scheduler.shutdown();
        }

        private final void startSubmitting() {
            Runnable submitTask = () -> MetricsBase.startSubmitting$lambda$2(this);
            long initialDelay = (long)((double)60000 * ((double)3 + Math.random() * (double)3));
            long secondDelay = (long)((double)60000 * (Math.random() * (double)30));
            this.scheduler.schedule(submitTask, initialDelay, TimeUnit.MILLISECONDS);
            this.scheduler.scheduleAtFixedRate(submitTask, initialDelay + secondDelay, 1800000L, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - void declaration
         */
        private final void submitData() {
            void $this$toTypedArray$iv;
            JsonObjectBuilder baseJsonBuilder = new JsonObjectBuilder();
            this.appendPlatformDataConsumer.accept(baseJsonBuilder);
            JsonObjectBuilder serviceJsonBuilder = new JsonObjectBuilder();
            this.appendServiceDataConsumer.accept(serviceJsonBuilder);
            Collection<Object> collection = this.customCharts.stream().map(arg_0 -> MetricsBase.submitData$lambda$4(arg_0 -> MetricsBase.submitData$lambda$3(this, arg_0), arg_0)).filter(arg_0 -> MetricsBase.submitData$lambda$6(MetricsBase::submitData$lambda$5, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"toList(...)");
            collection = collection;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            JsonObjectBuilder.JsonObject[] chartData = thisCollection$iv.toArray(new JsonObjectBuilder.JsonObject[0]);
            serviceJsonBuilder.appendField("id", this.serviceId);
            serviceJsonBuilder.appendField("customCharts", chartData);
            baseJsonBuilder.appendField("service", serviceJsonBuilder.build());
            baseJsonBuilder.appendField("serverUUID", this.serverUuid);
            baseJsonBuilder.appendField("metricsVersion", METRICS_VERSION);
            JsonObjectBuilder.JsonObject data = baseJsonBuilder.build();
            this.scheduler.execute(() -> MetricsBase.submitData$lambda$7(this, data));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendData(JsonObjectBuilder.JsonObject data) throws Exception {
            Object object;
            if (this.logSentData) {
                this.infoLogger.accept("Sent bStats metrics data: " + data);
            }
            String string = REPORT_URL;
            Object object2 = new Object[]{this.platform};
            String string2 = String.format(string, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String url = string2;
            URLConnection uRLConnection = new URL(url).openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
            HttpsURLConnection connection = (HttpsURLConnection)uRLConnection;
            byte[] compressedData = MetricsBase.Companion.compress(data.toString());
            connection.setRequestMethod("POST");
            connection.addRequestProperty("Accept", "application/json");
            connection.addRequestProperty("Connection", "close");
            connection.addRequestProperty("Content-Encoding", "gzip");
            Intrinsics.checkNotNull((Object)compressedData);
            connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Metrics-Service/1");
            connection.setDoOutput(true);
            object2 = new DataOutputStream(connection.getOutputStream());
            Object object3 = null;
            try {
                DataOutputStream outputStream = (DataOutputStream)object2;
                boolean bl = false;
                outputStream.write(compressedData);
                object = Unit.INSTANCE;
            }
            catch (Throwable bl) {
                object3 = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
            StringBuilder builder = new StringBuilder();
            object3 = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            object = null;
            try {
                BufferedReader bufferedReader = (BufferedReader)object3;
                boolean bl = false;
                String line = null;
                while (true) {
                    String string3;
                    String it = string3 = bufferedReader.readLine();
                    boolean bl2 = false;
                    line = it;
                    if (string3 == null) break;
                    builder.append(line);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)object);
            }
            if (this.logResponseStatusText) {
                this.infoLogger.accept("Sent data to bStats and received response: " + builder);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void checkRelocation() {
            if (System.getProperty("bstats.relocatecheck") != null) {
                if (Intrinsics.areEqual((Object)System.getProperty("bstats.relocatecheck"), (Object)"false")) return;
            }
            byte[] byArray = new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115};
            String defaultPackage = new String(byArray, Charsets.UTF_8);
            byte[] byArray2 = new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101};
            String examplePackage = new String(byArray2, Charsets.UTF_8);
            String string = MetricsBase.class.getPackage().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)defaultPackage, (boolean)false, (int)2, null)) {
                String string2 = MetricsBase.class.getPackage().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)examplePackage, (boolean)false, (int)2, null)) {
                    return;
                }
            }
            boolean bl = false;
            if (bl) return;
            boolean bl2 = false;
            String string3 = "bStats Metrics class has not been relocated correctly!";
            throw new IllegalStateException(string3.toString());
        }

        private static final Thread _init_$lambda$0(Runnable task) {
            Thread thread = new Thread(task, "bStats-Metrics");
            thread.setDaemon(true);
            return thread;
        }

        private static final void startSubmitting$lambda$2$lambda$1(MetricsBase this$0) {
            this$0.submitData();
        }

        private static final void startSubmitting$lambda$2(MetricsBase this$0) {
            if (!this$0.enabled || !this$0.checkServiceEnabledSupplier.get().booleanValue()) {
                this$0.scheduler.shutdown();
                return;
            }
            if (this$0.submitTaskConsumer != null) {
                this$0.submitTaskConsumer.accept(() -> MetricsBase.startSubmitting$lambda$2$lambda$1(this$0));
            } else {
                this$0.submitData();
            }
        }

        private static final JsonObjectBuilder.JsonObject submitData$lambda$3(MetricsBase this$0, CustomChart customChart) {
            Intrinsics.checkNotNullParameter((Object)customChart, (String)"customChart");
            return customChart.getRequestJsonObject(this$0.errorLogger, this$0.logErrors);
        }

        private static final JsonObjectBuilder.JsonObject submitData$lambda$4(Function1 $tmp0, Object p0) {
            return (JsonObjectBuilder.JsonObject)$tmp0.invoke(p0);
        }

        private static final boolean submitData$lambda$5(JsonObjectBuilder.JsonObject obj) {
            return Objects.nonNull(obj);
        }

        private static final boolean submitData$lambda$6(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void submitData$lambda$7(MetricsBase this$0, JsonObjectBuilder.JsonObject $data) {
            block2: {
                try {
                    this$0.sendData($data);
                }
                catch (Exception e) {
                    if (!this$0.logErrors) break block2;
                    this$0.errorLogger.accept("Could not submit bStats metrics data", e);
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$MetricsBase$Companion;", "", "<init>", "()V", "METRICS_VERSION", "", "REPORT_URL", "compress", "", "str", "sayanvanish-bukkit"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final byte[] compress(String str) throws IOException {
                if (str == null) {
                    return null;
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                Closeable closeable = new GZIPOutputStream(outputStream);
                Throwable throwable = null;
                try {
                    GZIPOutputStream gzip = (GZIPOutputStream)closeable;
                    boolean bl = false;
                    String string = str;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    byte[] byArray = string.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    gzip.write(byArray);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return outputStream.toByteArray();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tR \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$MultiLineChart;", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$CustomChart;", "chartId", "", "callable", "Ljava/util/concurrent/Callable;", "", "", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/Callable;)V", "chartData", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "getChartData", "()Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "sayanvanish-bukkit"})
    public static final class MultiLineChart
    extends CustomChart {
        @NotNull
        private final Callable<Map<String, Integer>> callable;

        public MultiLineChart(@NotNull String chartId, @NotNull Callable<Map<String, Integer>> callable) {
            Intrinsics.checkNotNullParameter((Object)chartId, (String)"chartId");
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            super(chartId);
            this.callable = callable;
        }

        @Override
        @Nullable
        protected JsonObjectBuilder.JsonObject getChartData() throws Exception {
            JsonObjectBuilder valuesBuilder = new JsonObjectBuilder();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                String key = entry.getKey();
                int value = ((Number)entry.getValue()).intValue();
                if (value == 0) continue;
                allSkipped = false;
                valuesBuilder.appendField(key, value);
            }
            if (allSkipped) {
                return null;
            }
            return new JsonObjectBuilder().appendField("values", valuesBuilder.build()).build();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tR \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$SimpleBarChart;", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$CustomChart;", "chartId", "", "callable", "Ljava/util/concurrent/Callable;", "", "", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/Callable;)V", "chartData", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "getChartData", "()Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "sayanvanish-bukkit"})
    public static final class SimpleBarChart
    extends CustomChart {
        @NotNull
        private final Callable<Map<String, Integer>> callable;

        public SimpleBarChart(@NotNull String chartId, @NotNull Callable<Map<String, Integer>> callable) {
            Intrinsics.checkNotNullParameter((Object)chartId, (String)"chartId");
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            super(chartId);
            this.callable = callable;
        }

        @Override
        @Nullable
        protected JsonObjectBuilder.JsonObject getChartData() throws Exception {
            JsonObjectBuilder valuesBuilder = new JsonObjectBuilder();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                String key = entry.getKey();
                int value = ((Number)entry.getValue()).intValue();
                int[] nArray = new int[]{value};
                valuesBuilder.appendField(key, nArray);
            }
            return new JsonObjectBuilder().appendField("values", valuesBuilder.build()).build();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$SimplePie;", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$CustomChart;", "chartId", "", "callable", "Ljava/util/concurrent/Callable;", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/Callable;)V", "chartData", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "getChartData", "()Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "sayanvanish-bukkit"})
    public static final class SimplePie
    extends CustomChart {
        @NotNull
        private final Callable<String> callable;

        public SimplePie(@NotNull String chartId, @NotNull Callable<String> callable) {
            Intrinsics.checkNotNullParameter((Object)chartId, (String)"chartId");
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            super(chartId);
            this.callable = callable;
        }

        @Override
        @Nullable
        protected JsonObjectBuilder.JsonObject getChartData() throws Exception {
            String value = this.callable.call();
            if (value == null || ((CharSequence)value).length() == 0) {
                return null;
            }
            return new JsonObjectBuilder().appendField("value", value).build();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/sayandev/sayanvanish/bukkit/api/Metrics$SingleLineChart;", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$CustomChart;", "chartId", "", "callable", "Ljava/util/concurrent/Callable;", "", "<init>", "(Ljava/lang/String;Ljava/util/concurrent/Callable;)V", "chartData", "Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "getChartData", "()Lorg/sayandev/sayanvanish/bukkit/api/Metrics$JsonObjectBuilder$JsonObject;", "sayanvanish-bukkit"})
    public static final class SingleLineChart
    extends CustomChart {
        @NotNull
        private final Callable<Integer> callable;

        public SingleLineChart(@NotNull String chartId, @NotNull Callable<Integer> callable) {
            Intrinsics.checkNotNullParameter((Object)chartId, (String)"chartId");
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            super(chartId);
            this.callable = callable;
        }

        @Override
        @Nullable
        protected JsonObjectBuilder.JsonObject getChartData() throws Exception {
            Integer value;
            Integer n = value = this.callable.call();
            if (n != null && n == 0) {
                return null;
            }
            JsonObjectBuilder jsonObjectBuilder = new JsonObjectBuilder();
            Intrinsics.checkNotNull((Object)value);
            return jsonObjectBuilder.appendField("value", value).build();
        }
    }
}

