/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.lib.loader.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.sayandev.sayanvanish.lib.loader.common.Dependency;

public class DependencyCache {
    private final String project;
    private final String cacheFileName;
    private final File cacheFile;

    public DependencyCache(String project, File dataFolder) {
        this.project = project;
        this.cacheFileName = "dependency_cache_" + project + ".dat";
        this.cacheFile = new File(dataFolder, this.cacheFileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<Dependency> loadCache() {
        if (!this.cacheFile.exists()) return new HashSet<Dependency>();
        if (this.cacheFile.length() == 0L) {
            return new HashSet<Dependency>();
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.cacheFile));){
            Object obj = ois.readObject();
            if (obj instanceof Set) {
                Set<Dependency> set = this.handleDeserializedSet((Set)obj);
                return set;
            }
            HashSet<Dependency> hashSet = new HashSet<Dependency>();
            return hashSet;
        }
        catch (IOException | ClassNotFoundException e) {
            this.cacheFile.delete();
            e.printStackTrace();
            return new HashSet<Dependency>();
        }
    }

    private Set<Dependency> handleDeserializedSet(Set<?> set) {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (Object o : set) {
            result.add(this.fromObject(o));
        }
        return result;
    }

    private Dependency fromObject(Object obj) {
        Class<?> clazz = obj.getClass();
        try {
            Dependency dependency = new Dependency(clazz.getMethod("getGroup", new Class[0]).invoke(obj, new Object[0]).toString(), clazz.getMethod("getName", new Class[0]).invoke(obj, new Object[0]).toString(), clazz.getMethod("getVersion", new Class[0]).invoke(obj, new Object[0]).toString(), (String)clazz.getMethod("getRelocation", new Class[0]).invoke(obj, new Object[0]), (Boolean)clazz.getMethod("isStickyLoad", new Class[0]).invoke(obj, new Object[0]));
            dependency.setTransitiveResolved((Boolean)clazz.getMethod("isTransitiveResolved", new Class[0]).invoke(obj, new Object[0]));
            dependency.setTransitiveDependencies((List)clazz.getMethod("getTransitiveDependencies", new Class[0]).invoke(obj, new Object[0]));
            return dependency;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveCache(Set<Dependency> dependencies) {
        if (!this.cacheFile.exists()) {
            try {
                this.cacheFile.getParentFile().mkdirs();
                this.cacheFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.cacheFile));){
            oos.writeObject(dependencies);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<Dependency> loadCacheFromFile(Logger logger, File cacheFile) {
        if (!cacheFile.exists()) return new HashSet<Dependency>();
        if (cacheFile.length() == 0L) {
            return new HashSet<Dependency>();
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(cacheFile));){
            Object obj = ois.readObject();
            if (obj instanceof Set) {
                Set<Dependency> set = this.handleDeserializedSet((Set)obj);
                return set;
            }
            HashSet<Dependency> hashSet = new HashSet<Dependency>();
            return hashSet;
        }
        catch (Exception e) {
            cacheFile.delete();
            e.printStackTrace();
            return new HashSet<Dependency>();
        }
    }
}

