/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.api.utils;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.sayandev.sayanvanish.api.utils.VersionInfo;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/sayandev/sayanvanish/api/utils/HangarUtils;", "", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "getLatestRelease", "Ljava/util/concurrent/CompletableFuture;", "Lorg/sayandev/sayanvanish/api/utils/VersionInfo;", "getLatestSnapshot", "get", "urlString", "", "HANGAR_API_URL", "USER_AGENT", "sayanvanish-api"})
@SourceDebugExtension(value={"SMAP\nHangarUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HangarUtils.kt\norg/sayandev/sayanvanish/api/utils/HangarUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class HangarUtils {
    @NotNull
    public static final HangarUtils INSTANCE = new HangarUtils();
    @NotNull
    private static final Gson gson = new Gson();
    @NotNull
    private static final String HANGAR_API_URL = "https://hangar.papermc.io/api/v1/projects/sayanvanish/versions";
    @NotNull
    private static final String USER_AGENT = "Mozilla/5.0";

    private HangarUtils() {
    }

    @NotNull
    public final CompletableFuture<VersionInfo> getLatestRelease() {
        return this.get("https://hangar.papermc.io/api/v1/projects/sayanvanish/latestrelease");
    }

    @NotNull
    public final CompletableFuture<VersionInfo> getLatestSnapshot() {
        return this.get("https://hangar.papermc.io/api/v1/projects/sayanvanish/latest?channel=Snapshot");
    }

    private final CompletableFuture<VersionInfo> get(String urlString) {
        CompletableFuture<VersionInfo> future = new CompletableFuture<VersionInfo>();
        CompletableFuture.runAsync(() -> HangarUtils.get$lambda$2(urlString, future));
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void get$lambda$2(String $urlString, CompletableFuture $future) {
        VersionInfo versionInfo;
        Object it;
        URL url = new URL($urlString);
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setRequestProperty("Accept", "text/plain");
        Closeable closeable = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        Throwable throwable = null;
        try {
            it = (BufferedReader)closeable;
            boolean bl = false;
            it = ((BufferedReader)it).readLine();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Object version = it;
        URL versionUrl = new URL("https://hangar.papermc.io/api/v1/projects/sayanvanish/versions/" + (String)version);
        URLConnection uRLConnection2 = versionUrl.openConnection();
        Intrinsics.checkNotNull(uRLConnection2, "null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection versionConnection = (HttpURLConnection)uRLConnection2;
        versionConnection.setRequestMethod("GET");
        versionConnection.setRequestProperty("User-Agent", USER_AGENT);
        versionConnection.setRequestProperty("Accept", "application/json");
        Closeable closeable2 = new BufferedReader(new InputStreamReader(versionConnection.getInputStream()));
        Throwable throwable3 = null;
        try {
            BufferedReader reader = (BufferedReader)closeable2;
            boolean bl = false;
            Object object = gson.fromJson((Reader)reader, VersionInfo.class);
            Intrinsics.checkNotNull(object);
            versionInfo = (VersionInfo)object;
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable2, throwable3);
        }
        VersionInfo versionInfo2 = versionInfo;
        $future.complete(versionInfo2);
    }
}

