/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.bungeecord.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Event;
import org.sayandev.sayanvanish.api.Permission;
import org.sayandev.sayanvanish.api.SayanVanishAPI;
import org.sayandev.sayanvanish.api.User;
import org.sayandev.sayanvanish.api.VanishOptions;
import org.sayandev.sayanvanish.bungeecord.api.SayanVanishBungeeAPIKt;
import org.sayandev.sayanvanish.bungeecord.event.BungeeUserUnVanishEvent;
import org.sayandev.sayanvanish.bungeecord.event.BungeeUserVanishEvent;
import org.sayandev.sayanvanish.bungeecord.utils.PlayerUtils;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.Nullable;
import org.sayandev.sayanvanish.lib.sayanventure.adventure.text.Component;
import org.sayandev.sayanvanish.lib.sayanventure.adventure.text.minimessage.tag.resolver.Placeholder;
import org.sayandev.sayanvanish.lib.sayanventure.adventure.text.minimessage.tag.resolver.TagResolver;
import org.sayandev.sayanvanish.lib.stickynote.bungeecord.StickyNote;
import org.sayandev.sayanvanish.lib.stickynote.bungeecord.StickyNotePluginKt;
import org.sayandev.sayanvanish.lib.stickynote.bungeecord.utils.AdventureUtils;
import org.sayandev.sayanvanish.proxy.config.SettingsConfigKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 62\u00020\u0001:\u00016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010$\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\b\u0010%\u001a\u0004\u0018\u00010&J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0012H\u0016J\u0010\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0012H\u0016J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0005H\u0016JA\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u00052*\u0010/\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050100\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000501H\u0016\u00a2\u0006\u0002\u00102JA\u00103\u001a\u00020(2\u0006\u0010.\u001a\u00020\u00052*\u0010/\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050100\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000501H\u0016\u00a2\u0006\u0002\u00102J'\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u00052\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020400\"\u000204\u00a2\u0006\u0002\u00105J'\u00103\u001a\u00020(2\u0006\u0010.\u001a\u00020\u00052\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020400\"\u000204\u00a2\u0006\u0002\u00105R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001bR\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u00067"}, d2={"Lorg/sayandev/sayanvanish/bungeecord/api/BungeeUser;", "Lorg/sayandev/sayanvanish/api/User;", "uniqueId", "Ljava/util/UUID;", "username", "", "<init>", "(Ljava/util/UUID;Ljava/lang/String;)V", "getUniqueId", "()Ljava/util/UUID;", "getUsername", "()Ljava/lang/String;", "setUsername", "(Ljava/lang/String;)V", "serverId", "getServerId", "setServerId", "currentOptions", "Lorg/sayandev/sayanvanish/api/VanishOptions;", "getCurrentOptions", "()Lorg/sayandev/sayanvanish/api/VanishOptions;", "setCurrentOptions", "(Lorg/sayandev/sayanvanish/api/VanishOptions;)V", "isVanished", "", "()Z", "setVanished", "(Z)V", "isOnline", "setOnline", "vanishLevel", "", "getVanishLevel", "()I", "setVanishLevel", "(I)V", "stateText", "player", "Lnet/md_5/bungee/api/connection/ProxiedPlayer;", "vanish", "", "options", "unVanish", "hasPermission", "permission", "sendComponent", "content", "placeholder", "", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)V", "sendActionbar", "Lorg/sayandev/sayanvanish/lib/sayanventure/adventure/text/minimessage/tag/resolver/TagResolver;", "(Ljava/lang/String;[Lorg/sayandev/sayanvanish/lib/sayanventure/adventure/text/minimessage/tag/resolver/TagResolver;)V", "Companion", "sayanvanish-proxy-bungeecord"})
@SourceDebugExtension(value={"SMAP\nBungeeUser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BungeeUser.kt\norg/sayandev/sayanvanish/bungeecord/api/BungeeUser\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,89:1\n11228#2:90\n11563#2,3:91\n11228#2:98\n11563#2,3:99\n37#3:94\n36#3,3:95\n37#3:102\n36#3,3:103\n*S KotlinDebug\n*F\n+ 1 BungeeUser.kt\norg/sayandev/sayanvanish/bungeecord/api/BungeeUser\n*L\n63#1:90\n63#1:91,3\n67#1:98\n67#1:99,3\n63#1:94\n63#1:95,3\n67#1:102\n67#1:103,3\n*E\n"})
public class BungeeUser
implements User {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID uniqueId;
    @NotNull
    private String username;
    @NotNull
    private String serverId;
    @NotNull
    private VanishOptions currentOptions;
    private boolean isVanished;
    private boolean isOnline;
    private int vanishLevel;

    public BungeeUser(@NotNull UUID uniqueId, @NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this.uniqueId = uniqueId;
        this.username = username;
        this.serverId = SettingsConfigKt.getSettings().getGeneral().getServerId();
        this.currentOptions = VanishOptions.Companion.defaultOptions();
        this.isOnline = SayanVanishAPI.Companion.getInstance().getDatabase().hasBasicUser(this.getUniqueId(), true);
        this.vanishLevel = 1;
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @NotNull
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.username = string;
    }

    @Override
    @NotNull
    public String getServerId() {
        return this.serverId;
    }

    @Override
    public void setServerId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.serverId = string;
    }

    @Override
    @NotNull
    public VanishOptions getCurrentOptions() {
        return this.currentOptions;
    }

    @Override
    public void setCurrentOptions(@NotNull VanishOptions vanishOptions) {
        Intrinsics.checkNotNullParameter((Object)vanishOptions, (String)"<set-?>");
        this.currentOptions = vanishOptions;
    }

    @Override
    public boolean isVanished() {
        return this.isVanished;
    }

    @Override
    public void setVanished(boolean bl) {
        this.isVanished = bl;
    }

    @Override
    public boolean isOnline() {
        return this.isOnline;
    }

    @Override
    public void setOnline(boolean bl) {
        this.isOnline = bl;
    }

    @Override
    public int getVanishLevel() {
        return this.vanishLevel;
    }

    @Override
    public void setVanishLevel(int n) {
        this.vanishLevel = n;
    }

    @NotNull
    public final String stateText(boolean isVanished) {
        return isVanished ? "<green>ON</green>" : "<red>OFF</red>";
    }

    public static /* synthetic */ String stateText$default(BungeeUser bungeeUser, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stateText");
        }
        if ((n & 1) != 0) {
            bl = bungeeUser.isVanished();
        }
        return bungeeUser.stateText(bl);
    }

    @Nullable
    public final ProxiedPlayer player() {
        return StickyNote.getPlayer((UUID)this.getUniqueId());
    }

    @Override
    public void vanish(@NotNull VanishOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        BungeeUserVanishEvent vanishEvent = (BungeeUserVanishEvent)StickyNotePluginKt.getPlugin().getProxy().getPluginManager().callEvent((Event)new BungeeUserVanishEvent(this, options));
        if (vanishEvent.isCancelled()) {
            return;
        }
        VanishOptions options2 = vanishEvent.getOptions();
        this.setCurrentOptions(options2);
        SayanVanishBungeeAPIKt.getDatabase().addToQueue(this.getUniqueId(), true);
        User.super.vanish(options2);
    }

    @Override
    public void unVanish(@NotNull VanishOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        BungeeUserUnVanishEvent vanishEvent = (BungeeUserUnVanishEvent)StickyNotePluginKt.getPlugin().getProxy().getPluginManager().callEvent((Event)new BungeeUserUnVanishEvent(this, options));
        if (vanishEvent.isCancelled()) {
            return;
        }
        VanishOptions options2 = vanishEvent.getOptions();
        this.setCurrentOptions(options2);
        SayanVanishBungeeAPIKt.getDatabase().addToQueue(this.getUniqueId(), false);
        User.super.unVanish(options2);
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        ProxiedPlayer proxiedPlayer = this.player();
        return proxiedPlayer != null ? proxiedPlayer.hasPermission(permission) : false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendComponent(@NotNull String content, Pair<String, String> ... placeholder) {
        void $this$toTypedArray$iv;
        Collection<TagResolver.Single> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(placeholder, (String)"placeholder");
        Pair<String, String>[] pairArray = placeholder;
        String string = content;
        BungeeUser bungeeUser = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_13 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Placeholder.parsed((String)((String)it.getFirst()), (String)((String)it.getSecond())));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        TagResolver.Single[] singleArray = thisCollection$iv.toArray(new TagResolver.Single[0]);
        bungeeUser.sendComponent(string, (TagResolver[])Arrays.copyOf(singleArray, singleArray.length));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendActionbar(@NotNull String content, Pair<String, String> ... placeholder) {
        void $this$toTypedArray$iv;
        Collection<TagResolver.Single> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(placeholder, (String)"placeholder");
        Pair<String, String>[] pairArray = placeholder;
        String string = content;
        BungeeUser bungeeUser = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_13 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Placeholder.parsed((String)((String)it.getFirst()), (String)((String)it.getSecond())));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        TagResolver.Single[] singleArray = thisCollection$iv.toArray(new TagResolver.Single[0]);
        bungeeUser.sendActionbar(string, (TagResolver[])Arrays.copyOf(singleArray, singleArray.length));
    }

    public final void sendComponent(@NotNull String content, TagResolver ... placeholder) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
            ProxiedPlayer proxiedPlayer = this.player();
            if (proxiedPlayer == null) break block0;
            PlayerUtils.INSTANCE.sendComponent((CommandSender)proxiedPlayer, AdventureUtils.INSTANCE.component(content, new TagResolver[0]));
        }
    }

    public final void sendActionbar(@NotNull String content, TagResolver ... placeholder) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
            ProxiedPlayer proxiedPlayer = this.player();
            if (proxiedPlayer == null) break block0;
            AdventureUtils.sendActionbar((ProxiedPlayer)proxiedPlayer, (Component)AdventureUtils.INSTANCE.component(content, new TagResolver[0]));
        }
    }

    @Override
    public void vanish() {
        User.super.vanish();
    }

    @Override
    public void unVanish() {
        User.super.unVanish();
    }

    @Override
    public void toggleVanish(@NotNull VanishOptions options) {
        User.super.toggleVanish(options);
    }

    @Override
    public void toggleVanish() {
        User.super.toggleVanish();
    }

    @Override
    public void sendComponent(@NotNull String content) {
        User.super.sendComponent(content);
    }

    @Override
    public void sendActionbar(@NotNull String content) {
        User.super.sendActionbar(content);
    }

    @Override
    public boolean canSee(@NotNull User otherUser) {
        return User.super.canSee(otherUser);
    }

    @Override
    public void save() {
        User.super.save();
    }

    @Override
    public void delete() {
        User.super.delete();
    }

    @Override
    @NotNull
    public String toJson() {
        return User.super.toJson();
    }

    @Override
    public boolean hasPermission(@NotNull Permission permission) {
        return User.super.hasPermission(permission);
    }

    @JvmStatic
    @NotNull
    public static final BungeeUser fromUser(@NotNull User user2) {
        return Companion.fromUser(user2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/sayandev/sayanvanish/bungeecord/api/BungeeUser$Companion;", "", "<init>", "()V", "fromUser", "Lorg/sayandev/sayanvanish/bungeecord/api/BungeeUser;", "user", "Lorg/sayandev/sayanvanish/api/User;", "sayanvanish-proxy-bungeecord"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BungeeUser fromUser(@NotNull User user2) {
            BungeeUser bungeeUser;
            Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
            BungeeUser $this$fromUser_u24lambda_u240 = bungeeUser = new BungeeUser(user2.getUniqueId(), user2.getUsername());
            boolean bl = false;
            $this$fromUser_u24lambda_u240.setOnline(user2.isOnline());
            $this$fromUser_u24lambda_u240.setVanished(user2.isVanished());
            $this$fromUser_u24lambda_u240.setVanishLevel(user2.getVanishLevel());
            return bungeeUser;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

