/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.sayandev.sayanvanish.api.BasicUser;
import org.sayandev.sayanvanish.api.Permission;
import org.sayandev.sayanvanish.api.Platform;
import org.sayandev.sayanvanish.api.SayanVanishAPI;
import org.sayandev.sayanvanish.api.VanishOptions;
import org.sayandev.sayanvanish.api.exception.UnsupportedPlatformException;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u0000 '2\u00020\u0001:\u0001'J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0016JA\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2*\u0010\u001e\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0 0\u001f\"\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0 H\u0016\u00a2\u0006\u0002\u0010!JA\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2*\u0010\u001e\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0 0\u001f\"\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0 H\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0000H\u0016J\b\u0010$\u001a\u00020\u0016H\u0016J\b\u0010%\u001a\u00020\u0016H\u0016J\b\u0010&\u001a\u00020\u001cH\u0016R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u0018\u0010\u000f\u001a\u00020\u0010X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006(\u00c0\u0006\u0003"}, d2={"Lorg/sayandev/sayanvanish/api/User;", "Lorg/sayandev/sayanvanish/api/BasicUser;", "currentOptions", "Lorg/sayandev/sayanvanish/api/VanishOptions;", "getCurrentOptions", "()Lorg/sayandev/sayanvanish/api/VanishOptions;", "setCurrentOptions", "(Lorg/sayandev/sayanvanish/api/VanishOptions;)V", "isVanished", "", "()Z", "setVanished", "(Z)V", "isOnline", "setOnline", "vanishLevel", "", "getVanishLevel", "()I", "setVanishLevel", "(I)V", "vanish", "", "options", "unVanish", "toggleVanish", "sendComponent", "content", "", "sendActionbar", "placeholder", "", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)V", "canSee", "otherUser", "save", "delete", "toJson", "Companion", "sayanvanish-api"})
public interface User
extends BasicUser {
    @NotNull
    public static final Companion Companion = org.sayandev.sayanvanish.api.User$Companion.$$INSTANCE;

    @NotNull
    public VanishOptions getCurrentOptions();

    public void setCurrentOptions(@NotNull VanishOptions var1);

    public boolean isVanished();

    public void setVanished(boolean var1);

    public boolean isOnline();

    public void setOnline(boolean var1);

    public int getVanishLevel();

    public void setVanishLevel(int var1);

    default public void vanish(@NotNull VanishOptions options) {
        Intrinsics.checkNotNullParameter(options, "options");
        this.setVanished(true);
        this.save();
    }

    default public void vanish() {
        this.vanish(VanishOptions.Companion.defaultOptions());
    }

    default public void unVanish(@NotNull VanishOptions options) {
        Intrinsics.checkNotNullParameter(options, "options");
        this.setVanished(false);
        this.save();
    }

    default public void unVanish() {
        this.unVanish(VanishOptions.Companion.defaultOptions());
    }

    default public void toggleVanish(@NotNull VanishOptions options) {
        Intrinsics.checkNotNullParameter(options, "options");
        if (this.isVanished()) {
            this.unVanish(options);
        } else {
            this.vanish(options);
        }
    }

    default public void toggleVanish() {
        this.toggleVanish(VanishOptions.Companion.defaultOptions());
    }

    default public void sendComponent(@NotNull String content) {
        Intrinsics.checkNotNullParameter(content, "content");
        Pair[] pairArray = new Pair[]{};
        this.sendComponent(content, Arrays.copyOf(pairArray, pairArray.length));
    }

    default public void sendActionbar(@NotNull String content) {
        Intrinsics.checkNotNullParameter(content, "content");
        Pair[] pairArray = new Pair[]{};
        this.sendActionbar(content, Arrays.copyOf(pairArray, pairArray.length));
    }

    default public void sendComponent(@NotNull String content, Pair<String, String> ... placeholder) {
        Intrinsics.checkNotNullParameter(content, "content");
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        throw new UnsupportedPlatformException("sendMessage");
    }

    default public void sendActionbar(@NotNull String content, Pair<String, String> ... placeholder) {
        Intrinsics.checkNotNullParameter(content, "content");
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        throw new UnsupportedPlatformException("sendActionbar");
    }

    default public boolean canSee(@NotNull User otherUser) {
        Intrinsics.checkNotNullParameter(otherUser, "otherUser");
        if (!otherUser.isVanished()) {
            return true;
        }
        if (Intrinsics.areEqual(this.getUniqueId(), otherUser.getUniqueId())) {
            return true;
        }
        boolean canSee = this.getVanishLevel() >= otherUser.getVanishLevel();
        return canSee;
    }

    @Override
    default public void save() {
        this.setServerId(Platform.Companion.get().getServerId());
        SayanVanishAPI.Companion.getInstance().getDatabase().addUser(this);
    }

    default public void delete() {
        SayanVanishAPI.Companion.getInstance().getDatabase().removeUser(this.getUniqueId());
    }

    @Override
    @NotNull
    default public String toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("unique-id", this.getUniqueId().toString());
        json.addProperty("username", this.getUsername());
        json.addProperty("is-vanished", Boolean.valueOf(this.isVanished()));
        json.addProperty("is-online", Boolean.valueOf(this.isOnline()));
        json.addProperty("vanish-level", (Number)this.getVanishLevel());
        json.addProperty("current-options", this.getCurrentOptions().toJson());
        String string = new Gson().toJson((JsonElement)json);
        Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static User fromJson(@NotNull String serialized) {
        return Companion.fromJson(serialized);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u00020\u0001*\u00020\u00052\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\n\u00a8\u0006\u000b"}, d2={"Lorg/sayandev/sayanvanish/api/User$Companion;", "", "<init>", "()V", "fromJson", "Lorg/sayandev/sayanvanish/api/User;", "serialized", "", "convert", "to", "Ljava/lang/Class;", "sayanvanish-api"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final User fromJson(@NotNull String serialized) {
            Intrinsics.checkNotNullParameter(serialized, "serialized");
            JsonObject json = JsonParser.parseString((String)serialized).getAsJsonObject();
            String uniqueId = json.get("unique-id").getAsString();
            String username = json.get("username").getAsString();
            boolean isVanished = json.get("is-vanished").getAsBoolean();
            boolean isOnline = json.get("is-online").getAsBoolean();
            int vanishLevel = json.get("vanish-level").getAsInt();
            String string = json.get("current-options").getAsString();
            Intrinsics.checkNotNullExpressionValue(string, "getAsString(...)");
            VanishOptions currentOptions = VanishOptions.Companion.fromJson(string);
            return new User(uniqueId, username, isVanished, isOnline, vanishLevel, currentOptions){
                private final UUID uniqueId;
                private String username;
                private boolean isVanished;
                private boolean isOnline;
                private int vanishLevel;
                private VanishOptions currentOptions;
                private String serverId;
                {
                    this.uniqueId = UUID.fromString($uniqueId);
                    this.username = $username;
                    this.isVanished = $isVanished;
                    this.isOnline = $isOnline;
                    this.vanishLevel = $vanishLevel;
                    this.currentOptions = $currentOptions;
                    this.serverId = Platform.Companion.get().getId();
                }

                public UUID getUniqueId() {
                    return this.uniqueId;
                }

                public String getUsername() {
                    return this.username;
                }

                public void setUsername(String string) {
                    this.username = string;
                }

                public boolean isVanished() {
                    return this.isVanished;
                }

                public void setVanished(boolean bl) {
                    this.isVanished = bl;
                }

                public boolean isOnline() {
                    return this.isOnline;
                }

                public void setOnline(boolean bl) {
                    this.isOnline = bl;
                }

                public int getVanishLevel() {
                    return this.vanishLevel;
                }

                public void setVanishLevel(int n) {
                    this.vanishLevel = n;
                }

                public VanishOptions getCurrentOptions() {
                    return this.currentOptions;
                }

                public void setCurrentOptions(VanishOptions vanishOptions) {
                    Intrinsics.checkNotNullParameter(vanishOptions, "<set-?>");
                    this.currentOptions = vanishOptions;
                }

                public String getServerId() {
                    return this.serverId;
                }

                public void setServerId(String string) {
                    Intrinsics.checkNotNullParameter(string, "<set-?>");
                    this.serverId = string;
                }

                public void vanish(VanishOptions options) {
                    User.super.vanish(options);
                }

                public void vanish() {
                    User.super.vanish();
                }

                public void unVanish(VanishOptions options) {
                    User.super.unVanish(options);
                }

                public void unVanish() {
                    User.super.unVanish();
                }

                public void toggleVanish(VanishOptions options) {
                    User.super.toggleVanish(options);
                }

                public void toggleVanish() {
                    User.super.toggleVanish();
                }

                public void sendComponent(String content) {
                    User.super.sendComponent(content);
                }

                public void sendComponent(String content, Pair<String, String> ... placeholder) {
                    User.super.sendComponent(content, placeholder);
                }

                public void sendActionbar(String content) {
                    User.super.sendActionbar(content);
                }

                public void sendActionbar(String content, Pair<String, String> ... placeholder) {
                    User.super.sendActionbar(content, placeholder);
                }

                public boolean canSee(User otherUser) {
                    return User.super.canSee(otherUser);
                }

                public void save() {
                    User.super.save();
                }

                public void delete() {
                    User.super.delete();
                }

                public String toJson() {
                    return User.super.toJson();
                }

                public boolean hasPermission(String permission) {
                    return User.super.hasPermission(permission);
                }

                public boolean hasPermission(Permission permission) {
                    return User.super.hasPermission(permission);
                }
            };
        }

        @NotNull
        public final Object convert(@NotNull User $this$convert, @NotNull Class<? extends User> to) {
            Intrinsics.checkNotNullParameter($this$convert, "<this>");
            Intrinsics.checkNotNullParameter(to, "to");
            Object[] objectArray = new Class[]{User.class};
            Method method = to.getDeclaredMethod("fromUser", (Class<?>[])objectArray);
            objectArray = new Object[]{$this$convert};
            Object instance = method.invoke(null, objectArray);
            Intrinsics.checkNotNull(instance);
            return instance;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static void vanish(@NotNull User $this, @NotNull VanishOptions options) {
            Intrinsics.checkNotNullParameter(options, "options");
            $this.vanish(options);
        }

        @Deprecated
        public static void vanish(@NotNull User $this) {
            $this.vanish();
        }

        @Deprecated
        public static void unVanish(@NotNull User $this, @NotNull VanishOptions options) {
            Intrinsics.checkNotNullParameter(options, "options");
            $this.unVanish(options);
        }

        @Deprecated
        public static void unVanish(@NotNull User $this) {
            $this.unVanish();
        }

        @Deprecated
        public static void toggleVanish(@NotNull User $this, @NotNull VanishOptions options) {
            Intrinsics.checkNotNullParameter(options, "options");
            $this.toggleVanish(options);
        }

        @Deprecated
        public static void toggleVanish(@NotNull User $this) {
            $this.toggleVanish();
        }

        @Deprecated
        public static void sendComponent(@NotNull User $this, @NotNull String content) {
            Intrinsics.checkNotNullParameter(content, "content");
            $this.sendComponent(content);
        }

        @Deprecated
        public static void sendActionbar(@NotNull User $this, @NotNull String content) {
            Intrinsics.checkNotNullParameter(content, "content");
            $this.sendActionbar(content);
        }

        @Deprecated
        public static void sendComponent(@NotNull User $this, @NotNull String content, Pair<String, String> ... placeholder) {
            Intrinsics.checkNotNullParameter(content, "content");
            Intrinsics.checkNotNullParameter(placeholder, "placeholder");
            $this.sendComponent(content, placeholder);
        }

        @Deprecated
        public static void sendActionbar(@NotNull User $this, @NotNull String content, Pair<String, String> ... placeholder) {
            Intrinsics.checkNotNullParameter(content, "content");
            Intrinsics.checkNotNullParameter(placeholder, "placeholder");
            $this.sendActionbar(content, placeholder);
        }

        @Deprecated
        public static boolean canSee(@NotNull User $this, @NotNull User otherUser) {
            Intrinsics.checkNotNullParameter(otherUser, "otherUser");
            return $this.canSee(otherUser);
        }

        @Deprecated
        public static void save(@NotNull User $this) {
            $this.save();
        }

        @Deprecated
        public static void delete(@NotNull User $this) {
            $this.delete();
        }

        @Deprecated
        @NotNull
        public static String toJson(@NotNull User $this) {
            return $this.toJson();
        }

        @Deprecated
        public static boolean hasPermission(@NotNull User $this, @NotNull String permission) {
            Intrinsics.checkNotNullParameter(permission, "permission");
            return $this.hasPermission(permission);
        }

        @Deprecated
        public static boolean hasPermission(@NotNull User $this, @NotNull Permission permission) {
            Intrinsics.checkNotNullParameter((Object)permission, "permission");
            return $this.hasPermission(permission);
        }
    }
}

