/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.api.database.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClasses;
import org.sayandev.sayanvanish.api.BasicUser;
import org.sayandev.sayanvanish.api.User;
import org.sayandev.sayanvanish.api.database.Database;
import org.sayandev.sayanvanish.api.database.redis.RedisConfig;
import org.sayandev.sayanvanish.lib.clients.jedis.DefaultJedisClientConfig;
import org.sayandev.sayanvanish.lib.clients.jedis.HostAndPort;
import org.sayandev.sayanvanish.lib.clients.jedis.JedisClientConfig;
import org.sayandev.sayanvanish.lib.clients.jedis.JedisPooled;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020)H\u0016J\u001f\u0010,\u001a\u0004\u0018\u00018\u00002\u0006\u0010-\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010.J\"\u0010/\u001a\u00020)2\u0018\u00100\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u000002\u0012\u0004\u0012\u00020)01H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00028\u000002H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u001c022\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u00105\u001a\u00020)2\u0018\u00100\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c02\u0012\u0004\u0012\u00020)01H\u0016J\u0015\u00106\u001a\u00020)2\u0006\u00107\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020)2\u0006\u00107\u001a\u00020\u001cH\u0016J\u0010\u0010:\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u0016H\u0016J\u0018\u0010;\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010<\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0016H\u0016J\u0010\u0010=\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0016H\u0016J\u0015\u0010>\u001a\u00020)2\u0006\u00107\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00108J\u0010\u0010?\u001a\u00020)2\u0006\u00107\u001a\u00020\u001cH\u0016J$\u0010@\u001a\u00020)2\u0006\u0010-\u001a\u00020\u00162\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020)01H\u0016J\u0018\u0010A\u001a\u00020)2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010B\u001a\u00020\tH\u0016J\u0010\u0010C\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0016H\u0016J$\u0010D\u001a\u00020)2\u0006\u0010-\u001a\u00020\u00162\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020)01H\u0016J\b\u0010E\u001a\u00020)H\u0016J\b\u0010F\u001a\u00020)H\u0016J\b\u0010G\u001a\u00020)H\u0016J\u0010\u0010G\u001a\u00020)2\u0006\u0010H\u001a\u00020IH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00028\u00000\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR&\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001aR\u0016\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020#X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006J"}, d2={"Lorg/sayandev/sayanvanish/api/database/redis/RedisDatabase;", "U", "Lorg/sayandev/sayanvanish/api/User;", "Lorg/sayandev/sayanvanish/api/database/Database;", "config", "Lorg/sayandev/sayanvanish/api/database/redis/RedisConfig;", "type", "Ljava/lang/Class;", "useCache", "", "<init>", "(Lorg/sayandev/sayanvanish/api/database/redis/RedisConfig;Ljava/lang/Class;Z)V", "getConfig", "()Lorg/sayandev/sayanvanish/api/database/redis/RedisConfig;", "getType", "()Ljava/lang/Class;", "getUseCache", "()Z", "setUseCache", "(Z)V", "cache", "", "Ljava/util/UUID;", "getCache", "()Ljava/util/Map;", "setCache", "(Ljava/util/Map;)V", "basicCache", "Lorg/sayandev/sayanvanish/api/BasicUser;", "getBasicCache", "setBasicCache", "thread", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "redis", "Lorg/sayandev/sayanvanish/lib/clients/jedis/JedisPooled;", "getRedis", "()Lorg/sayandev/sayanvanish/lib/clients/jedis/JedisPooled;", "setRedis", "(Lorg/sayandev/sayanvanish/lib/clients/jedis/JedisPooled;)V", "initialize", "", "connect", "disconnect", "getUser", "uniqueId", "(Ljava/util/UUID;Z)Lorg/sayandev/sayanvanish/api/User;", "getUsersAsync", "result", "Lkotlin/Function1;", "", "getUsers", "getBasicUsers", "getBasicUsersAsync", "addUser", "user", "(Lorg/sayandev/sayanvanish/api/User;)V", "addBasicUser", "hasUser", "hasBasicUser", "removeUser", "removeBasicUser", "updateUser", "updateBasicUser", "isInQueue", "addToQueue", "vanished", "removeFromQueue", "getFromQueue", "purgeCache", "purge", "purgeBasic", "serverId", "", "sayanvanish-api"})
@SourceDebugExtension(value={"SMAP\nRedisDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisDatabase.kt\norg/sayandev/sayanvanish/api/database/redis/RedisDatabase\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n126#2:192\n153#2,3:193\n126#2:196\n153#2,3:197\n1#3:200\n*S KotlinDebug\n*F\n+ 1 RedisDatabase.kt\norg/sayandev/sayanvanish/api/database/redis/RedisDatabase\n*L\n87#1:192\n87#1:193,3\n99#1:196\n99#1:197,3\n*E\n"})
public final class RedisDatabase<U extends User>
implements Database<U> {
    @NotNull
    private final RedisConfig config;
    @NotNull
    private final Class<? extends User> type;
    private boolean useCache;
    @NotNull
    private Map<UUID, U> cache;
    @NotNull
    private Map<UUID, BasicUser> basicCache;
    private final ExecutorService thread;
    public JedisPooled redis;

    public RedisDatabase(@NotNull RedisConfig config, @NotNull Class<? extends User> type, boolean useCache) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(type, "type");
        this.config = config;
        this.type = type;
        this.useCache = useCache;
        this.cache = new LinkedHashMap();
        this.basicCache = new LinkedHashMap();
        this.thread = Executors.newSingleThreadExecutor();
    }

    public /* synthetic */ RedisDatabase(RedisConfig redisConfig, Class clazz, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(redisConfig, clazz, bl);
    }

    @NotNull
    public final RedisConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Class<? extends User> getType() {
        return this.type;
    }

    @Override
    public boolean getUseCache() {
        return this.useCache;
    }

    @Override
    public void setUseCache(boolean bl) {
        this.useCache = bl;
    }

    @Override
    @NotNull
    public Map<UUID, U> getCache() {
        return this.cache;
    }

    @Override
    public void setCache(@NotNull Map<UUID, U> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.cache = map;
    }

    @NotNull
    public final Map<UUID, BasicUser> getBasicCache() {
        return this.basicCache;
    }

    public final void setBasicCache(@NotNull Map<UUID, BasicUser> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.basicCache = map;
    }

    @NotNull
    public final JedisPooled getRedis() {
        JedisPooled jedisPooled = this.redis;
        if (jedisPooled != null) {
            return jedisPooled;
        }
        Intrinsics.throwUninitializedPropertyAccessException("redis");
        return null;
    }

    public final void setRedis(@NotNull JedisPooled jedisPooled) {
        Intrinsics.checkNotNullParameter(jedisPooled, "<set-?>");
        this.redis = jedisPooled;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize() {
        RedisDatabase redisDatabase;
        DefaultJedisClientConfig.Builder builder;
        HostAndPort address;
        if (WhenMappings.$EnumSwitchMapping$0[this.config.getType().ordinal()] == 1) {
            void $this$initialize_u24lambda_u240;
            address = new HostAndPort(this.config.getStandalone().getHost(), this.config.getStandalone().getPort());
            DefaultJedisClientConfig.Builder builder2 = builder = DefaultJedisClientConfig.builder();
            redisDatabase = this;
            boolean bl = false;
            if (((CharSequence)this.config.getStandalone().getUser()).length() > 0) {
                $this$initialize_u24lambda_u240.user(this.config.getStandalone().getUser());
            }
            if (((CharSequence)this.config.getStandalone().getPassword()).length() > 0) {
                $this$initialize_u24lambda_u240.password(this.config.getStandalone().getPassword());
            }
            if (this.config.getStandalone().getSsl()) {
                $this$initialize_u24lambda_u240.ssl(this.config.getStandalone().getSsl());
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DefaultJedisClientConfig config = builder.build();
        redisDatabase.setRedis(new JedisPooled(address, (JedisClientConfig)config));
    }

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
        this.getRedis().close();
    }

    @Override
    @Nullable
    public U getUser(@NotNull UUID uniqueId, boolean useCache) {
        User user2;
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        User cacheUser = (User)this.getCache().get(uniqueId);
        if (this.getUseCache() && useCache) {
            if (cacheUser == null) {
                return null;
            }
            User user3 = KClasses.safeCast(JvmClassMappingKt.getKotlinClass(this.type), cacheUser);
            User user4 = user3 instanceof User ? user3 : null;
            if (user4 == null) {
                Object object = User.Companion.convert(cacheUser, this.type);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type U of org.sayandev.sayanvanish.api.database.redis.RedisDatabase");
                user4 = (User)object;
            }
            return (U)user4;
        }
        String user5 = this.getRedis().hget("users", uniqueId.toString());
        if (user5 != null) {
            User user6 = User.Companion.fromJson(user5);
            User user7 = KClasses.safeCast(JvmClassMappingKt.getKotlinClass(this.type), user6);
            User user8 = user7 instanceof User ? user7 : null;
            if (user8 == null) {
                Object object = User.Companion.convert(user6, this.type);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type U of org.sayandev.sayanvanish.api.database.redis.RedisDatabase");
                user8 = (User)object;
            }
            User typedUser = user8;
            this.getCache().put(uniqueId, typedUser);
            user2 = typedUser;
        } else {
            user2 = null;
        }
        return (U)user2;
    }

    @Override
    public void getUsersAsync(@NotNull Function1<? super List<? extends U>, Unit> result2) {
        Intrinsics.checkNotNullParameter(result2, "result");
        this.thread.submit(() -> RedisDatabase.getUsersAsync$lambda$1(this, result2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<U> getUsers() {
        void $this$mapTo$iv$iv;
        if (this.getUseCache()) {
            return CollectionsKt.toList((Iterable)this.getCache().values());
        }
        Map users = this.getRedis().hgetAll("users");
        Intrinsics.checkNotNull(users);
        Map $this$map$iv = users;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
            User user2 = User.Companion.fromJson((String)v);
            User user3 = KClasses.safeCast(JvmClassMappingKt.getKotlinClass(this.type), user2);
            User user4 = user3 instanceof User ? user3 : null;
            if (user4 == null) {
                Object object = User.Companion.convert(user2, this.type);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type U of org.sayandev.sayanvanish.api.database.redis.RedisDatabase");
                user4 = (User)object;
            }
            collection.add(user4);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<BasicUser> getBasicUsers(boolean useCache) {
        void $this$mapTo$iv$iv;
        if (useCache) {
            return CollectionsKt.toList((Iterable)this.basicCache.values());
        }
        Map users = this.getRedis().hgetAll("basic_users");
        Intrinsics.checkNotNull(users);
        Map $this$map$iv = users;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
            collection.add(BasicUser.Companion.fromJson((String)v));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void getBasicUsersAsync(@NotNull Function1<? super List<? extends BasicUser>, Unit> result2) {
        Intrinsics.checkNotNullParameter(result2, "result");
        this.thread.submit(() -> RedisDatabase.getBasicUsersAsync$lambda$4(this, result2));
    }

    @Override
    public void addUser(@NotNull U user2) {
        Intrinsics.checkNotNullParameter(user2, "user");
        this.getCache().put(((BasicUser)user2).getUniqueId(), user2);
        this.getRedis().hset("users", ((BasicUser)user2).getUniqueId().toString(), user2.toJson());
    }

    @Override
    public void addBasicUser(@NotNull BasicUser user2) {
        Intrinsics.checkNotNullParameter(user2, "user");
        this.basicCache.put(user2.getUniqueId(), user2);
        this.getRedis().hset("basic_users", user2.getUniqueId().toString(), user2.toJson());
    }

    @Override
    public boolean hasUser(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        return this.getRedis().hexists("users", uniqueId.toString());
    }

    @Override
    public boolean hasBasicUser(@NotNull UUID uniqueId, boolean useCache) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        if (useCache) {
            return this.basicCache.containsKey(uniqueId);
        }
        return this.getRedis().hexists("basic_users", uniqueId.toString());
    }

    @Override
    public void removeUser(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        this.getCache().remove(uniqueId);
        String[] stringArray = new String[]{uniqueId.toString()};
        this.getRedis().hdel("users", stringArray);
    }

    @Override
    public void removeBasicUser(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        this.basicCache.remove(uniqueId);
        String[] stringArray = new String[]{uniqueId.toString()};
        this.getRedis().hdel("basic_users", stringArray);
    }

    @Override
    public void updateUser(@NotNull U user2) {
        Intrinsics.checkNotNullParameter(user2, "user");
        this.getCache().put(((BasicUser)user2).getUniqueId(), user2);
        this.addUser(user2);
    }

    @Override
    public void updateBasicUser(@NotNull BasicUser user2) {
        Intrinsics.checkNotNullParameter(user2, "user");
        this.basicCache.put(user2.getUniqueId(), user2);
        this.addBasicUser(user2);
    }

    @Override
    public void isInQueue(@NotNull UUID uniqueId, @NotNull Function1<? super Boolean, Unit> result2) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Intrinsics.checkNotNullParameter(result2, "result");
        this.thread.submit(() -> RedisDatabase.isInQueue$lambda$6(this, uniqueId, result2));
    }

    @Override
    public void addToQueue(@NotNull UUID uniqueId, boolean vanished) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        this.getRedis().set("queue:" + uniqueId, String.valueOf(vanished));
    }

    @Override
    public void removeFromQueue(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        this.getRedis().del("queue:" + uniqueId);
    }

    @Override
    public void getFromQueue(@NotNull UUID uniqueId, @NotNull Function1<? super Boolean, Unit> result2) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Intrinsics.checkNotNullParameter(result2, "result");
        this.thread.submit(() -> RedisDatabase.getFromQueue$lambda$8(this, uniqueId, result2));
    }

    @Override
    public void purgeCache() {
        this.getCache().clear();
        this.basicCache.clear();
    }

    @Override
    public void purge() {
        this.getRedis().del("users");
        this.getRedis().del("basic_users");
        this.getRedis().del("queue");
    }

    @Override
    public void purgeBasic() {
        this.getRedis().del("basic_users");
        this.getRedis().del("queue");
    }

    @Override
    public void purgeBasic(@NotNull String serverId) {
        Intrinsics.checkNotNullParameter(serverId, "serverId");
        String[] stringArray = new String[]{serverId};
        this.getRedis().hdel("basic_users", stringArray);
    }

    @Override
    @Nullable
    public U getUser(@NotNull UUID uniqueId) {
        return Database.super.getUser(uniqueId);
    }

    private static final void getUsersAsync$lambda$1(RedisDatabase this$0, Function1 $result) {
        List users = this$0.getUsers();
        $result.invoke(users);
    }

    private static final void getBasicUsersAsync$lambda$4(RedisDatabase this$0, Function1 $result) {
        List<BasicUser> users = this$0.getBasicUsers(true);
        $result.invoke(users);
    }

    private static final void isInQueue$lambda$6(RedisDatabase this$0, UUID $uniqueId, Function1 $result) {
        String string = this$0.getRedis().get("queue:" + $uniqueId);
        if (string != null) {
            String it = string;
            boolean bl = false;
            $result.invoke(true);
        } else {
            $result.invoke(false);
        }
    }

    private static final void getFromQueue$lambda$8(RedisDatabase this$0, UUID $uniqueId, Function1 $result) {
        String string = this$0.getRedis().get("queue:" + $uniqueId);
        if (string != null) {
            String it = string;
            boolean bl = false;
            $result.invoke(Boolean.parseBoolean(it));
        } else {
            $result.invoke(false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RedisConfig.RedisType.values().length];
            try {
                nArray[RedisConfig.RedisType.STANDALONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

