/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.sayandev.sayanvanish.api.BasicUser;
import org.sayandev.sayanvanish.api.Platform;
import org.sayandev.sayanvanish.api.User;
import org.sayandev.sayanvanish.api.database.Database;
import org.sayandev.sayanvanish.api.database.DatabaseConfigKt;
import org.sayandev.sayanvanish.api.database.DatabaseMethod;
import org.sayandev.sayanvanish.api.database.redis.RedisDatabase;
import org.sayandev.sayanvanish.api.database.sql.SQLDatabase;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001'B\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019J\u001d\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\f\u00a2\u0006\u0002\u0010 J\u0015\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010!J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#J\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000#J\b\u0010%\u001a\u00020&H\u0002R\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lorg/sayandev/sayanvanish/api/SayanVanishAPI;", "U", "Lorg/sayandev/sayanvanish/api/User;", "", "type", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "()V", "getType", "()Ljava/lang/Class;", "databaseConnected", "", "getDatabaseConnected", "()Z", "setDatabaseConnected", "(Z)V", "database", "Lorg/sayandev/sayanvanish/api/database/Database;", "getDatabase", "()Lorg/sayandev/sayanvanish/api/database/Database;", "getPlatform", "Lorg/sayandev/sayanvanish/api/Platform;", "isVanished", "uniqueId", "Ljava/util/UUID;", "useCache", "canSee", "user", "target", "(Lorg/sayandev/sayanvanish/api/User;Lorg/sayandev/sayanvanish/api/User;)Z", "getUser", "(Ljava/util/UUID;Z)Lorg/sayandev/sayanvanish/api/User;", "(Ljava/util/UUID;)Lorg/sayandev/sayanvanish/api/User;", "getOnlineUsers", "", "getVanishedUsers", "logDatabaseError", "", "Companion", "sayanvanish-api"})
@SourceDebugExtension(value={"SMAP\nSayanVanishAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SayanVanishAPI.kt\norg/sayandev/sayanvanish/api/SayanVanishAPI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n774#2:110\n865#2,2:111\n774#2:113\n865#2,2:114\n774#2:116\n865#2,2:117\n*S KotlinDebug\n*F\n+ 1 SayanVanishAPI.kt\norg/sayandev/sayanvanish/api/SayanVanishAPI\n*L\n42#1:110\n42#1:111,2\n76#1:113\n76#1:114,2\n80#1:116\n80#1:117,2\n*E\n"})
public class SayanVanishAPI<U extends User> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<? extends User> type;
    private boolean databaseConnected;
    @NotNull
    private final Database<U> database;
    @NotNull
    private static final SayanVanishAPI<User> defaultInstance = new SayanVanishAPI();

    /*
     * WARNING - void declaration
     */
    public SayanVanishAPI(@NotNull Class<? extends User> type) {
        void $this$filterTo$iv$iv;
        Object e;
        Intrinsics.checkNotNullParameter(type, "type");
        this.type = type;
        this.databaseConnected = true;
        SayanVanishAPI sayanVanishAPI = this;
        v1.database = switch (WhenMappings.$EnumSwitchMapping$0[DatabaseConfigKt.getDatabaseConfig().getMethod().ordinal()]) {
            case 1 -> {
                SayanVanishAPI v1;
                SayanVanishAPI var13_8;
                Database var4_3;
                SayanVanishAPI var12_2 = sayanVanishAPI;
                try {
                    void $this$database_u24lambda_u240;
                    Database var5_5 = var4_3 = new SQLDatabase(DatabaseConfigKt.getDatabaseConfig().getSql(), this.type, DatabaseConfigKt.getDatabaseConfig().getUseCacheWhenAvailable());
                    var13_8 = var12_2;
                    boolean $i$a$-apply-SayanVanishAPI$database$1 = false;
                    $this$database_u24lambda_u240.connect();
                    $this$database_u24lambda_u240.initialize();
                    v1 = var13_8;
                }
                catch (Exception $this$database_u24lambda_u240) {
                    void e;
                    SayanVanishAPI v2 = var12_2;
                    this.databaseConnected = false;
                    this.logDatabaseError();
                    throw e;
                }
                yield var4_3;
            }
            case 2 -> {
                SayanVanishAPI v1;
                SayanVanishAPI var13_8;
                Database var4_3;
                SayanVanishAPI var12_2 = sayanVanishAPI;
                try {
                    void $this$database_u24lambda_u241;
                    var4_3 = new RedisDatabase(DatabaseConfigKt.getDatabaseConfig().getRedis(), this.type, DatabaseConfigKt.getDatabaseConfig().getUseCacheWhenAvailable());
                    e = var4_3;
                    var13_8 = var12_2;
                    boolean $i$a$-apply-SayanVanishAPI$database$2 = false;
                    $this$database_u24lambda_u241.initialize();
                    $this$database_u24lambda_u241.connect();
                    v1 = var13_8;
                }
                catch (Exception $this$database_u24lambda_u241) {
                    void e;
                    SayanVanishAPI v4 = var12_2;
                    this.databaseConnected = false;
                    this.logDatabaseError();
                    throw e;
                }
                yield var4_3;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        Iterable $this$filter$iv = this.database.getUsers();
        boolean $i$f$filter = false;
        e = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            User user2 = (User)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(((BasicUser)user2).getServerId(), Platform.Companion.get().getServerId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (User user3 : (List)destination$iv$iv) {
            user3.setOnline(false);
            user3.save();
        }
        this.database.purgeBasic(Platform.Companion.get().getServerId());
    }

    @NotNull
    public final Class<? extends User> getType() {
        return this.type;
    }

    public SayanVanishAPI() {
        this(User.class);
    }

    public final boolean getDatabaseConnected() {
        return this.databaseConnected;
    }

    public final void setDatabaseConnected(boolean bl) {
        this.databaseConnected = bl;
    }

    @NotNull
    public final Database<U> getDatabase() {
        return this.database;
    }

    @NotNull
    public final Platform getPlatform() {
        return Platform.Companion.get();
    }

    public final boolean isVanished(@NotNull UUID uniqueId, boolean useCache) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        U u = this.database.getUser(uniqueId, useCache);
        return u != null ? u.isVanished() : false;
    }

    public static /* synthetic */ boolean isVanished$default(SayanVanishAPI sayanVanishAPI, UUID uUID, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isVanished");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return sayanVanishAPI.isVanished(uUID, bl);
    }

    public final boolean isVanished(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        U u = this.database.getUser(uniqueId, true);
        return u != null ? u.isVanished() : false;
    }

    public final boolean canSee(@Nullable U user2, @NotNull U target) {
        Intrinsics.checkNotNullParameter(target, "target");
        if (!target.isVanished()) {
            return true;
        }
        U u = user2;
        int vanishLevel = u != null ? u.getVanishLevel() : -1;
        return vanishLevel >= target.getVanishLevel();
    }

    @Nullable
    public final U getUser(@NotNull UUID uniqueId, boolean useCache) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        return this.database.getUser(uniqueId, useCache);
    }

    public static /* synthetic */ User getUser$default(SayanVanishAPI sayanVanishAPI, UUID uUID, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUser");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return sayanVanishAPI.getUser(uUID, bl);
    }

    @Nullable
    public final U getUser(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        return this.getUser(uniqueId, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<U> getOnlineUsers() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.database.getUsers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            User it = (User)element$iv$iv;
            boolean bl = false;
            if (!it.isOnline()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<U> getVanishedUsers() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.database.getUsers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            User it = (User)element$iv$iv;
            boolean bl = false;
            if (!it.isVanished()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void logDatabaseError() {
        Platform.Companion.get().getLogger().severe("Database connection failed. Disabling the plugin.");
        Platform.Companion.get().getLogger().severe("Please check the following:");
        Platform.Companion.get().getLogger().severe("- Make sure your database server is not misconfigured.");
        Platform.Companion.get().getLogger().severe("- Make sure your database server is running.");
        Platform.Companion.get().getLogger().severe("Here's the full error trace:");
    }

    @JvmStatic
    @NotNull
    public static final SayanVanishAPI<User> getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @Nullable
    public static final User user(@NotNull UUID $this$user) {
        return Companion.user($this$user);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0007J\u000e\u0010\b\u001a\u0004\u0018\u00010\u0006*\u00020\tH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/sayandev/sayanvanish/api/SayanVanishAPI$Companion;", "", "<init>", "()V", "defaultInstance", "Lorg/sayandev/sayanvanish/api/SayanVanishAPI;", "Lorg/sayandev/sayanvanish/api/User;", "getInstance", "user", "Ljava/util/UUID;", "sayanvanish-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SayanVanishAPI<User> getInstance() {
            return defaultInstance;
        }

        @JvmStatic
        @Nullable
        public final User user(@NotNull UUID $this$user) {
            Intrinsics.checkNotNullParameter($this$user, "<this>");
            return this.getInstance().getUser($this$user);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseMethod.values().length];
            try {
                nArray[DatabaseMethod.SQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseMethod.REDIS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

