/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.api.database.sql;

import java.io.File;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClasses;
import org.sayandev.sayanvanish.api.BasicUser;
import org.sayandev.sayanvanish.api.Permission;
import org.sayandev.sayanvanish.api.Platform;
import org.sayandev.sayanvanish.api.User;
import org.sayandev.sayanvanish.api.VanishOptions;
import org.sayandev.sayanvanish.api.database.Database;
import org.sayandev.sayanvanish.api.database.DatabaseMethod;
import org.sayandev.sayanvanish.api.database.sql.SQLConfig;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.Nullable;
import org.sayandev.sayanvanish.lib.stickynote.core.database.Query;
import org.sayandev.sayanvanish.lib.stickynote.core.database.QueryResult;
import org.sayandev.sayanvanish.lib.stickynote.core.database.mysql.MySQLCredentials;
import org.sayandev.sayanvanish.lib.stickynote.core.database.mysql.MySQLDatabase;
import org.sayandev.sayanvanish.lib.stickynote.core.database.sqlite.SQLiteDatabase;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020'H\u0016J\u001f\u0010*\u001a\u0004\u0018\u00018\u00002\u0006\u0010+\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010,J\"\u0010-\u001a\u00020'2\u0018\u0010.\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u000000\u0012\u0004\u0012\u00020'0/H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00028\u000000H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u001d002\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u00103\u001a\u00020'2\u0018\u0010.\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d00\u0012\u0004\u0012\u00020'0/H\u0016J\u0015\u00104\u001a\u00020'2\u0006\u00105\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u00020'2\u0006\u00105\u001a\u00020\u001dH\u0016J\u0010\u00108\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0016H\u0016J\u0018\u00109\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010:\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0016H\u0016J\u0010\u0010;\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0016H\u0016J\u0015\u0010<\u001a\u00020'2\u0006\u00105\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00106J\u0010\u0010=\u001a\u00020'2\u0006\u00105\u001a\u00020\u001dH\u0016J$\u0010>\u001a\u00020'2\u0006\u0010+\u001a\u00020\u00162\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020'0/H\u0016J\u0018\u0010@\u001a\u00020'2\u0006\u0010+\u001a\u00020\u00162\u0006\u0010A\u001a\u00020\tH\u0016J$\u0010B\u001a\u00020'2\u0006\u0010+\u001a\u00020\u00162\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020'0/H\u0016J\u0010\u0010C\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0016H\u0016J\b\u0010D\u001a\u00020'H\u0016J\b\u0010E\u001a\u00020'H\u0016J\b\u0010F\u001a\u00020'H\u0016J\u0010\u0010F\u001a\u00020'2\u0006\u0010G\u001a\u00020HH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00028\u00000\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR&\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001d0\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006I"}, d2={"Lorg/sayandev/sayanvanish/api/database/sql/SQLDatabase;", "U", "Lorg/sayandev/sayanvanish/api/User;", "Lorg/sayandev/sayanvanish/api/database/Database;", "config", "Lorg/sayandev/sayanvanish/api/database/sql/SQLConfig;", "type", "Ljava/lang/Class;", "useCache", "", "<init>", "(Lorg/sayandev/sayanvanish/api/database/sql/SQLConfig;Ljava/lang/Class;Z)V", "getConfig", "()Lorg/sayandev/sayanvanish/api/database/sql/SQLConfig;", "getType", "()Ljava/lang/Class;", "getUseCache", "()Z", "setUseCache", "(Z)V", "cache", "", "Ljava/util/UUID;", "getCache", "()Ljava/util/Map;", "setCache", "(Ljava/util/Map;)V", "basicCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/sayandev/sayanvanish/api/BasicUser;", "getBasicCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "setBasicCache", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "database", "Lorg/sayandev/sayanvanish/lib/stickynote/core/database/Database;", "getDatabase", "()Lorg/sayandev/sayanvanish/lib/stickynote/core/database/Database;", "initialize", "", "connect", "disconnect", "getUser", "uniqueId", "(Ljava/util/UUID;Z)Lorg/sayandev/sayanvanish/api/User;", "getUsersAsync", "result", "Lkotlin/Function1;", "", "getUsers", "getBasicUsers", "getBasicUsersAsync", "addUser", "user", "(Lorg/sayandev/sayanvanish/api/User;)V", "addBasicUser", "hasUser", "hasBasicUser", "removeUser", "removeBasicUser", "updateUser", "updateBasicUser", "isInQueue", "inQueue", "addToQueue", "vanished", "getFromQueue", "removeFromQueue", "purgeCache", "purge", "purgeBasic", "serverId", "", "sayanvanish-api"})
@SourceDebugExtension(value={"SMAP\nSQLDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLDatabase.kt\norg/sayandev/sayanvanish/api/database/sql/SQLDatabase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,374:1\n1557#2:375\n1628#2,3:376\n*S KotlinDebug\n*F\n+ 1 SQLDatabase.kt\norg/sayandev/sayanvanish/api/database/sql/SQLDatabase\n*L\n54#1:375\n54#1:376,3\n*E\n"})
public final class SQLDatabase<U extends User>
implements Database<U> {
    @NotNull
    private final SQLConfig config;
    @NotNull
    private final Class<? extends User> type;
    private boolean useCache;
    @NotNull
    private Map<UUID, U> cache;
    @NotNull
    private ConcurrentHashMap<UUID, BasicUser> basicCache;
    @NotNull
    private final org.sayandev.sayanvanish.lib.stickynote.core.database.Database database;

    public SQLDatabase(@NotNull SQLConfig config, @NotNull Class<? extends User> type, boolean useCache) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(type, "type");
        this.config = config;
        this.type = type;
        this.useCache = useCache;
        this.cache = new LinkedHashMap();
        this.basicCache = new ConcurrentHashMap();
        SQLDatabase sQLDatabase = this;
        sQLDatabase.database = switch (WhenMappings.$EnumSwitchMapping$0[this.config.getMethod().ordinal()]) {
            case 1 -> {
                String var7_15;
                SQLDatabase var5_4 = this;
                boolean var16_6 = this.config.getPoolProperties().getVerifyServerCertificate();
                int var15_7 = this.config.getPoolProperties().getMaximumPoolSize();
                MySQLCredentials var14_9 = MySQLCredentials.Companion.mySQLCredentials(this.config.getHost(), this.config.getPort(), this.config.getDatabase(), this.config.getPoolProperties().getUseSSL(), this.config.getUsername(), this.config.getPassword());
                SQLDatabase var13_11 = sQLDatabase;
                boolean $i$a$-let-SQLDatabase$database$1 = false;
                try {
                    Class.forName("org.sayandev.sayanvanish.lib.mysql.cj.jdbc.Driver");
                    var7_15 = "org.sayandev.sayanvanish.lib.mysql.cj.jdbc.Driver";
                }
                catch (ClassNotFoundException e) {
                    Class.forName("org.sayandev.sayanvanish.lib.mysql.jdbc.Driver");
                    var7_15 = "org.sayandev.sayanvanish.lib.mysql.jdbc.Driver";
                }
                String var17_19 = var7_15;
                sQLDatabase = var13_11;
                boolean var18_20 = this.config.getPoolProperties().getAllowPublicKeyRetrieval();
                Long var19_21 = this.config.getPoolProperties().getMaximumLifetime();
                Integer var20_22 = this.config.getPoolProperties().getMinimumIdle();
                Long var21_23 = this.config.getPoolProperties().getConnectionTimeout();
                Long var22_24 = this.config.getPoolProperties().getKeepaliveTime();
                String var23_25 = var17_19;
                boolean var24_26 = var16_6;
                int var25_27 = var15_7;
                MySQLCredentials var26_28 = var14_9;
                yield (org.sayandev.sayanvanish.lib.stickynote.core.database.Database)new MySQLDatabase(var26_28, var25_27, var24_26, var23_25, var22_24, var21_23, var20_22, var19_21, var18_20);
            }
            case 2 -> (org.sayandev.sayanvanish.lib.stickynote.core.database.Database)new SQLiteDatabase(new File(Platform.Companion.get().getRootDirectory(), "storage.db"), Platform.Companion.get().getLogger(), this.config.getPoolProperties().getMaximumPoolSize());
            default -> {
                Collection<String> var15_8;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable var4_29 = DatabaseMethod.getEntries();
                String var14_10 = this.config.getMethod().name();
                SQLDatabase var13_12 = sQLDatabase;
                boolean $i$f$map = false;
                void $i$a$-let-SQLDatabase$database$1 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DatabaseMethod var11_32 = (DatabaseMethod)((Object)item$iv$iv);
                    var15_8 = destination$iv$iv;
                    boolean $i$a$-map-SQLDatabase$database$2 = false;
                    String v2 = it.name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(v2, "toLowerCase(...)");
                    var15_8.add(v2);
                }
                var15_8 = (List)destination$iv$iv;
                SQLDatabase v3 = var13_12;
                String var27_34 = "Database method with id `" + var14_10 + "` doesn't exist, available database types: " + (List)var15_8;
                throw new NullPointerException(var27_34);
            }
        };
    }

    public /* synthetic */ SQLDatabase(SQLConfig sQLConfig, Class clazz, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(sQLConfig, clazz, bl);
    }

    @NotNull
    public final SQLConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Class<? extends User> getType() {
        return this.type;
    }

    @Override
    public boolean getUseCache() {
        return this.useCache;
    }

    @Override
    public void setUseCache(boolean bl) {
        this.useCache = bl;
    }

    @Override
    @NotNull
    public Map<UUID, U> getCache() {
        return this.cache;
    }

    @Override
    public void setCache(@NotNull Map<UUID, U> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.cache = map;
    }

    @NotNull
    public final ConcurrentHashMap<UUID, BasicUser> getBasicCache() {
        return this.basicCache;
    }

    public final void setBasicCache(@NotNull ConcurrentHashMap<UUID, BasicUser> concurrentHashMap) {
        Intrinsics.checkNotNullParameter(concurrentHashMap, "<set-?>");
        this.basicCache = concurrentHashMap;
    }

    @NotNull
    public final org.sayandev.sayanvanish.lib.stickynote.core.database.Database getDatabase() {
        return this.database;
    }

    @Override
    public void initialize() {
        this.database.runQuery(Query.Companion.query("CREATE TABLE IF NOT EXISTS " + this.config.getTablePrefix() + "users (UUID VARCHAR(64),username VARCHAR(16),server VARCHAR(128),is_vanished INT,is_online INT,vanish_level INT,PRIMARY KEY (UUID));")).close();
        this.database.runQuery(Query.Companion.query("CREATE TABLE IF NOT EXISTS " + this.config.getTablePrefix() + "basic_users (UUID VARCHAR(64),username VARCHAR(16),server VARCHAR(128),PRIMARY KEY (UUID));")).close();
        this.database.runQuery(Query.Companion.query("CREATE TABLE IF NOT EXISTS " + this.config.getTablePrefix() + "queue (UUID VARCHAR(64), vanished VARCHAR(16),PRIMARY KEY (UUID));")).close();
    }

    @Override
    public void connect() {
        this.getCache().clear();
        this.database.connect();
    }

    @Override
    public void disconnect() {
        this.database.shutdown();
        this.getCache().clear();
    }

    @Override
    @Nullable
    public U getUser(@NotNull UUID uniqueId, boolean useCache) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        User cacheUser = (User)this.getCache().get(uniqueId);
        if (this.getUseCache() && useCache) {
            if (cacheUser == null) {
                return null;
            }
            User user2 = KClasses.safeCast(JvmClassMappingKt.getKotlinClass(this.type), cacheUser);
            User user3 = user2 instanceof User ? user2 : null;
            if (user3 == null) {
                Object object = User.Companion.convert(cacheUser, this.type);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type U of org.sayandev.sayanvanish.api.database.sql.SQLDatabase");
                user3 = (User)object;
            }
            return (U)user3;
        }
        Query query = Query.Companion.query("SELECT * FROM " + this.config.getTablePrefix() + "users WHERE UUID = ?;");
        String string = uniqueId.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        QueryResult queryResult = this.database.runQuery(query.setStatementValue(1, (Object)string));
        ResultSet resultSet = queryResult.getResult();
        if (resultSet == null) {
            return null;
        }
        ResultSet result2 = resultSet;
        if (!result2.next()) {
            queryResult.close();
            return null;
        }
        User user4 = new User(result2){
            private final UUID uniqueId;
            private String username;
            private String serverId;
            private VanishOptions currentOptions;
            private boolean isVanished;
            private boolean isOnline;
            private int vanishLevel;
            {
                UUID uUID = UUID.fromString($result.getString("UUID"));
                Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
                this.uniqueId = uUID;
                String string = $result.getString("username");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                this.username = string;
                String string2 = $result.getString("server");
                Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                this.serverId = string2;
                this.currentOptions = VanishOptions.Companion.defaultOptions();
                this.isVanished = $result.getBoolean("is_vanished");
                this.isOnline = $result.getBoolean("is_online");
                this.vanishLevel = $result.getInt("vanish_level");
            }

            public UUID getUniqueId() {
                return this.uniqueId;
            }

            public String getUsername() {
                return this.username;
            }

            public void setUsername(String string) {
                Intrinsics.checkNotNullParameter(string, "<set-?>");
                this.username = string;
            }

            public String getServerId() {
                return this.serverId;
            }

            public void setServerId(String string) {
                Intrinsics.checkNotNullParameter(string, "<set-?>");
                this.serverId = string;
            }

            public VanishOptions getCurrentOptions() {
                return this.currentOptions;
            }

            public void setCurrentOptions(VanishOptions vanishOptions) {
                Intrinsics.checkNotNullParameter(vanishOptions, "<set-?>");
                this.currentOptions = vanishOptions;
            }

            public boolean isVanished() {
                return this.isVanished;
            }

            public void setVanished(boolean bl) {
                this.isVanished = bl;
            }

            public boolean isOnline() {
                return this.isOnline;
            }

            public void setOnline(boolean bl) {
                this.isOnline = bl;
            }

            public int getVanishLevel() {
                return this.vanishLevel;
            }

            public void setVanishLevel(int n) {
                this.vanishLevel = n;
            }

            public void vanish(VanishOptions options) {
                User.DefaultImpls.vanish(this, options);
            }

            public void vanish() {
                User.DefaultImpls.vanish(this);
            }

            public void unVanish(VanishOptions options) {
                User.DefaultImpls.unVanish(this, options);
            }

            public void unVanish() {
                User.DefaultImpls.unVanish(this);
            }

            public void toggleVanish(VanishOptions options) {
                User.DefaultImpls.toggleVanish(this, options);
            }

            public void toggleVanish() {
                User.DefaultImpls.toggleVanish(this);
            }

            public void sendComponent(String content) {
                User.DefaultImpls.sendComponent(this, content);
            }

            public void sendComponent(String content, Pair<String, String> ... placeholder) {
                User.DefaultImpls.sendComponent(this, content, placeholder);
            }

            public void sendActionbar(String content) {
                User.DefaultImpls.sendActionbar(this, content);
            }

            public void sendActionbar(String content, Pair<String, String> ... placeholder) {
                User.DefaultImpls.sendActionbar(this, content, placeholder);
            }

            public boolean canSee(User otherUser) {
                return User.DefaultImpls.canSee(this, otherUser);
            }

            public void save() {
                User.DefaultImpls.save(this);
            }

            public void delete() {
                User.DefaultImpls.delete(this);
            }

            public String toJson() {
                return User.DefaultImpls.toJson(this);
            }

            public boolean hasPermission(String permission) {
                return User.DefaultImpls.hasPermission((User)this, permission);
            }

            public boolean hasPermission(Permission permission) {
                return User.DefaultImpls.hasPermission((User)this, permission);
            }
        };
        User user5 = KClasses.safeCast(JvmClassMappingKt.getKotlinClass(this.type), user4);
        User user6 = user5 instanceof User ? user5 : null;
        if (user6 == null) {
            Object object = User.Companion.convert(user4, this.type);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type U of org.sayandev.sayanvanish.api.database.sql.SQLDatabase");
            user6 = (User)object;
        }
        User typedUser = user6;
        this.getCache().put(uniqueId, typedUser);
        queryResult.close();
        return (U)typedUser;
    }

    @Override
    public void getUsersAsync(@NotNull Function1<? super List<? extends U>, Unit> result2) {
        Intrinsics.checkNotNullParameter(result2, "result");
        this.database.queueQuery(Query.Companion.query("SELECT * FROM " + this.config.getTablePrefix() + "users;")).getCompletableFuture().whenComplete((arg_0, arg_1) -> SQLDatabase.getUsersAsync$lambda$3((arg_0, arg_1) -> SQLDatabase.getUsersAsync$lambda$2(this, result2, arg_0, arg_1), arg_0, arg_1));
    }

    @Override
    @NotNull
    public List<U> getUsers() {
        if (this.getUseCache()) {
            return CollectionsKt.toList((Iterable)this.getCache().values());
        }
        QueryResult queryResult = this.database.runQuery(Query.Companion.query("SELECT * FROM " + this.config.getTablePrefix() + "users;"));
        ResultSet resultSet = queryResult.getResult();
        if (resultSet == null) {
            return CollectionsKt.emptyList();
        }
        ResultSet result2 = resultSet;
        List users = new ArrayList();
        while (result2.next()) {
            User user2 = new User(result2){
                private final UUID uniqueId;
                private String username;
                private String serverId;
                private VanishOptions currentOptions;
                private boolean isVanished;
                private boolean isOnline;
                private int vanishLevel;
                {
                    UUID uUID = UUID.fromString($result.getString("UUID"));
                    Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
                    this.uniqueId = uUID;
                    String string = $result.getString("username");
                    Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                    this.username = string;
                    String string2 = $result.getString("server");
                    Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                    this.serverId = string2;
                    this.currentOptions = VanishOptions.Companion.defaultOptions();
                    this.isVanished = $result.getBoolean("is_vanished");
                    this.isOnline = $result.getBoolean("is_online");
                    this.vanishLevel = $result.getInt("vanish_level");
                }

                public UUID getUniqueId() {
                    return this.uniqueId;
                }

                public String getUsername() {
                    return this.username;
                }

                public void setUsername(String string) {
                    Intrinsics.checkNotNullParameter(string, "<set-?>");
                    this.username = string;
                }

                public String getServerId() {
                    return this.serverId;
                }

                public void setServerId(String string) {
                    Intrinsics.checkNotNullParameter(string, "<set-?>");
                    this.serverId = string;
                }

                public VanishOptions getCurrentOptions() {
                    return this.currentOptions;
                }

                public void setCurrentOptions(VanishOptions vanishOptions) {
                    Intrinsics.checkNotNullParameter(vanishOptions, "<set-?>");
                    this.currentOptions = vanishOptions;
                }

                public boolean isVanished() {
                    return this.isVanished;
                }

                public void setVanished(boolean bl) {
                    this.isVanished = bl;
                }

                public boolean isOnline() {
                    return this.isOnline;
                }

                public void setOnline(boolean bl) {
                    this.isOnline = bl;
                }

                public int getVanishLevel() {
                    return this.vanishLevel;
                }

                public void setVanishLevel(int n) {
                    this.vanishLevel = n;
                }

                public void vanish(VanishOptions options) {
                    User.DefaultImpls.vanish(this, options);
                }

                public void vanish() {
                    User.DefaultImpls.vanish(this);
                }

                public void unVanish(VanishOptions options) {
                    User.DefaultImpls.unVanish(this, options);
                }

                public void unVanish() {
                    User.DefaultImpls.unVanish(this);
                }

                public void toggleVanish(VanishOptions options) {
                    User.DefaultImpls.toggleVanish(this, options);
                }

                public void toggleVanish() {
                    User.DefaultImpls.toggleVanish(this);
                }

                public void sendComponent(String content) {
                    User.DefaultImpls.sendComponent(this, content);
                }

                public void sendComponent(String content, Pair<String, String> ... placeholder) {
                    User.DefaultImpls.sendComponent(this, content, placeholder);
                }

                public void sendActionbar(String content) {
                    User.DefaultImpls.sendActionbar(this, content);
                }

                public void sendActionbar(String content, Pair<String, String> ... placeholder) {
                    User.DefaultImpls.sendActionbar(this, content, placeholder);
                }

                public boolean canSee(User otherUser) {
                    return User.DefaultImpls.canSee(this, otherUser);
                }

                public void save() {
                    User.DefaultImpls.save(this);
                }

                public void delete() {
                    User.DefaultImpls.delete(this);
                }

                public String toJson() {
                    return User.DefaultImpls.toJson(this);
                }

                public boolean hasPermission(String permission) {
                    return User.DefaultImpls.hasPermission((User)this, permission);
                }

                public boolean hasPermission(Permission permission) {
                    return User.DefaultImpls.hasPermission((User)this, permission);
                }
            };
            User user3 = KClasses.safeCast(JvmClassMappingKt.getKotlinClass(this.type), user2);
            User user4 = user3 instanceof User ? user3 : null;
            if (user4 == null) {
                Object object = User.Companion.convert(user2, this.type);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type U of org.sayandev.sayanvanish.api.database.sql.SQLDatabase");
                user4 = (User)object;
            }
            users.add(user4);
        }
        queryResult.close();
        return users;
    }

    @Override
    @NotNull
    public List<BasicUser> getBasicUsers(boolean useCache) {
        if (useCache) {
            Collection<BasicUser> collection = this.basicCache.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            return CollectionsKt.toList((Iterable)collection);
        }
        QueryResult queryResult = this.database.runQuery(Query.Companion.query("SELECT * FROM " + this.config.getTablePrefix() + "basic_users;"));
        ResultSet resultSet = queryResult.getResult();
        if (resultSet == null) {
            return CollectionsKt.emptyList();
        }
        ResultSet result2 = resultSet;
        List users = new ArrayList();
        while (result2.next()) {
            UUID uUID = UUID.fromString(result2.getString("UUID"));
            Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
            String string = result2.getString("username");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            BasicUser user2 = BasicUser.Companion.create(uUID, string, result2.getString("server"));
            users.add(user2);
        }
        queryResult.close();
        return users;
    }

    @Override
    public void getBasicUsersAsync(@NotNull Function1<? super List<? extends BasicUser>, Unit> result2) {
        Intrinsics.checkNotNullParameter(result2, "result");
        this.database.queueQuery(Query.Companion.query("SELECT * FROM " + this.config.getTablePrefix() + "basic_users;")).getCompletableFuture().whenComplete((arg_0, arg_1) -> SQLDatabase.getBasicUsersAsync$lambda$5((arg_0, arg_1) -> SQLDatabase.getBasicUsersAsync$lambda$4(result2, arg_0, arg_1), arg_0, arg_1));
    }

    @Override
    public void addUser(@NotNull U user2) {
        Intrinsics.checkNotNullParameter(user2, "user");
        this.getCache().put(((BasicUser)user2).getUniqueId(), user2);
        if (!this.hasUser(((BasicUser)user2).getUniqueId())) {
            String insertQuery = this.config.getMethod() == SQLConfig.SQLMethod.SQLITE ? "INSERT OR REPLACE INTO " + this.config.getTablePrefix() + "users (UUID, username, server, is_vanished, is_online, vanish_level) VALUES (?,?,?,?,?,?);" : "INSERT IGNORE INTO " + this.config.getTablePrefix() + "users (UUID, username, server, is_vanished, is_online, vanish_level) VALUES (?,?,?,?,?,?);";
            Query query = Query.Companion.query(insertQuery);
            String string = ((BasicUser)user2).getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            this.database.runQuery(query.setStatementValue(1, (Object)string).setStatementValue(2, (Object)((BasicUser)user2).getUsername()).setStatementValue(3, (Object)((BasicUser)user2).getServerId()).setStatementValue(4, (Object)user2.isVanished()).setStatementValue(5, (Object)user2.isOnline()).setStatementValue(6, (Object)user2.getVanishLevel())).close();
        } else {
            this.updateUser(user2);
        }
    }

    @Override
    public void addBasicUser(@NotNull BasicUser user2) {
        Intrinsics.checkNotNullParameter(user2, "user");
        ((Map)this.basicCache).put(user2.getUniqueId(), user2);
        if (!this.hasBasicUser(user2.getUniqueId(), false)) {
            String insertQuery = this.config.getMethod() == SQLConfig.SQLMethod.SQLITE ? "INSERT OR REPLACE INTO " + this.config.getTablePrefix() + "basic_users (UUID, username, server) VALUES (?,?,?);" : "INSERT IGNORE INTO " + this.config.getTablePrefix() + "basic_users (UUID, username, server) VALUES (?,?,?);";
            Query query = Query.Companion.query(insertQuery);
            String string = user2.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            this.database.runQuery(query.setStatementValue(1, (Object)string).setStatementValue(2, (Object)user2.getUsername()).setStatementValue(3, (Object)user2.getServerId())).close();
        } else if (!Intrinsics.areEqual(user2.getServerId(), Platform.Companion.get().getServerId())) {
            this.updateBasicUser(user2);
        }
    }

    @Override
    public boolean hasUser(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Query query = Query.Companion.query("SELECT * FROM " + this.config.getTablePrefix() + "users WHERE UUID = ?;");
        String string = uniqueId.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        QueryResult queryResult = this.database.runQuery(query.setStatementValue(1, (Object)string));
        ResultSet resultSet = queryResult.getResult();
        if (resultSet == null) {
            return false;
        }
        ResultSet result2 = resultSet;
        boolean hasNext = result2.next();
        queryResult.close();
        return hasNext;
    }

    @Override
    public boolean hasBasicUser(@NotNull UUID uniqueId, boolean useCache) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        if (useCache) {
            return this.basicCache.contains(uniqueId);
        }
        Query query = Query.Companion.query("SELECT * FROM " + this.config.getTablePrefix() + "basic_users WHERE UUID = ?;");
        String string = uniqueId.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        QueryResult queryResult = this.database.runQuery(query.setStatementValue(1, (Object)string));
        ResultSet resultSet = queryResult.getResult();
        if (resultSet == null) {
            return false;
        }
        ResultSet result2 = resultSet;
        boolean hasNext = result2.next();
        queryResult.close();
        return hasNext;
    }

    @Override
    public void removeUser(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        this.getCache().remove(uniqueId);
        Query query = Query.Companion.query("DELETE FROM " + this.config.getTablePrefix() + "users WHERE UUID = ?;");
        String string = uniqueId.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.database.runQuery(query.setStatementValue(1, (Object)string)).close();
    }

    @Override
    public void removeBasicUser(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        this.basicCache.remove(uniqueId);
        Query query = Query.Companion.query("DELETE FROM " + this.config.getTablePrefix() + "basic_users WHERE UUID = ?;");
        String string = uniqueId.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.database.runQuery(query.setStatementValue(1, (Object)string)).close();
    }

    @Override
    public void updateUser(@NotNull U user2) {
        Intrinsics.checkNotNullParameter(user2, "user");
        this.getCache().put(((BasicUser)user2).getUniqueId(), user2);
        Query query = Query.Companion.query("UPDATE " + this.config.getTablePrefix() + "users SET username = ?, is_vanished = ?, is_online = ?, vanish_level = ? WHERE UUID = ?;").setStatementValue(1, (Object)((BasicUser)user2).getUsername()).setStatementValue(2, (Object)user2.isVanished()).setStatementValue(3, (Object)user2.isOnline()).setStatementValue(4, (Object)user2.getVanishLevel());
        String string = ((BasicUser)user2).getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.database.runQuery(query.setStatementValue(5, (Object)string)).close();
    }

    @Override
    public void updateBasicUser(@NotNull BasicUser user2) {
        Intrinsics.checkNotNullParameter(user2, "user");
        ((Map)this.basicCache).put(user2.getUniqueId(), user2);
        Query query = Query.Companion.query("UPDATE " + this.config.getTablePrefix() + "basic_users SET username = ?, server = ? WHERE UUID = ?;").setStatementValue(1, (Object)user2.getUsername()).setStatementValue(2, (Object)user2.getServerId());
        String string = user2.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.database.runQuery(query.setStatementValue(3, (Object)string)).close();
    }

    @Override
    public void isInQueue(@NotNull UUID uniqueId, @NotNull Function1<? super Boolean, Unit> inQueue) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Intrinsics.checkNotNullParameter(inQueue, "inQueue");
        Query query = Query.Companion.query("SELECT * FROM " + this.config.getTablePrefix() + "queue WHERE UUID = ?;");
        String string = uniqueId.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.database.queueQuery(query.setStatementValue(1, (Object)string)).getCompletableFuture().whenComplete((arg_0, arg_1) -> SQLDatabase.isInQueue$lambda$7((arg_0, arg_1) -> SQLDatabase.isInQueue$lambda$6(inQueue, arg_0, arg_1), arg_0, arg_1));
    }

    @Override
    public void addToQueue(@NotNull UUID uniqueId, boolean vanished) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        this.isInQueue(uniqueId, arg_0 -> SQLDatabase.addToQueue$lambda$12(this, uniqueId, vanished, arg_0));
    }

    @Override
    public void getFromQueue(@NotNull UUID uniqueId, @NotNull Function1<? super Boolean, Unit> result2) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Intrinsics.checkNotNullParameter(result2, "result");
        Query query = Query.Companion.query("SELECT * FROM " + this.config.getTablePrefix() + "queue WHERE UUID = ?;");
        String string = uniqueId.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.database.queueQuery(query.setStatementValue(1, (Object)string)).getCompletableFuture().whenComplete((arg_0, arg_1) -> SQLDatabase.getFromQueue$lambda$14((arg_0, arg_1) -> SQLDatabase.getFromQueue$lambda$13(result2, arg_0, arg_1), arg_0, arg_1));
    }

    @Override
    public void removeFromQueue(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Query query = Query.Companion.query("DELETE FROM " + this.config.getTablePrefix() + "queue WHERE UUID = ?;");
        String string = uniqueId.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.database.queueQuery(query.setStatementValue(1, (Object)string)).getCompletableFuture().whenComplete((arg_0, arg_1) -> SQLDatabase.removeFromQueue$lambda$16(SQLDatabase::removeFromQueue$lambda$15, arg_0, arg_1));
    }

    @Override
    public void purgeCache() {
        this.getCache().clear();
        this.basicCache.clear();
    }

    @Override
    public void purge() {
        this.database.runQuery(Query.Companion.query("DELETE FROM " + this.config.getTablePrefix() + "users;")).close();
        this.database.runQuery(Query.Companion.query("DELETE FROM " + this.config.getTablePrefix() + "basic_users;")).close();
        this.database.runQuery(Query.Companion.query("DELETE FROM " + this.config.getTablePrefix() + "queue;")).close();
    }

    @Override
    public void purgeBasic() {
        this.database.runQuery(Query.Companion.query("DELETE FROM " + this.config.getTablePrefix() + "basic_users;")).close();
        this.database.runQuery(Query.Companion.query("DELETE FROM " + this.config.getTablePrefix() + "queue;")).close();
    }

    @Override
    public void purgeBasic(@NotNull String serverId) {
        Intrinsics.checkNotNullParameter(serverId, "serverId");
        this.database.runQuery(Query.Companion.query("DELETE FROM " + this.config.getTablePrefix() + "basic_users WHERE server = ?;").setStatementValue(1, (Object)serverId)).close();
    }

    @Override
    @Nullable
    public U getUser(@NotNull UUID uniqueId) {
        return Database.DefaultImpls.getUser(this, uniqueId);
    }

    private static final Unit getUsersAsync$lambda$2(SQLDatabase this$0, Function1 $result, QueryResult queryResult, Throwable error) {
        Throwable throwable = error;
        if (throwable != null) {
            throwable.printStackTrace();
        }
        List users = new ArrayList();
        ResultSet resultSet = queryResult.getResult();
        if (resultSet != null) {
            while (resultSet.next()) {
                User user2 = new User(resultSet){
                    private final UUID uniqueId;
                    private String username;
                    private String serverId;
                    private VanishOptions currentOptions;
                    private boolean isVanished;
                    private boolean isOnline;
                    private int vanishLevel;
                    {
                        UUID uUID = UUID.fromString($resultSet.getString("UUID"));
                        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
                        this.uniqueId = uUID;
                        String string = $resultSet.getString("username");
                        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                        this.username = string;
                        String string2 = $resultSet.getString("server");
                        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                        this.serverId = string2;
                        this.currentOptions = VanishOptions.Companion.defaultOptions();
                        this.isVanished = $resultSet.getBoolean("is_vanished");
                        this.isOnline = $resultSet.getBoolean("is_online");
                        this.vanishLevel = $resultSet.getInt("vanish_level");
                    }

                    public UUID getUniqueId() {
                        return this.uniqueId;
                    }

                    public String getUsername() {
                        return this.username;
                    }

                    public void setUsername(String string) {
                        Intrinsics.checkNotNullParameter(string, "<set-?>");
                        this.username = string;
                    }

                    public String getServerId() {
                        return this.serverId;
                    }

                    public void setServerId(String string) {
                        Intrinsics.checkNotNullParameter(string, "<set-?>");
                        this.serverId = string;
                    }

                    public VanishOptions getCurrentOptions() {
                        return this.currentOptions;
                    }

                    public void setCurrentOptions(VanishOptions vanishOptions) {
                        Intrinsics.checkNotNullParameter(vanishOptions, "<set-?>");
                        this.currentOptions = vanishOptions;
                    }

                    public boolean isVanished() {
                        return this.isVanished;
                    }

                    public void setVanished(boolean bl) {
                        this.isVanished = bl;
                    }

                    public boolean isOnline() {
                        return this.isOnline;
                    }

                    public void setOnline(boolean bl) {
                        this.isOnline = bl;
                    }

                    public int getVanishLevel() {
                        return this.vanishLevel;
                    }

                    public void setVanishLevel(int n) {
                        this.vanishLevel = n;
                    }

                    public void vanish(VanishOptions options) {
                        User.DefaultImpls.vanish(this, options);
                    }

                    public void vanish() {
                        User.DefaultImpls.vanish(this);
                    }

                    public void unVanish(VanishOptions options) {
                        User.DefaultImpls.unVanish(this, options);
                    }

                    public void unVanish() {
                        User.DefaultImpls.unVanish(this);
                    }

                    public void toggleVanish(VanishOptions options) {
                        User.DefaultImpls.toggleVanish(this, options);
                    }

                    public void toggleVanish() {
                        User.DefaultImpls.toggleVanish(this);
                    }

                    public void sendComponent(String content) {
                        User.DefaultImpls.sendComponent(this, content);
                    }

                    public void sendComponent(String content, Pair<String, String> ... placeholder) {
                        User.DefaultImpls.sendComponent(this, content, placeholder);
                    }

                    public void sendActionbar(String content) {
                        User.DefaultImpls.sendActionbar(this, content);
                    }

                    public void sendActionbar(String content, Pair<String, String> ... placeholder) {
                        User.DefaultImpls.sendActionbar(this, content, placeholder);
                    }

                    public boolean canSee(User otherUser) {
                        return User.DefaultImpls.canSee(this, otherUser);
                    }

                    public void save() {
                        User.DefaultImpls.save(this);
                    }

                    public void delete() {
                        User.DefaultImpls.delete(this);
                    }

                    public String toJson() {
                        return User.DefaultImpls.toJson(this);
                    }

                    public boolean hasPermission(String permission) {
                        return User.DefaultImpls.hasPermission((User)this, permission);
                    }

                    public boolean hasPermission(Permission permission) {
                        return User.DefaultImpls.hasPermission((User)this, permission);
                    }
                };
                User user3 = KClasses.safeCast(JvmClassMappingKt.getKotlinClass(this$0.type), user2);
                User user4 = user3 instanceof User ? user3 : null;
                if (user4 == null) {
                    Object object = User.Companion.convert(user2, this$0.type);
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type U of org.sayandev.sayanvanish.api.database.sql.SQLDatabase");
                    user4 = (User)object;
                }
                users.add(user4);
            }
        } else {
            Platform.Companion.get().getLogger().severe("Failed to fetch users from database (getUsersAsync)");
        }
        queryResult.close();
        $result.invoke(users);
        return Unit.INSTANCE;
    }

    private static final void getUsersAsync$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit getBasicUsersAsync$lambda$4(Function1 $result, QueryResult queryResult, Throwable error) {
        Throwable throwable = error;
        if (throwable != null) {
            throwable.printStackTrace();
        }
        List users = new ArrayList();
        ResultSet resultSet = queryResult.getResult();
        if (resultSet != null) {
            while (resultSet.next()) {
                UUID uUID = UUID.fromString(resultSet.getString("UUID"));
                Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
                String string = resultSet.getString("username");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                BasicUser user2 = BasicUser.Companion.create(uUID, string, resultSet.getString("server"));
                users.add(user2);
            }
        } else {
            Platform.Companion.get().getLogger().severe("Failed to fetch users from database (getBasicUsersAsync)");
        }
        queryResult.close();
        $result.invoke(users);
        return Unit.INSTANCE;
    }

    private static final void getBasicUsersAsync$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit isInQueue$lambda$6(Function1 $inQueue, QueryResult queryResult, Throwable error) {
        Throwable throwable = error;
        if (throwable != null) {
            throwable.printStackTrace();
        }
        ResultSet resultSet = queryResult.getResult();
        if (resultSet != null) {
            boolean hasNext = resultSet.next();
            $inQueue.invoke(hasNext);
        } else {
            Platform.Companion.get().getLogger().severe("Failed to fetch is in queue from database (isInQueue)");
            $inQueue.invoke(false);
        }
        queryResult.close();
        return Unit.INSTANCE;
    }

    private static final void isInQueue$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit addToQueue$lambda$12$lambda$8(QueryResult result2, Throwable error) {
        Throwable throwable = error;
        if (throwable != null) {
            throwable.printStackTrace();
        }
        result2.close();
        return Unit.INSTANCE;
    }

    private static final void addToQueue$lambda$12$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit addToQueue$lambda$12$lambda$10(QueryResult result2, Throwable error) {
        Throwable throwable = error;
        if (throwable != null) {
            throwable.printStackTrace();
        }
        result2.close();
        return Unit.INSTANCE;
    }

    private static final void addToQueue$lambda$12$lambda$11(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit addToQueue$lambda$12(SQLDatabase this$0, UUID $uniqueId, boolean $vanished, boolean inQueue) {
        if (!inQueue) {
            String insertQuery = this$0.config.getMethod() == SQLConfig.SQLMethod.SQLITE ? "INSERT OR REPLACE INTO " + this$0.config.getTablePrefix() + "queue (UUID, vanished) VALUES (?,?);" : "INSERT IGNORE INTO " + this$0.config.getTablePrefix() + "queue (UUID, vanished) VALUES (?,?);";
            org.sayandev.sayanvanish.lib.stickynote.core.database.Database database = this$0.database;
            Query query = Query.Companion.query(insertQuery);
            String string = $uniqueId.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            v3 = database.queueQuery(query.setStatementValue(1, (Object)string).setStatementValue(2, (Object)String.valueOf($vanished))).getCompletableFuture().whenComplete((arg_0, arg_1) -> SQLDatabase.addToQueue$lambda$12$lambda$9(SQLDatabase::addToQueue$lambda$12$lambda$8, arg_0, arg_1));
        } else {
            org.sayandev.sayanvanish.lib.stickynote.core.database.Database database = this$0.database;
            Query query = Query.Companion.query("UPDATE " + this$0.config.getTablePrefix() + "queue SET vanished = ? WHERE UUID = ?;").setStatementValue(1, (Object)String.valueOf($vanished));
            String string = $uniqueId.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            v3 = database.queueQuery(query.setStatementValue(2, (Object)string)).getCompletableFuture().whenComplete((arg_0, arg_1) -> SQLDatabase.addToQueue$lambda$12$lambda$11(SQLDatabase::addToQueue$lambda$12$lambda$10, arg_0, arg_1));
        }
        return Unit.INSTANCE;
    }

    private static final Unit getFromQueue$lambda$13(Function1 $result, QueryResult queryResult, Throwable error) {
        Throwable throwable = error;
        if (throwable != null) {
            throwable.printStackTrace();
        }
        ResultSet resultSet = queryResult.getResult();
        if (resultSet != null) {
            if (!resultSet.next()) {
                $result.invoke(false);
            }
            $result.invoke(Boolean.parseBoolean(resultSet.getString("vanished")));
        } else {
            Platform.Companion.get().getLogger().severe("Failed to fetch queue from database (getFromQueue)");
            $result.invoke(false);
        }
        queryResult.close();
        return Unit.INSTANCE;
    }

    private static final void getFromQueue$lambda$14(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit removeFromQueue$lambda$15(QueryResult result2, Throwable error) {
        Throwable throwable = error;
        if (throwable != null) {
            throwable.printStackTrace();
        }
        result2.close();
        return Unit.INSTANCE;
    }

    private static final void removeFromQueue$lambda$16(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SQLConfig.SQLMethod.values().length];
            try {
                nArray[SQLConfig.SQLMethod.MYSQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SQLConfig.SQLMethod.SQLITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

