/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.velocity;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.sayandev.sayanvanish.api.BasicUser;
import org.sayandev.sayanvanish.api.Platform;
import org.sayandev.sayanvanish.api.database.Database;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;
import org.sayandev.sayanvanish.lib.stickynote.velocity.StickyNoteKt;
import org.sayandev.sayanvanish.velocity.api.SayanVanishVelocityAPI;
import org.sayandev.sayanvanish.velocity.api.VelocityUser;
import org.sayandev.sayanvanish.velocity.event.VelocityUserUnVanishEvent;
import org.sayandev.sayanvanish.velocity.event.VelocityUserVanishEvent;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0003\u00a8\u0006\n"}, d2={"Lorg/sayandev/sayanvanish/velocity/VanishManager;", "", "<init>", "()V", "onPostLogin", "", "event", "Lcom/velocitypowered/api/event/player/ServerPostConnectEvent;", "onDisconnect", "Lcom/velocitypowered/api/event/connection/DisconnectEvent;", "sayanvanish-proxy-velocity"})
public final class VanishManager {
    @NotNull
    public static final VanishManager INSTANCE = new VanishManager();

    private VanishManager() {
    }

    @Subscribe
    private final void onPostLogin(ServerPostConnectEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        Player player2 = player;
        Database<VelocityUser> database = SayanVanishVelocityAPI.Companion.getInstance().getDatabase();
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        String string = player2.getUsername();
        Intrinsics.checkNotNullExpressionValue(string, "getUsername(...)");
        Optional optional = player2.getCurrentServer();
        Intrinsics.checkNotNullExpressionValue(optional, "getCurrentServer(...)");
        Object object = (ServerConnection)OptionalsKt.getOrNull(optional);
        if (object == null || (object = object.getServerInfo()) == null || (object = object.getName()) == null) {
            object = Platform.Companion.get().getId();
        }
        database.addBasicUser(BasicUser.Companion.create(uUID, string, (String)object));
        VelocityUser user2 = SayanVanishVelocityAPI.Companion.getOrCreateUser(player2);
        if (user2.isVanished()) {
            StickyNoteKt.getServer().getEventManager().fireAndForget((Object)new VelocityUserVanishEvent(user2, user2.getCurrentOptions()));
        } else {
            StickyNoteKt.getServer().getEventManager().fireAndForget((Object)new VelocityUserUnVanishEvent(user2, user2.getCurrentOptions()));
        }
    }

    @Subscribe
    private final void onDisconnect(DisconnectEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        Player player2 = player;
        Database<VelocityUser> database = SayanVanishVelocityAPI.Companion.getInstance().getDatabase();
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        database.removeBasicUser(uUID);
    }
}

