/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.api.feature;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.sayandev.sayanvanish.api.BasicUser;
import org.sayandev.sayanvanish.api.Platform;
import org.sayandev.sayanvanish.api.feature.Features;
import org.sayandev.sayanvanish.api.feature.category.FeatureCategories;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;
import org.sayandev.sayanvanish.lib.spongepowered.configurate.CommentedConfigurationNode;
import org.sayandev.sayanvanish.lib.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.sayandev.sayanvanish.lib.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.sayandev.sayanvanish.lib.stickynote.core.configuration.Config;

@ConfigSerializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b'\u0018\u0000 %2\u00020\u0001:\u0001%B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001b\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010 \u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0005H\u0016J\u0006\u0010\"\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020\u001fJ\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0018\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u0012\u00a8\u0006&"}, d2={"Lorg/sayandev/sayanvanish/api/feature/Feature;", "Lorg/sayandev/sayanvanish/lib/stickynote/core/configuration/Config;", "id", "", "enabled", "", "category", "Lorg/sayandev/sayanvanish/api/feature/category/FeatureCategories;", "additionalSerializers", "Lorg/sayandev/sayanvanish/lib/spongepowered/configurate/serialize/TypeSerializerCollection;", "critical", "<init>", "(Ljava/lang/String;ZLorg/sayandev/sayanvanish/api/feature/category/FeatureCategories;Lorg/sayandev/sayanvanish/lib/spongepowered/configurate/serialize/TypeSerializerCollection;Z)V", "getId", "()Ljava/lang/String;", "getEnabled", "()Z", "setEnabled", "(Z)V", "getCategory", "()Lorg/sayandev/sayanvanish/api/feature/category/FeatureCategories;", "getAdditionalSerializers", "()Lorg/sayandev/sayanvanish/lib/spongepowered/configurate/serialize/TypeSerializerCollection;", "getCritical", "condition", "getCondition", "setCondition", "isActive", "user", "Lorg/sayandev/sayanvanish/api/BasicUser;", "enable", "", "disable", "reload", "toggle", "onCriticalDisabled", "loadAndRegister", "Companion", "sayanvanish-api"})
@SourceDebugExtension(value={"SMAP\nFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Feature.kt\norg/sayandev/sayanvanish/api/feature/Feature\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public abstract class Feature
extends Config {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private boolean enabled;
    @NotNull
    private final transient FeatureCategories category;
    @NotNull
    private final transient TypeSerializerCollection additionalSerializers;
    private final transient boolean critical;
    private transient boolean condition;

    public Feature(@NotNull String id, boolean enabled, @NotNull FeatureCategories category, @NotNull TypeSerializerCollection additionalSerializers, boolean critical) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)additionalSerializers, (String)"additionalSerializers");
        super(Companion.directory(category), id + ".yml", additionalSerializers);
        this.id = id;
        this.enabled = enabled;
        this.category = category;
        this.additionalSerializers = additionalSerializers;
        this.critical = critical;
        this.condition = true;
    }

    public /* synthetic */ Feature(String string, boolean bl, FeatureCategories featureCategories, TypeSerializerCollection typeSerializerCollection, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            featureCategories = FeatureCategories.DEFAULT;
        }
        if ((n & 8) != 0) {
            TypeSerializerCollection typeSerializerCollection2 = TypeSerializerCollection.defaults();
            Intrinsics.checkNotNullExpressionValue((Object)typeSerializerCollection2, (String)"defaults(...)");
            typeSerializerCollection = typeSerializerCollection2;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(string, bl, featureCategories, typeSerializerCollection, bl2);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @NotNull
    public final FeatureCategories getCategory() {
        return this.category;
    }

    @NotNull
    public final TypeSerializerCollection getAdditionalSerializers() {
        return this.additionalSerializers;
    }

    public final boolean getCritical() {
        return this.critical;
    }

    public boolean getCondition() {
        return this.condition;
    }

    public void setCondition(boolean bl) {
        this.condition = bl;
    }

    public boolean isActive() {
        return this.getEnabled() && this.getCondition();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive(@NotNull BasicUser user2) {
        boolean bl;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
            if (user2.hasPermission("sayanvanish.feature.disable." + this.id)) return false;
            Iterable iterable = Features.INSTANCE.userFeatures(user2);
            for (Object t : iterable) {
                Feature it = (Feature)((Object)t);
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.id, (Object)this.id)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        Feature feature = v0;
        if (feature != null) {
            if (!feature.getEnabled()) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        if (!this.isActive()) return false;
        return true;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public final void disable() {
        this.disable(false);
    }

    public void disable(boolean reload) {
        if (this.critical) {
            this.onCriticalDisabled(reload);
        }
        this.setEnabled(false);
    }

    public final void toggle() {
        if (this.getEnabled() && this.getCondition()) {
            this.disable();
        } else {
            this.enable();
        }
    }

    public final void onCriticalDisabled() {
        this.onCriticalDisabled(false);
    }

    public final void onCriticalDisabled(boolean reload) {
        if (!reload) {
            Platform.Companion.get().getLogger().warning("the feature '" + this.id + "' is critical and currently disabled. We strongly recommend re-enabling it to avoid potential unexpected behavior. (path: " + Companion.directory(this.category).getPath() + "/" + this.id + ".yml)");
        }
    }

    public final void loadAndRegister() {
        Companion.loadAndRegister(this);
    }

    @JvmStatic
    public static final void loadAndRegister(@NotNull Feature feature) {
        Companion.loadAndRegister(feature);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tH\u0007\u00a8\u0006\u0010"}, d2={"Lorg/sayandev/sayanvanish/api/feature/Feature$Companion;", "", "<init>", "()V", "directory", "Ljava/io/File;", "category", "Lorg/sayandev/sayanvanish/api/feature/category/FeatureCategories;", "createFromConfig", "Lorg/sayandev/sayanvanish/api/feature/Feature;", "type", "Ljava/lang/Class;", "createFromInstance", "feature", "loadAndRegister", "", "sayanvanish-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File directory(@NotNull FeatureCategories category) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            return category.getDirectory() == null ? new File(Platform.Companion.get().getRootDirectory(), "features") : new File(new File(Platform.Companion.get().getRootDirectory(), "features"), category.getDirectory());
        }

        @NotNull
        public final Feature createFromConfig(@NotNull Class<? extends Feature> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Feature freshInstance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Intrinsics.checkNotNull((Object)((Object)freshInstance));
            return this.createFromInstance(freshInstance);
        }

        @NotNull
        public final Feature createFromInstance(@NotNull Feature feature) {
            Feature feature2;
            Feature instance;
            Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
            FeatureCategories category = feature.getCategory();
            CommentedConfigurationNode commentedConfigurationNode = Config.Companion.getConfigFromFile(new File(category.getDirectory() == null ? new File(Platform.Companion.get().getRootDirectory(), "features") : new File(new File(Platform.Companion.get().getRootDirectory(), "features"), category.getDirectory()), feature.getId() + ".yml"), feature.getAdditionalSerializers());
            Feature feature3 = instance = commentedConfigurationNode != null && (feature2 = (Feature)((Object)commentedConfigurationNode.get(((Object)((Object)feature)).getClass()))) != null ? feature2 : feature;
            if (instance.getEnabled()) {
                instance.enable();
            } else {
                instance.disable();
            }
            return instance;
        }

        @JvmStatic
        public final void loadAndRegister(@NotNull Feature feature) {
            Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
            this.createFromInstance(feature);
            feature.save();
            Features.addFeature(feature);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

