/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.bukkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.sayandev.sayanvanish.api.BasicUser;
import org.sayandev.sayanvanish.api.SayanVanishAPI;
import org.sayandev.sayanvanish.api.User;
import org.sayandev.sayanvanish.api.database.Database;
import org.sayandev.sayanvanish.bukkit.api.BukkitUser;
import org.sayandev.sayanvanish.bukkit.api.SayanVanishBukkitAPI;
import org.sayandev.sayanvanish.bukkit.config.SettingsConfigKt;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;
import org.sayandev.sayanvanish.lib.stickynote.bukkit.StickyNoteKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0003J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u00a8\u0006\u000b"}, d2={"Lorg/sayandev/sayanvanish/bukkit/VanishManager;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "addBasicUserOnJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "removeBasicUserOnQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "hideVanishedPlayersOnJoin", "sayanvanish-bukkit"})
@SourceDebugExtension(value={"SMAP\nVanishManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VanishManager.kt\norg/sayandev/sayanvanish/bukkit/VanishManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n774#2:45\n865#2,2:46\n*S KotlinDebug\n*F\n+ 1 VanishManager.kt\norg/sayandev/sayanvanish/bukkit/VanishManager\n*L\n39#1:45\n39#1:46,2\n*E\n"})
public final class VanishManager
implements Listener {
    @NotNull
    public static final VanishManager INSTANCE = new VanishManager();

    private VanishManager() {
    }

    @EventHandler
    private final void addBasicUserOnJoin(PlayerJoinEvent event) {
        if (SettingsConfigKt.getSettings().getGeneral().getProxyMode()) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        Database<User> database = SayanVanishAPI.Companion.getInstance().getDatabase();
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        String string = player2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        database.addBasicUser(BasicUser.Companion.create(uUID, string, null));
    }

    @EventHandler
    private final void removeBasicUserOnQuit(PlayerQuitEvent event) {
        if (SettingsConfigKt.getSettings().getGeneral().getProxyMode()) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        SayanVanishAPI.Companion.getInstance().getDatabase().getCache().remove(player2.getUniqueId());
        Database<User> database = SayanVanishAPI.Companion.getInstance().getDatabase();
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        database.removeBasicUser(uUID);
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler(priority=EventPriority.LOWEST)
    private final void hideVanishedPlayersOnJoin(PlayerJoinEvent event) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = SayanVanishBukkitAPI.Companion.getInstance().getDatabase().getUsers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BukkitUser it = (BukkitUser)element$iv$iv;
            boolean bl = false;
            if (!(it.isVanished() && it.player() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (BukkitUser user2 : (List)destination$iv$iv) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            user2.hideUser(player);
        }
    }

    static {
        StickyNoteKt.registerListener((Listener)INSTANCE);
    }
}

