/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.lib.stickynote.loader.bukkit;

import com.alessiodp.libby.BukkitLibraryManager;
import com.alessiodp.libby.LibraryManager;
import com.alessiodp.libby.PaperLibraryManager;
import java.io.File;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.sayandev.sayanvanish.lib.loader.common.StickyNoteLoader;
import org.sayandev.sayanvanish.lib.stickynote.bukkit.WrappedStickyNotePlugin;

public class StickyNoteBukkitLoader
extends StickyNoteLoader {
    public JavaPlugin javaPlugin;

    public StickyNoteBukkitLoader(JavaPlugin javaPlugin) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        this(javaPlugin, false);
    }

    public StickyNoteBukkitLoader(JavaPlugin javaPlugin, boolean reloadStickyNote) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        super(javaPlugin.getName());
        this.javaPlugin = javaPlugin;
        File dataFolder = javaPlugin.getDataFolder();
        Logger logger = javaPlugin.getLogger();
        LibraryManager libraryManager = StickyNoteBukkitLoader.getLibraryManager(javaPlugin);
        this.load(javaPlugin.getName(), dataFolder.getParentFile(), logger, libraryManager, false);
    }

    @Override
    protected void onComplete() {
        new WrappedStickyNotePlugin(this.javaPlugin);
    }

    private static LibraryManager getLibraryManager(JavaPlugin plugin) {
        if (plugin.getResource("paper-plugin.yml") != null) {
            plugin.getLogger().info("paper-plugin detected, using paper library loader...");
            return new PaperLibraryManager((Plugin)plugin, new File(plugin.getDataFolder().getParentFile(), "stickynote").getAbsolutePath());
        }
        return new BukkitLibraryManager((Plugin)plugin, new File(plugin.getDataFolder().getParentFile(), "stickynote").getAbsolutePath());
    }
}

