/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.modsoptimizer.services;

import de.markusbordihn.modsoptimizer.Constants;
import de.markusbordihn.modsoptimizer.data.GameEnvironment;
import de.markusbordihn.modsoptimizer.service.ModsOptimizerService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;

public class ModLocatorService
implements IDependencyLocator {
    public ModLocatorService() {
        ModsOptimizerService modsOptimizer = new ModsOptimizerService(FMLPaths.GAMEDIR.get().toFile(), FMLPaths.MODSDIR.get().toFile(), FMLEnvironment.getDist() == Dist.DEDICATED_SERVER ? GameEnvironment.SERVER : GameEnvironment.CLIENT).init();
        modsOptimizer.enableClientSideMods();
        modsOptimizer.parseMods();
        modsOptimizer.optimizeDuplicatedMods();
        modsOptimizer.disableClientSideMods();
        Constants.LOG.info("\u23f1 Mod Optimizer needs {} ms in total.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - modsOptimizer.getTotalStartTime()));
    }

    public int getPriority() {
        return 1000;
    }

    public void scanMods(List<IModFile> list, IDiscoveryPipeline iDiscoveryPipeline) {
        Constants.LOG.debug("scanMods");
    }
}

