/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.modsoptimizer.services;

import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import de.markusbordihn.modsoptimizer.Constants;
import de.markusbordihn.modsoptimizer.data.GameEnvironment;
import de.markusbordihn.modsoptimizer.service.ModsOptimizerService;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;

public class ModLocatorService
implements IModLocator {
    public ModLocatorService() {
        Environment environment = Launcher.INSTANCE.environment();
        Optional launchTarget = environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.LAUNCHTARGET.get());
        ModsOptimizerService modsOptimizer = new ModsOptimizerService(FMLPaths.GAMEDIR.get().toFile(), FMLPaths.MODSDIR.get().toFile(), launchTarget.isPresent() && ((String)launchTarget.get()).contains("server") ? GameEnvironment.SERVER : GameEnvironment.CLIENT).init();
        modsOptimizer.enableClientSideMods();
        modsOptimizer.parseMods();
        modsOptimizer.optimizeDuplicatedMods();
        modsOptimizer.disableClientSideMods();
        Constants.LOG.info("\u23f1 Mod Optimizer needs {} ms in total.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - modsOptimizer.getTotalStartTime()));
    }

    public List<IModLocator.ModFileOrException> scanMods() {
        Constants.LOG.debug("scanMods");
        return Collections.emptyList();
    }

    public String name() {
        return "adaptive_performance_tweaks_mod_optimizer";
    }

    public void scanFile(IModFile modFile, Consumer<Path> pathConsumer) {
        Constants.LOG.debug("scanFile {} {}", (Object)modFile, pathConsumer);
    }

    public void initArguments(Map<String, ?> arguments) {
        Constants.LOG.debug("initArguments: {}", arguments);
    }

    public boolean isValid(IModFile modFile) {
        Constants.LOG.debug("isValid {}", (Object)modFile);
        return false;
    }
}

