package cc.thonly.polydex2eiv;

import cc.thonly.polydex2eiv.api.ItemViewRemoveModifier;
import cc.thonly.polydex2eiv.api.ItemViewServerModifier;
import cc.thonly.polydex2eiv.compat.Polydex2EIVCompatInit;
import cc.thonly.polydex2eiv.network.*;
import de.crafty.eiv.common.CommonEIVClient;
import de.crafty.eiv.common.recipe.ItemViewRecipes;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexPageUtils;
import eu.pb4.polydex.impl.PolydexImpl;
import eu.pb4.polymer.core.api.other.PolymerScreenHandlerUtils;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.rsm.api.RegistrySyncUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.*;

@Slf4j
@SuppressWarnings("unchecked")
public class Polydex2EIV implements ModInitializer {
    public static final String MOD_ID = "polydex2eiv";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
    public static boolean FORCE_MODE = true;
    public static List<class_1799> ITEM_STACKS = new ArrayList<>();
    public static List<class_1799> REMOVED_ITEM_STACKS = new ArrayList<>();
    public static List<class_1799> POLY_MC_STACKS = new ArrayList<>();
    private static MinecraftServer server;
    public static boolean JOINED_MODDED_SERVER = false;

    @Override
    public void onInitialize() {
        ItemViewRecipes instance = ItemViewRecipes.INSTANCE;
        try {
            Class<ItemViewRecipes> clazz = ItemViewRecipes.class;
            Field field = clazz.getDeclaredField("fluidItemMap");
            field.setAccessible(true);
            Object object = field.get(instance);
            HashMap<class_3611, class_1792> fluidItemMap = (HashMap<class_3611, class_1792>) object;
            for (Map.Entry<class_3611, class_1792> entry : fluidItemMap.entrySet()) {
                class_1792 item = entry.getValue();
                RegistrySyncUtils.setServerEntry(class_7923.field_41178, item);
            }
            class_3917<?> screenHandlerType = class_7923.field_41187.method_63535(class_2960.method_60654("eiv:recipe_view"));
            if (screenHandlerType != null) {
                RegistrySyncUtils.setServerEntry(class_7923.field_41187, screenHandlerType);
            }
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                PolymerScreenHandlerUtils.registerType(CommonEIVClient.RECIPE_VIEW_MENU);
            }
            PolymerResourcePackUtils.addModAssets("eiv");
        } catch (Exception e) {
            log.error("Can't make reflection for EIV");
        }

        ServerLifecycleEvents.SERVER_STARTING.register(Polydex2EIV::setServer);

        PayloadTypeRegistry.playS2C().register(StackActionPayload.PACKET_ID, StackActionPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(StackActionPayload.PACKET_ID, StackActionPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(StackActionPayload.PACKET_ID, (payload, context) -> {
            class_3222 player = context.player();
            Action action = payload.action();
            String stringId = payload.id();
            class_2960 id = class_2960.method_60654(stringId);
            class_1792 item = class_7923.field_41178.method_63535(id);
            if (item == class_1802.field_8162) {
                return;
            }
            class_1799 itemStack = item.method_7854();
            PolydexEntry entry = PolydexImpl.getEntry(itemStack);
            if (entry == null) {
                entry = PolydexImpl.ITEM_ENTRIES.nonEmptyById().get(id);
            }
            if (entry != null) {
                if (action == Action.INPUT) {
                    PolydexPageUtils.openUsagesListUi(player, entry, null);
                } else if (action == Action.RESULT) {
                    PolydexPageUtils.openRecipeListUi(player, entry, null);
                }
            }
        });

        PayloadTypeRegistry.playS2C().register(ItemStackRemoverSetPayload.PACKET_ID, ItemStackRemoverSetPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ItemStackRemoverSetPayload.PACKET_ID, ItemStackRemoverSetPayload.CODEC);

        PayloadTypeRegistry.playS2C().register(PolyMcItemStackSetPayload.PACKET_ID, PolyMcItemStackSetPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(PolyMcItemStackSetPayload.PACKET_ID, PolyMcItemStackSetPayload.CODEC);

        PayloadTypeRegistry.playC2S().register(ItemStackModifierSetPayload.PACKET_ID, ItemStackModifierSetPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ItemStackModifierSetPayload.PACKET_ID, ItemStackModifierSetPayload.CODEC);

        PayloadTypeRegistry.playC2S().register(JoinPayload.PACKET_ID, JoinPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(JoinPayload.PACKET_ID, JoinPayload.CODEC);

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();

            if (ServerPlayNetworking.canSend(player, JoinPayload.PACKET_ID)) {
                ServerPlayNetworking.send(player, new JoinPayload());
            }
        });

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();

            if (ServerPlayNetworking.canSend(player, ItemStackModifierSetPayload.PACKET_ID)) {
                var stacks = ItemViewServerModifier.MODIFIER.invoker().get();
                ItemStackModifierSetPayload payload = new ItemStackModifierSetPayload(stacks);
                ServerPlayNetworking.send(player, payload);
            }
        });

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();

            if (ServerPlayNetworking.canSend(player, ItemStackRemoverSetPayload.PACKET_ID)) {
                List<class_1799> stacks = ItemViewRemoveModifier.ITEM_STACK_REMOVER.invoker().get();
                ItemStackRemoverSetPayload payload = new ItemStackRemoverSetPayload(stacks);
                ServerPlayNetworking.send(player, payload);
            }
        });
        PolydexRecipeViewImpl.bootstrap();
        Polydex2EIVCompatInit.bootstrap();

    }

    public static class_2960 id(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }

    public static void setServer(MinecraftServer server) {
        Polydex2EIV.server = server;
    }

    @Nullable
    public static MinecraftServer getServer() {
        return server;
    }
}