package cc.thonly.polydex2eiv;

import cc.thonly.polydex2eiv.network.*;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1799;
import java.util.ArrayList;
import java.util.List;


public class Polydex2EIVClient implements ClientModInitializer {


    @Override
    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver(StackActionPayload.PACKET_ID, (payload, context) -> {

        });

        ClientPlayNetworking.registerGlobalReceiver(ItemStackModifierSetPayload.PACKET_ID, (payload, context) -> {
            Polydex2EIV.ITEM_STACKS = new ArrayList<>();
            List<class_1799> stacks = payload.getItemStacks();
            if (stacks != null) {
                Polydex2EIV.ITEM_STACKS.addAll(stacks);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(ItemStackRemoverSetPayload.PACKET_ID, (payload, context) -> {
            Polydex2EIV.REMOVED_ITEM_STACKS = new ArrayList<>();
            List<class_1799> stacks = payload.getItemStacks();
            if (stacks != null) {
                Polydex2EIV.REMOVED_ITEM_STACKS.addAll(stacks);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(PolyMcItemStackSetPayload.PACKET_ID, (payload, context) -> {
            Polydex2EIV.POLY_MC_STACKS = new ArrayList<>();
            List<class_1799> stacks = payload.getItemStacks();
            if (stacks != null) {
                Polydex2EIV.POLY_MC_STACKS.addAll(stacks);
            }
        });

    }
}
