package cc.thonly.polydex2eiv.compat;

import cc.thonly.polydex2eiv.network.PolyMcItemStackSetPayload;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import io.github.theepicblock.polymc.PolyMc;
import io.github.theepicblock.polymc.api.PolyMap;
import io.github.theepicblock.polymc.api.item.ItemLocation;
import io.github.theepicblock.polymc.api.item.ItemPoly;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;

@Slf4j
@SuppressWarnings("deprecation")
public class PolyMcCompatInit {
    public static void bootstrap() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            if (FabricLoader.getInstance().isModLoaded("polymc-extra")) {
                return;
            }

            if (ServerPlayNetworking.canSend(player, PolyMcItemStackSetPayload.PACKET_ID)) {
                try {
                    CompletableFuture.supplyAsync(()-> {
                        PolyMap polyMap = PolyMc.getMainMap();
                        Stream<class_1792> stream = class_7923.field_41178.method_10220();
                        List<class_1799> results = new ArrayList<>();
                        List<class_1792> polyMcItems = stream
                                .filter(item -> !(item instanceof PolymerItem))
                                .toList();
                        for (class_1792 polyMcItem : polyMcItems) {
                            class_2960 strId = class_7923.field_41178.method_10221(polyMcItem);
                            ItemPoly itemPoly = polyMap.getItemPoly(polyMcItem);
                            if (itemPoly == null) continue;
                            class_1799 clientItem = itemPoly.getClientItem(polyMcItem.method_7854(), player, ItemLocation.INVENTORY);
                            if (clientItem == null) continue;
                            class_9279 nbtComponent = clientItem.method_58695(class_9334.field_49628, class_9279.method_57456(new class_2487()));
                            class_9279 apply = nbtComponent.method_57451(nbtCompound -> {
                                class_2487 polyMcCompound = new class_2487();
                                polyMcCompound.method_10582("id", strId.toString());
                                nbtCompound.method_10566("PolyMcOriginal", polyMcCompound);
                            });
                            clientItem.method_57379(class_9334.field_49628, apply);
                            results.add(clientItem);
                        }
                        return results;
                    }).thenAccept(results -> {
                        server.execute(() -> {
                            ServerPlayNetworking.send(player, new PolyMcItemStackSetPayload(results));
                        });
                    });
                } catch (Exception e) {
                    log.error("Can't send polymc packet to client");
                }

            }
        });
    }
}
