package cc.thonly.polydex2eiv.compat;

import lombok.extern.slf4j.Slf4j;
import net.fabricmc.loader.api.FabricLoader;

@Slf4j
public class Polydex2EIVCompatInit {
    public static void bootstrap() {
        load("polymc", PolyMcCompatInit::bootstrap);
    }

    public static void load(String modId, CompatApplication application) {
        try {
            if (FabricLoader.getInstance().isModLoaded(modId)) {
                application.apply();
                log.info("Loaded Compat for {}", modId);
            }
        } catch (Exception e) {
            log.warn("Can't load compat plugin", e);
        }
    }

    @FunctionalInterface
    public interface CompatApplication {
        void apply();
    }
}
