package cc.thonly.polydex2eiv.mixin;

import de.crafty.eiv.common.network.payload.mode.ServerboundPickCheatmodeItemPayload;
import io.netty.channel.ChannelFutureListener;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2535.class)
public class ClientConnectionMixin {
    @Inject(method = "send(Lnet/minecraft/network/packet/Packet;Lio/netty/channel/ChannelFutureListener;Z)V", at = @At("HEAD"), cancellable = true)
    public void cancelSend(class_2596<?> packet, @Nullable ChannelFutureListener channelFutureListener, boolean flush, CallbackInfo ci) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return;
        }
        if (packet instanceof class_2658 payloadS2CPacket) {
            if (payloadS2CPacket.comp_1646() instanceof ServerboundPickCheatmodeItemPayload) {
                return;
            }
            if (payloadS2CPacket.comp_1646().method_56479().comp_2242().toString().startsWith("eiv:")) {
                ci.cancel();
            }
        }
    }

    @Inject(method = "sendInternal", at = @At("HEAD"), cancellable = true)
    public void cancelSendInternal(class_2596<?> packet, @Nullable ChannelFutureListener channelFutureListener, boolean flush, CallbackInfo ci) {
        if (packet instanceof class_2658 payloadS2CPacket) {
            if (payloadS2CPacket.comp_1646() instanceof ServerboundPickCheatmodeItemPayload) {
                return;
            }
            if (payloadS2CPacket.comp_1646().method_56479().comp_2242().toString().startsWith("eiv:")) {
                ci.cancel();
            }
        }
    }
}
