package cc.thonly.polydex2eiv.mixin;

import cc.thonly.polydex2eiv.Polydex2EIV;
import cc.thonly.polydex2eiv.api.ItemViewModifier;
import cc.thonly.polydex2eiv.api.ItemViewRemoveModifier;
import cc.thonly.polydex2eiv.util.ClientPolymerItemUtils;
import de.crafty.eiv.common.overlay.itemlist.view.ItemFilters;
import eu.pb4.polymer.core.api.client.ClientPolymerItem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@Mixin(ItemFilters.class)
public class ItemFiltersMixin {
    @Inject(method = "fullStackList", at = @At("RETURN"), cancellable = true, remap = false)
    private static void modifyItemStacks(CallbackInfoReturnable<List<class_1799>> cir) {
        List<class_1799> list = cir.getReturnValue();
        Iterator<ClientPolymerItem> iterator = ClientPolymerItem.REGISTRY.stream().iterator();
        Map<class_1799, ClientPolymerItem> registry = new Object2ObjectOpenHashMap<>();
        while (iterator.hasNext()) {
            ClientPolymerItem next = iterator.next();
            class_1799 itemStack = next.visualStack();
            if (!ClientPolymerItemUtils.isPolyItem(itemStack)) {
                continue;
            }
            Optional<String> polymerStackId = ClientPolymerItemUtils.getPolymerStackId(itemStack);
            if (polymerStackId.isEmpty()) {
                continue;
            }
            if (class_7923.field_41178.method_63535(class_2960.method_60654(polymerStackId.get())) != class_1802.field_8162) {
                continue;
            }
            registry.put(itemStack, next);
            list.add(itemStack);
        }
        List<class_1799> modifierStacks = ItemViewModifier.MODIFIER.invoker().get();
        list.addAll(modifierStacks);
        list.addAll(Polydex2EIV.ITEM_STACKS);
        list.addAll(Polydex2EIV.POLY_MC_STACKS);

        List<class_1799> removeItemStacks = ItemViewRemoveModifier.ITEM_STACK_REMOVER.invoker().get();
        removeItemStacks.addAll(Polydex2EIV.REMOVED_ITEM_STACKS);
        Iterator<class_1799> itemStackIterator = removeItemStacks.iterator();
        while (itemStackIterator.hasNext()) {
            class_1799 next = itemStackIterator.next();
            for (class_1799 stack : list) {
                boolean b = class_1799.method_31577(next, stack);
                if (b) itemStackIterator.remove();
            }
        }

        cir.setReturnValue(list);
    }
}
