package cc.thonly.polydex2eiv.network;

import de.crafty.eiv.common.overlay.itemlist.view.ItemViewOverlay;
import lombok.Getter;

import java.util.EnumMap;
import java.util.Map;

@Getter
public enum Action {
    INPUT(0),
    RESULT(1);
    public static final EnumMap<ItemViewOverlay.ItemViewOpenType, Action> ENUM_MAP = new EnumMap<>(
            Map.of(
                    ItemViewOverlay.ItemViewOpenType.INPUT, Action.INPUT,
                    ItemViewOverlay.ItemViewOpenType.RESULT, Action.RESULT
            )
    );
    private final int id;

    Action(int id) {
        this.id = id;
    }

    public static synchronized Action get(int id) {
        Action[] values = values();
        for (Action action : values) {
            if (action.getId() == id) {
                return action;
            }
        }
        return Action.INPUT;
    }
}
