package cc.thonly.polydex2eiv.network;

import cc.thonly.polydex2eiv.Polydex2EIV;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

@Slf4j
public record StackActionPayload(Action action, String id) implements class_8710 {
    public static final class_2960 ID = Polydex2EIV.id("stack_action");
    public static final class_9154<StackActionPayload> PACKET_ID = new class_9154<>(ID);

    public static final class_9139<class_9129, StackActionPayload> CODEC = class_9139.method_56438(
            StackActionPayload::write,
            StackActionPayload::read
    );

    private static StackActionPayload read(class_9129 buf) {
        try {
            return new StackActionPayload(Action.get(buf.readInt()), buf.method_19772());
        } catch (Exception e) {
            log.error("Can't read Stack Action Payload: ", e);
            return new StackActionPayload(Action.INPUT, "minecraft:stone");
        }
    }

    private void write(class_9129 buf) {
        buf.method_53002(this.action.getId());
        buf.method_10814(this.id);
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }
}
