/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.polydex2eiv.mixin;

import cc.thonly.polydex2eiv.Polydex2EIV;
import cc.thonly.polydex2eiv.network.Action;
import cc.thonly.polydex2eiv.network.StackActionPayload;
import cc.thonly.polydex2eiv.util.ClientPolymerItemUtils;
import de.crafty.eiv.common.overlay.itemlist.view.ItemViewOverlay;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import java.util.Optional;
import lombok.Generated;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={ItemViewOverlay.class})
public class ItemViewOverlayMixin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ItemViewOverlayMixin.class);

    @ModifyVariable(method={"openRecipeView"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    public class_1799 modifyStack(class_1799 stack) {
        MinecraftServer server = Polydex2EIV.getServer();
        if (server != null) {
            class_5455.class_6890 registryManager = server.method_30611();
            return PolymerItemUtils.getRealItemStack((class_1799)stack, (class_7225.class_7874)registryManager);
        }
        return stack;
    }

    @Inject(method={"openRecipeView"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;getInstance()Lnet/minecraft/client/MinecraftClient;")}, cancellable=true)
    private static void invokeItemStack(class_1799 stack, ItemViewOverlay.ItemViewOpenType openType, CallbackInfo ci) {
        if (ClientPolymerItemUtils.isPolyItem(stack) || Polydex2EIV.FORCE_MODE) {
            Optional<String> polymerStackIdOptional = ClientPolymerItemUtils.getPolymerStackId(stack);
            if (polymerStackIdOptional.isPresent()) {
                String itemId = polymerStackIdOptional.get();
                ItemViewOverlayMixin.tryOpen(openType, itemId);
                ci.cancel();
            }
            if (Polydex2EIV.FORCE_MODE) {
                ItemViewOverlayMixin.tryOpen(openType, stack);
                ci.cancel();
            }
        }
    }

    @Inject(method={"openRecipeView"}, at={@At(value="INVOKE", target="Lde/crafty/eiv/common/overlay/itemlist/view/ItemViewOverlay$ItemViewOpenType$RecipeProvider;retrieveRecipes(Lnet/minecraft/item/ItemStack;)Ljava/util/List;")}, cancellable=true)
    public void beforeFound(class_1799 stack, ItemViewOverlay.ItemViewOpenType openType, CallbackInfo ci) {
        if (PolymerItemUtils.isPolymerServerItem((class_1799)stack)) {
            ItemViewOverlayMixin.tryOpen(openType, stack);
            ci.cancel();
        }
    }

    @Inject(method={"openRecipeView"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;setScreen(Lnet/minecraft/client/gui/screen/Screen;)V")}, cancellable=true)
    public void beforeSetScreen(class_1799 stack, ItemViewOverlay.ItemViewOpenType openType, CallbackInfo ci) {
        if (PolymerItemUtils.isPolymerServerItem((class_1799)stack)) {
            ItemViewOverlayMixin.tryOpen(openType, stack);
            ci.cancel();
        }
    }

    @Unique
    private static void tryOpen(ItemViewOverlay.ItemViewOpenType type, String stringId) {
        Action action = Action.ENUM_MAP.getOrDefault(type, Action.INPUT);
        class_310 client = class_310.method_1551();
        if (client.method_1562() == null) {
            log.warn("Cannot send payload: client not connected.");
            return;
        }
        StackActionPayload payload = new StackActionPayload(action, stringId);
        ClientPlayNetworking.send((class_8710)payload);
    }

    @Unique
    private static void tryOpen(ItemViewOverlay.ItemViewOpenType type, class_1799 stack) {
        String stringId = ClientPolymerItemUtils.getRealItemId(stack);
        ItemViewOverlayMixin.tryOpen(type, stringId);
    }
}

