/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag;

import com.hashnightflux.vag.Config;
import com.hashnightflux.vag.client.ClientHandler;
import com.hashnightflux.vag.client.CustomGunManager;
import com.hashnightflux.vag.client.KeyBinds;
import com.hashnightflux.vag.client.MetaLoader;
import com.hashnightflux.vag.client.handler.CrosshairHandler;
import com.hashnightflux.vag.common.BoundingBoxManager;
import com.hashnightflux.vag.common.NetworkGunManager;
import com.hashnightflux.vag.common.ProjectileManager;
import com.hashnightflux.vag.datagen.BlockTagGen;
import com.hashnightflux.vag.datagen.GunGen;
import com.hashnightflux.vag.datagen.ItemTagGen;
import com.hashnightflux.vag.datagen.LootTableGen;
import com.hashnightflux.vag.entity.GrenadeEntity;
import com.hashnightflux.vag.entity.ProjectileEntity;
import com.hashnightflux.vag.init.ModEffects;
import com.hashnightflux.vag.init.ModEnchantments;
import com.hashnightflux.vag.init.ModEntities;
import com.hashnightflux.vag.init.ModItems;
import com.hashnightflux.vag.init.ModParticleTypes;
import com.hashnightflux.vag.init.ModRecipeSerializers;
import com.hashnightflux.vag.init.ModRecipeTypes;
import com.hashnightflux.vag.init.ModSounds;
import com.hashnightflux.vag.init.ModSyncedDataKeys;
import com.hashnightflux.vag.init.ModTileEntities;
import com.hashnightflux.vag.network.PacketHandler;
import com.mrcrayfish.framework.api.FrameworkAPI;
import com.mrcrayfish.framework.api.client.FrameworkClientAPI;
import com.mrcrayfish.framework.client.resources.IDataLoader;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="vag")
public class VanillaAnimatedGuns {
    public static boolean debugging = false;
    public static boolean controllableLoaded = false;
    public static boolean backpackedLoaded = false;
    public static boolean playerReviveLoaded = false;
    public static final Logger LOGGER = LogManager.getLogger((String)"vag");

    public VanillaAnimatedGuns() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModEffects.REGISTER.register(bus);
        ModEnchantments.REGISTER.register(bus);
        ModEntities.REGISTER.register(bus);
        ModItems.REGISTER.register(bus);
        ModParticleTypes.REGISTER.register(bus);
        ModRecipeSerializers.REGISTER.register(bus);
        ModRecipeTypes.REGISTER.register(bus);
        ModSounds.REGISTER.register(bus);
        ModTileEntities.REGISTER.register(bus);
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onClientSetup);
        bus.addListener(this::onGatherData);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FrameworkClientAPI.registerDataLoader((IDataLoader)MetaLoader.getInstance());
            bus.addListener(KeyBinds::registerKeyMappings);
            bus.addListener(CrosshairHandler::onConfigReload);
            bus.addListener(ClientHandler::onRegisterReloadListener);
            bus.addListener(ClientHandler::onRegisterCreativeTab);
            bus.addListener(ClientHandler::registerAdditional);
        });
        controllableLoaded = ModList.get().isLoaded("controllable");
        backpackedLoaded = ModList.get().isLoaded("backpacked");
        playerReviveLoaded = ModList.get().isLoaded("playerrevive");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            PacketHandler.init();
            FrameworkAPI.registerSyncedDataKey(ModSyncedDataKeys.AIMING);
            FrameworkAPI.registerSyncedDataKey(ModSyncedDataKeys.RELOADING);
            FrameworkAPI.registerSyncedDataKey(ModSyncedDataKeys.SHOOTING);
            FrameworkAPI.registerLoginData((ResourceLocation)new ResourceLocation("vag", "network_gun_manager"), NetworkGunManager.LoginData::new);
            FrameworkAPI.registerLoginData((ResourceLocation)new ResourceLocation("vag", "custom_gun_manager"), CustomGunManager.LoginData::new);
            ProjectileManager.getInstance().registerFactory((Item)ModItems.DYNAMITE.get(), (worldIn, entity, weapon, item, modifiedGun) -> new GrenadeEntity((EntityType<? extends ProjectileEntity>)((EntityType)ModEntities.DYNAMITE.get()), worldIn, entity, weapon, item, modifiedGun));
            if (((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue()) {
                MinecraftForge.EVENT_BUS.register((Object)new BoundingBoxManager());
            }
        });
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientHandler::setup);
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        BlockTagGen blockTagGen = new BlockTagGen(output, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableGen(output));
        generator.addProvider(event.includeServer(), (DataProvider)blockTagGen);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGen(output, lookupProvider, blockTagGen.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new GunGen(output, lookupProvider));
    }

    public static boolean isDebugging() {
        return false;
    }
}

