/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag.client;

import com.hashnightflux.vag.VanillaAnimatedGuns;
import com.hashnightflux.vag.client.CustomGunManager;
import com.hashnightflux.vag.client.GunButtonBindings;
import com.hashnightflux.vag.client.SpecialModels;
import com.hashnightflux.vag.client.handler.AimingHandler;
import com.hashnightflux.vag.client.handler.BulletTrailRenderingHandler;
import com.hashnightflux.vag.client.handler.ControllerHandler;
import com.hashnightflux.vag.client.handler.CrosshairHandler;
import com.hashnightflux.vag.client.handler.GunRenderingHandler;
import com.hashnightflux.vag.client.handler.PlayerModelHandler;
import com.hashnightflux.vag.client.handler.RecoilHandler;
import com.hashnightflux.vag.client.handler.ReloadHandler;
import com.hashnightflux.vag.client.handler.ShootingHandler;
import com.hashnightflux.vag.client.render.gun.ModelOverrides;
import com.hashnightflux.vag.client.render.gun.model.SimpleModel;
import com.hashnightflux.vag.client.util.PropertyHelper;
import com.hashnightflux.vag.debug.IEditorMenu;
import com.hashnightflux.vag.debug.client.screen.EditorScreen;
import com.hashnightflux.vag.enchantment.EnchantmentTypes;
import com.hashnightflux.vag.init.ModItems;
import com.hashnightflux.vag.item.GunItem;
import com.hashnightflux.vag.network.PacketHandler;
import com.hashnightflux.vag.network.message.C2SMessageAttachments;
import com.mrcrayfish.framework.network.message.IMessage;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.screens.MouseSettingsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="vag", value={Dist.CLIENT})
public class ClientHandler {
    private static Field mouseOptionsField;

    public static void setup() {
        MinecraftForge.EVENT_BUS.register((Object)AimingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)BulletTrailRenderingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)CrosshairHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)GunRenderingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)RecoilHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)ReloadHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)ShootingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerModelHandler());
        if (VanillaAnimatedGuns.controllableLoaded) {
            MinecraftForge.EVENT_BUS.register((Object)new ControllerHandler());
            GunButtonBindings.register();
        }
        ClientHandler.setupRenderLayers();
        ClientHandler.registerModelOverrides();
        ClientHandler.registerScreenFactories();
    }

    private static void setupRenderLayers() {
    }

    private static void registerModelOverrides() {
        ModelOverrides.register((Item)ModItems.BOLTCASTER.get(), new SimpleModel(SpecialModels.BOLTCASTER::getModel));
        ModelOverrides.register((Item)ModItems.DYNAMITE_LAUNCHER.get(), new SimpleModel(SpecialModels.DYNAMITE_LAUNCHER::getModel));
        ModelOverrides.register((Item)ModItems.MUSKET.get(), new SimpleModel(SpecialModels.MUSKET::getModel));
        ModelOverrides.register((Item)ModItems.MINIMACH.get(), new SimpleModel(SpecialModels.MINIMACH::getModel));
        ModelOverrides.register((Item)ModItems.HANDCANNON.get(), new SimpleModel(SpecialModels.HANDCANNON::getModel));
        ModelOverrides.register((Item)ModItems.SIDEHAMMER.get(), new SimpleModel(SpecialModels.SIDEHAMMER::getModel));
        ModelOverrides.register((Item)ModItems.BOOMSTICK.get(), new SimpleModel(SpecialModels.BOOMSTICK::getModel));
    }

    private static void registerScreenFactories() {
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof MouseSettingsScreen) {
            MouseSettingsScreen screen2 = (MouseSettingsScreen)screen;
            if (mouseOptionsField == null) {
                mouseOptionsField = ObfuscationReflectionHelper.findField(MouseSettingsScreen.class, (String)"f_96218_");
                mouseOptionsField.setAccessible(true);
            }
            try {
                screen = (OptionsList)mouseOptionsField.get(screen2);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91080_ == null && event.getAction() == 1) {
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAttachments());
        }
    }

    public static void onRegisterReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> PropertyHelper.resetCache()));
    }

    public static void registerAdditional(ModelEvent.RegisterAdditional event) {
        event.register(new ResourceLocation("vag", "special/test"));
    }

    public static void onRegisterCreativeTab(CreativeModeTabEvent.Register event) {
        event.registerCreativeModeTab(new ResourceLocation("vag", "creative_tab"), builder -> {
            builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.vag"));
            builder.m_257737_(() -> {
                ItemStack stack = new ItemStack((ItemLike)ModItems.HANDCANNON.get());
                stack.m_41784_().m_128379_("IgnoreAmmo", true);
                return stack;
            });
            builder.m_257501_((flags, output) -> {
                ModItems.REGISTER.getEntries().forEach(registryObject -> {
                    String path;
                    Object patt6971$temp = registryObject.get();
                    if (patt6971$temp instanceof GunItem) {
                        GunItem item = (GunItem)patt6971$temp;
                        ItemStack stack = new ItemStack((ItemLike)item);
                        CompoundTag tag = stack.m_41784_();
                        tag.m_128405_("AmmoCount", item.getGun().getGeneral().getMaxAmmo());
                        CompoundTag attachments = new CompoundTag();
                        String id = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
                        tag.m_128365_("Attachments", (Tag)attachments);
                        output.m_246342_(stack);
                        return;
                    }
                    ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)((Item)registryObject.get()));
                    if (id != null && ((path = id.m_135815_()).contains("barrel") || path.contains("scope") || path.contains("stock"))) {
                        return;
                    }
                    output.m_246326_((ItemLike)registryObject.get());
                });
                CustomGunManager.fill(output);
                for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
                    if (enchantment.f_44672_ != EnchantmentTypes.GUN && enchantment.f_44672_ != EnchantmentTypes.SEMI_AUTO_GUN) continue;
                    output.m_246267_(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, enchantment.m_6586_())), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
                }
            });
        });
    }

    public static Screen createEditorScreen(IEditorMenu menu) {
        return new EditorScreen(Minecraft.m_91087_().f_91080_, menu);
    }
}

