/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag.client;

import com.google.common.collect.ImmutableMap;
import com.hashnightflux.vag.common.CustomGun;
import com.hashnightflux.vag.common.CustomGunLoader;
import com.hashnightflux.vag.init.ModItems;
import com.hashnightflux.vag.network.message.S2CMessageUpdateGuns;
import com.mrcrayfish.framework.api.data.login.ILoginData;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(modid="vag", value={Dist.CLIENT})
public class CustomGunManager {
    private static Map<ResourceLocation, CustomGun> customGunMap;

    public static boolean updateCustomGuns(S2CMessageUpdateGuns message) {
        return CustomGunManager.updateCustomGuns(message.getCustomGuns());
    }

    private static boolean updateCustomGuns(Map<ResourceLocation, CustomGun> customGunMap) {
        CustomGunManager.customGunMap = customGunMap;
        return true;
    }

    public static void fill(CreativeModeTab.Output output) {
        if (customGunMap != null) {
            customGunMap.forEach((id, gun) -> {
                ItemStack stack = new ItemStack((ItemLike)ModItems.HANDCANNON.get());
                stack.m_41714_((Component)Component.m_237115_((String)("item." + id.m_135827_() + "." + id.m_135815_() + ".name")));
                CompoundTag tag = stack.m_41784_();
                tag.m_128365_("Model", (Tag)gun.getModel().m_41739_(new CompoundTag()));
                tag.m_128365_("Gun", (Tag)gun.getGun().serializeNBT());
                tag.m_128379_("Custom", true);
                tag.m_128405_("AmmoCount", gun.getGun().getGeneral().getMaxAmmo());
                output.m_246342_(stack);
            });
        }
    }

    @SubscribeEvent
    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        customGunMap = null;
    }

    public static class LoginData
    implements ILoginData {
        public void writeData(FriendlyByteBuf buffer) {
            Validate.notNull((Object)((Object)CustomGunLoader.get()));
            CustomGunLoader.get().writeCustomGuns(buffer);
        }

        public Optional<String> readData(FriendlyByteBuf buffer) {
            ImmutableMap<ResourceLocation, CustomGun> customGuns = CustomGunLoader.readCustomGuns(buffer);
            CustomGunManager.updateCustomGuns(customGuns);
            return Optional.empty();
        }
    }
}

