/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag.client.handler;

import com.hashnightflux.vag.client.BulletTrail;
import com.hashnightflux.vag.client.GunRenderType;
import com.hashnightflux.vag.client.util.RenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;

public class BulletTrailRenderingHandler {
    private static BulletTrailRenderingHandler instance;
    private Map<Integer, BulletTrail> bullets = new HashMap<Integer, BulletTrail>();

    public static BulletTrailRenderingHandler get() {
        if (instance == null) {
            instance = new BulletTrailRenderingHandler();
        }
        return instance;
    }

    private BulletTrailRenderingHandler() {
    }

    public void add(BulletTrail trail) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            this.bullets.put(trail.getEntityId(), trail);
        }
    }

    public void remove(int entityId) {
        this.bullets.remove(entityId);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            if (event.phase == TickEvent.Phase.END) {
                this.bullets.values().forEach(BulletTrail::tick);
                this.bullets.values().removeIf(BulletTrail::isDead);
            }
        } else if (!this.bullets.isEmpty()) {
            this.bullets.clear();
        }
    }

    public void render(PoseStack stack, float partialSticks) {
        for (BulletTrail bulletTrail : this.bullets.values()) {
            this.renderBulletTrail(bulletTrail, stack, partialSticks);
        }
    }

    @SubscribeEvent
    public void onRespawn(ClientPlayerNetworkEvent.Clone event) {
        this.bullets.clear();
    }

    @SubscribeEvent
    public void onLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        this.bullets.clear();
    }

    private void renderBulletTrail(BulletTrail trail, PoseStack poseStack, float deltaTicks) {
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = mc.m_91288_();
        if (entity == null || trail.isDead()) {
            return;
        }
        poseStack.m_85836_();
        Vec3 view = mc.f_91063_.m_109153_().m_90583_();
        Vec3 position = trail.getPosition();
        Vec3 motion = trail.getMotion();
        double bulletX = position.f_82479_ + motion.f_82479_ * (double)deltaTicks;
        double bulletY = position.f_82480_ + motion.f_82480_ * (double)deltaTicks;
        double bulletZ = position.f_82481_ + motion.f_82481_ * (double)deltaTicks;
        poseStack.m_85837_(bulletX - view.m_7096_(), bulletY - view.m_7098_(), bulletZ - view.m_7094_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(trail.getYaw()));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-trail.getPitch() + 90.0f));
        Vec3 motionVec = new Vec3(motion.f_82479_, motion.f_82480_, motion.f_82481_);
        float trailLength = (float)(motionVec.m_82553_() * trail.getTrailLengthMultiplier());
        float red = (float)(trail.getTrailColor() >> 16 & 0xFF) / 255.0f;
        float green = (float)(trail.getTrailColor() >> 8 & 0xFF) / 255.0f;
        float blue = (float)(trail.getTrailColor() & 0xFF) / 255.0f;
        float alpha = 0.3f;
        Entity shooter = trail.getShooter();
        if (shooter != null) {
            trailLength = (float)Math.min((double)trailLength, shooter.m_20299_(deltaTicks).m_82554_(new Vec3(bulletX, bulletY, bulletZ)));
        }
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        MultiBufferSource.BufferSource renderTypeBuffer = mc.m_91269_().m_110104_();
        if (trail.isTrailVisible()) {
            RenderType bulletType = GunRenderType.getBulletTrail();
            VertexConsumer builder = renderTypeBuffer.m_6299_(bulletType);
            builder.m_252986_(matrix4f, 0.0f, 0.0f, -0.035f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(matrix4f, 0.0f, 0.0f, 0.035f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(matrix4f, 0.0f, -trailLength, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(matrix4f, 0.0f, -trailLength, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(matrix4f, -0.035f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(matrix4f, 0.035f, 0.0f, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(matrix4f, 0.0f, -trailLength, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(matrix4f, 0.0f, -trailLength, 0.0f).m_85950_(red, green, blue, alpha).m_85969_(0xF000F0).m_5752_();
            Minecraft.m_91087_().m_91269_().m_110104_().m_109912_(bulletType);
        }
        if (!trail.getItem().m_41619_()) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)trail.getAge() + deltaTicks) * 50.0f));
            poseStack.m_85841_(0.275f, 0.275f, 0.275f);
            int combinedLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.f_19853_, (BlockPos)BlockPos.m_274446_((Position)entity.m_20182_()));
            ItemStack stack = trail.getItem();
            RenderUtil.renderModel(stack, ItemDisplayContext.NONE, poseStack, (MultiBufferSource)renderTypeBuffer, combinedLight, OverlayTexture.f_118083_, null, null);
        }
        poseStack.m_85849_();
    }
}

