/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag.client.handler;

import com.hashnightflux.vag.Config;
import com.hashnightflux.vag.VanillaAnimatedGuns;
import com.hashnightflux.vag.client.KeyBinds;
import com.hashnightflux.vag.client.handler.AimingHandler;
import com.hashnightflux.vag.client.handler.ControllerHandler;
import com.hashnightflux.vag.common.GripType;
import com.hashnightflux.vag.common.Gun;
import com.hashnightflux.vag.compat.PlayerReviveHelper;
import com.hashnightflux.vag.event.GunFireEvent;
import com.hashnightflux.vag.item.GunItem;
import com.hashnightflux.vag.network.PacketHandler;
import com.hashnightflux.vag.network.message.C2SMessageShoot;
import com.hashnightflux.vag.network.message.C2SMessageShooting;
import com.hashnightflux.vag.util.GunEnchantmentHelper;
import com.hashnightflux.vag.util.GunModifierHelper;
import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ShootingHandler {
    private static ShootingHandler instance;
    private boolean shooting;

    public static ShootingHandler get() {
        if (instance == null) {
            instance = new ShootingHandler();
        }
        return instance;
    }

    private ShootingHandler() {
    }

    private boolean isInGame() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91265_() != null) {
            return false;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (!mc.f_91067_.m_91600_()) {
            return false;
        }
        return mc.m_91302_();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMouseClick(InputEvent.InteractionKeyMappingTriggered event) {
        ItemStack heldItem;
        Item gun2;
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (PlayerReviveHelper.isBleeding((Player)player)) {
            return;
        }
        if ((Boolean)Config.CLIENT.controls.flipControls.get() != false ? event.isUseItem() : event.isAttack()) {
            ItemStack heldItem2 = player.m_21205_();
            Item item = heldItem2.m_41720_();
            if (item instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                event.setSwingHand(false);
                event.setCanceled(true);
                this.fire((Player)player, heldItem2);
                Gun gun2 = gunItem.getModifiedGun(heldItem2);
                if (!gun2.getGeneral().isAuto()) {
                    KeyBinds.getShootMapping().m_7249_(false);
                }
            }
        } else if (((Boolean)Config.CLIENT.controls.flipControls.get() != false ? event.isAttack() : event.isUseItem()) && (gun2 = (heldItem = player.m_21205_()).m_41720_()) instanceof GunItem) {
            GunItem gunItem = (GunItem)gun2;
            if (event.getHand() == InteractionHand.OFF_HAND) {
                Gun modifiedGun;
                if (player.m_21206_().m_41720_() == Items.f_42740_ && (modifiedGun = gunItem.getModifiedGun(heldItem)).getGeneral().getGripType() == GripType.ONE_HANDED) {
                    return;
                }
                event.setCanceled(true);
                event.setSwingHand(false);
                return;
            }
            if (((Boolean)Config.CLIENT.controls.flipControls.get()).booleanValue() || AimingHandler.get().isZooming() && AimingHandler.get().isLookingAtInteractableBlock()) {
                event.setCanceled(true);
                event.setSwingHand(false);
            }
        }
    }

    @SubscribeEvent
    public void onHandleShooting(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null) {
            ItemStack heldItem = player.m_21205_();
            if (heldItem.m_41720_() instanceof GunItem && (Gun.hasAmmo(heldItem) || player.m_7500_()) && !PlayerReviveHelper.isBleeding((Player)player)) {
                boolean shooting = KeyBinds.getShootMapping().m_90857_();
                if (VanillaAnimatedGuns.controllableLoaded) {
                    shooting |= ControllerHandler.isShooting();
                }
                if (shooting) {
                    if (!this.shooting) {
                        this.shooting = true;
                        PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(true));
                    }
                } else if (this.shooting) {
                    this.shooting = false;
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(false));
                }
            } else if (this.shooting) {
                this.shooting = false;
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShooting(false));
            }
        } else {
            this.shooting = false;
        }
    }

    @SubscribeEvent
    public void onPostClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null) {
            Gun gun;
            if (PlayerReviveHelper.isBleeding((Player)player)) {
                return;
            }
            ItemStack heldItem = player.m_21205_();
            if (heldItem.m_41720_() instanceof GunItem && KeyBinds.getShootMapping().m_90857_() && (gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem)).getGeneral().isAuto()) {
                this.fire((Player)player, heldItem);
            }
        }
    }

    public void fire(Player player, ItemStack heldItem) {
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return;
        }
        if (!Gun.hasAmmo(heldItem) && !player.m_7500_()) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        if (player.m_21211_().m_41720_() == Items.f_42740_) {
            return;
        }
        ItemCooldowns tracker = player.m_36335_();
        if (!tracker.m_41519_(heldItem.m_41720_())) {
            GunItem gunItem = (GunItem)heldItem.m_41720_();
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre(player, heldItem))) {
                return;
            }
            int rate = GunEnchantmentHelper.getRate(heldItem, modifiedGun);
            rate = GunModifierHelper.getModifiedRate(heldItem, rate);
            tracker.m_41524_(heldItem.m_41720_(), rate);
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageShoot(player));
            MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post(player, heldItem));
        }
    }
}

