/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag.client.network;

import com.hashnightflux.vag.Config;
import com.hashnightflux.vag.client.BulletTrail;
import com.hashnightflux.vag.client.CustomGunManager;
import com.hashnightflux.vag.client.audio.GunShotSound;
import com.hashnightflux.vag.client.handler.BulletTrailRenderingHandler;
import com.hashnightflux.vag.client.handler.GunRenderingHandler;
import com.hashnightflux.vag.common.NetworkGunManager;
import com.hashnightflux.vag.network.message.S2CMessageBulletTrail;
import com.hashnightflux.vag.network.message.S2CMessageGunSound;
import com.hashnightflux.vag.network.message.S2CMessageProjectileHitBlock;
import com.hashnightflux.vag.network.message.S2CMessageProjectileHitEntity;
import com.hashnightflux.vag.network.message.S2CMessageRemoveProjectile;
import com.hashnightflux.vag.network.message.S2CMessageUpdateGuns;
import com.hashnightflux.vag.particles.BulletHoleData;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientPlayHandler {
    public static void handleMessageGunSound(S2CMessageGunSound message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (message.showMuzzleFlash()) {
            GunRenderingHandler.get().showMuzzleFlashForPlayer(message.getShooterId());
        }
        if (message.getShooterId() == mc.f_91074_.m_19879_()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(message.getId(), SoundSource.PLAYERS, message.getVolume(), message.getPitch(), mc.f_91073_.m_213780_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new GunShotSound(message.getId(), SoundSource.PLAYERS, message.getX(), message.getY(), message.getZ(), message.getVolume(), message.getPitch(), message.isReload(), mc.f_91073_.m_213780_()));
        }
    }

    public static void handleMessageBulletTrail(S2CMessageBulletTrail message) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            int[] entityIds = message.getEntityIds();
            Vec3[] positions = message.getPositions();
            Vec3[] motions = message.getMotions();
            ItemStack item = message.getItem();
            int trailColor = message.getTrailColor();
            double trailLengthMultiplier = message.getTrailLengthMultiplier();
            int life = message.getLife();
            double gravity = message.getGravity();
            int shooterId = message.getShooterId();
            boolean enchanted = message.isEnchanted();
            ParticleOptions data = message.getParticleData();
            for (int i = 0; i < message.getCount(); ++i) {
                BulletTrailRenderingHandler.get().add(new BulletTrail(entityIds[i], positions[i], motions[i], item, trailColor, trailLengthMultiplier, life, gravity, shooterId, enchanted, data));
            }
        }
    }

    private static Particle spawnParticle(ParticleEngine manager, ParticleOptions data, double x, double y, double z, RandomSource rand, double velocityMultiplier) {
        return manager.m_107370_(data, x, y, z, (rand.m_188500_() - 0.5) * velocityMultiplier, (rand.m_188500_() - 0.5) * velocityMultiplier, (rand.m_188500_() - 0.5) * velocityMultiplier);
    }

    public static void handleProjectileHitBlock(S2CMessageProjectileHitBlock message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world != null) {
            BlockState state = world.m_8055_(message.getPos());
            double holeX = message.getX() + 0.005 * (double)message.getFace().m_122429_();
            double holeY = message.getY() + 0.005 * (double)message.getFace().m_122430_();
            double holeZ = message.getZ() + 0.005 * (double)message.getFace().m_122431_();
            double distance = Math.sqrt(mc.f_91074_.m_20275_(message.getX(), message.getY(), message.getZ()));
            world.m_6493_((ParticleOptions)new BulletHoleData(message.getFace(), message.getPos()), false, holeX, holeY, holeZ, 0.0, 0.0, 0.0);
            if (distance < (Double)Config.CLIENT.particle.impactParticleDistance.get()) {
                for (int i = 0; i < 4; ++i) {
                    Vec3i normal = message.getFace().m_122436_();
                    Vec3 motion = new Vec3((double)normal.m_123341_(), (double)normal.m_123342_(), (double)normal.m_123343_());
                    motion.m_82520_(ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_));
                    world.m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), false, message.getX(), message.getY(), message.getZ(), motion.f_82479_, motion.f_82480_, motion.f_82481_);
                }
            }
            if (distance <= (Double)Config.CLIENT.sounds.impactSoundDistance.get()) {
                world.m_7785_(message.getX(), message.getY(), message.getZ(), state.m_60827_().m_56775_(), SoundSource.BLOCKS, 2.0f, 2.0f, false);
            }
        }
    }

    private static double getRandomDir(RandomSource random) {
        return -0.25 + random.m_188500_() * 0.5;
    }

    public static void handleProjectileHitEntity(S2CMessageProjectileHitEntity message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world == null) {
            return;
        }
        SoundEvent event = ClientPlayHandler.getHitSound(message.isCritical(), message.isHeadshot(), message.isPlayer());
        if (event == null) {
            return;
        }
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)event, (float)1.0f, (float)(1.0f + world.f_46441_.m_188501_() * 0.2f)));
    }

    @Nullable
    private static SoundEvent getHitSound(boolean critical, boolean headshot, boolean player) {
        if (critical) {
            if (((Boolean)Config.CLIENT.sounds.playSoundWhenCritical.get()).booleanValue()) {
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)Config.CLIENT.sounds.criticalSound.get()));
                return event != null ? event : SoundEvents.f_12313_;
            }
        } else if (headshot) {
            if (((Boolean)Config.CLIENT.sounds.playSoundWhenHeadshot.get()).booleanValue()) {
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)Config.CLIENT.sounds.headshotSound.get()));
                return event != null ? event : SoundEvents.f_12314_;
            }
        } else if (player) {
            return SoundEvents.f_12323_;
        }
        return null;
    }

    public static void handleRemoveProjectile(S2CMessageRemoveProjectile message) {
        BulletTrailRenderingHandler.get().remove(message.getEntityId());
    }

    public static void handleUpdateGuns(S2CMessageUpdateGuns message) {
        NetworkGunManager.updateRegisteredGuns(message);
        CustomGunManager.updateCustomGuns(message);
    }
}

