/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag.client.render.gun;

import com.hashnightflux.vag.client.render.gun.IOverrideModel;
import com.hashnightflux.vag.item.GunItem;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="vag", value={Dist.CLIENT})
public class ModelOverrides {
    private static final Map<Item, IOverrideModel> MODEL_MAP = new HashMap<Item, IOverrideModel>();

    public static void register(Item item, IOverrideModel model) {
        if (MODEL_MAP.putIfAbsent(item, model) == null) {
            MinecraftForge.EVENT_BUS.register((Object)model);
        }
    }

    public static boolean hasModel(ItemStack stack) {
        return MODEL_MAP.containsKey(stack.m_41720_());
    }

    @Nullable
    public static IOverrideModel getModel(ItemStack stack) {
        return MODEL_MAP.get(stack.m_41720_());
    }

    @SubscribeEvent
    public static void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.CLIENT) {
            ModelOverrides.tick(event.player);
        }
    }

    private static void tick(Player player) {
        IOverrideModel model;
        ItemStack heldItem = player.m_21205_();
        if (!heldItem.m_41619_() && heldItem.m_41720_() instanceof GunItem && (model = ModelOverrides.getModel(heldItem)) != null) {
            model.tick(player);
        }
    }
}

