/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="vag")
public class DelayedTask {
    public static List<Impl> tasks = new ArrayList<Impl>();

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        tasks.clear();
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        tasks.clear();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            MinecraftServer server = (MinecraftServer)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            Iterator<Impl> it = tasks.iterator();
            while (it.hasNext()) {
                Impl impl = it.next();
                if (impl.executionTick > server.m_129921_()) continue;
                impl.runnable.run();
                it.remove();
            }
        }
    }

    public static void runAfter(int ticks, Runnable run) {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
        if (!server.m_18695_()) {
            throw new IllegalStateException("Tried to add a delayed task off the main thread");
        }
        tasks.add(new Impl(server.m_129921_() + ticks, run));
    }

    private static class Impl {
        private int executionTick;
        private Runnable runnable;

        private Impl(int executionTick, Runnable runnable) {
            this.executionTick = executionTick;
            this.runnable = runnable;
        }
    }
}

