/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag.common;

import com.hashnightflux.vag.client.render.IHeldAnimation;
import com.hashnightflux.vag.client.render.pose.OneHandedPose;
import com.hashnightflux.vag.client.render.pose.TwoHandedPose;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;

public class GripType {
    public static final GripType ONE_HANDED = new GripType(new ResourceLocation("vag", "one_handed"), new OneHandedPose());
    public static final GripType TWO_HANDED = new GripType(new ResourceLocation("vag", "two_handed"), new TwoHandedPose());
    private static Map<ResourceLocation, GripType> gripTypeMap = new HashMap<ResourceLocation, GripType>();
    private final ResourceLocation id;
    private final IHeldAnimation heldAnimation;

    public static boolean applyBackTransforms(Player player, PoseStack poseStack) {
        if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() == Items.f_42741_) {
            return false;
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        if (player.m_6047_()) {
            poseStack.m_85837_(0.0, -0.4375, -0.25);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
        } else {
            poseStack.m_85837_(0.0, -0.3125, -0.125);
        }
        if (!player.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            poseStack.m_85837_(0.0, 0.0, -0.0625);
        }
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-45.0f));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        return true;
    }

    public static void registerType(GripType type) {
        gripTypeMap.putIfAbsent(type.getId(), type);
    }

    public static GripType getType(ResourceLocation id) {
        return gripTypeMap.getOrDefault(id, ONE_HANDED);
    }

    public GripType(ResourceLocation id, IHeldAnimation heldAnimation) {
        this.id = id;
        this.heldAnimation = heldAnimation;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public IHeldAnimation getHeldAnimation() {
        return this.heldAnimation;
    }

    static {
        GripType.registerType(ONE_HANDED);
        GripType.registerType(TWO_HANDED);
    }
}

