/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag.common;

import com.hashnightflux.vag.entity.ProjectileEntity;
import com.hashnightflux.vag.init.ModEntities;
import com.hashnightflux.vag.interfaces.IProjectileFactory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class ProjectileManager {
    private static ProjectileManager instance = null;
    private final IProjectileFactory DEFAULT_FACTORY = (worldIn, entity, weapon, item, modifiedGun) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun);
    private final Map<ResourceLocation, IProjectileFactory> projectileFactoryMap = new HashMap<ResourceLocation, IProjectileFactory>();

    public static ProjectileManager getInstance() {
        if (instance == null) {
            instance = new ProjectileManager();
        }
        return instance;
    }

    public void registerFactory(Item ammo, IProjectileFactory factory) {
        this.projectileFactoryMap.put(ForgeRegistries.ITEMS.getKey((Object)ammo), factory);
    }

    public IProjectileFactory getFactory(ResourceLocation id) {
        return this.projectileFactoryMap.getOrDefault(id, this.DEFAULT_FACTORY);
    }
}

