/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag.common;

import com.google.common.collect.Maps;
import com.hashnightflux.vag.common.Gun;
import com.hashnightflux.vag.item.GunItem;
import com.hashnightflux.vag.util.GunEnchantmentHelper;
import com.hashnightflux.vag.util.GunModifierHelper;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.Util;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ShootTracker {
    private static final Map<Player, ShootTracker> SHOOT_TRACKER_MAP = new WeakHashMap<Player, ShootTracker>();
    private final Map<Item, Pair<Long, Integer>> cooldownMap = Maps.newHashMap();

    public static ShootTracker getShootTracker(Player player) {
        return SHOOT_TRACKER_MAP.computeIfAbsent(player, player1 -> new ShootTracker());
    }

    public void putCooldown(ItemStack weapon, GunItem item, Gun modifiedGun) {
        int rate = GunEnchantmentHelper.getRate(weapon, modifiedGun);
        rate = GunModifierHelper.getModifiedRate(weapon, rate);
        this.cooldownMap.put(item, (Pair<Long, Integer>)Pair.of((Object)Util.m_137550_(), (Object)(rate * 50)));
    }

    public boolean hasCooldown(GunItem item) {
        Pair<Long, Integer> pair = this.cooldownMap.get(item);
        if (pair != null) {
            return Util.m_137550_() - (Long)pair.getLeft() < (long)((Integer)pair.getRight() - 50);
        }
        return false;
    }

    public long getRemaining(GunItem item) {
        Pair<Long, Integer> pair = this.cooldownMap.get(item);
        if (pair != null) {
            return (long)((Integer)pair.getRight()).intValue() - (Util.m_137550_() - (Long)pair.getLeft());
        }
        return 0L;
    }
}

