/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag.common.network;

import com.hashnightflux.vag.Config;
import com.hashnightflux.vag.VanillaAnimatedGuns;
import com.hashnightflux.vag.common.Gun;
import com.hashnightflux.vag.common.ProjectileManager;
import com.hashnightflux.vag.common.ShootTracker;
import com.hashnightflux.vag.common.SpreadTracker;
import com.hashnightflux.vag.entity.ProjectileEntity;
import com.hashnightflux.vag.event.GunFireEvent;
import com.hashnightflux.vag.init.ModEnchantments;
import com.hashnightflux.vag.init.ModSyncedDataKeys;
import com.hashnightflux.vag.interfaces.IProjectileFactory;
import com.hashnightflux.vag.item.GunItem;
import com.hashnightflux.vag.network.PacketHandler;
import com.hashnightflux.vag.network.message.C2SMessageShoot;
import com.hashnightflux.vag.network.message.S2CMessageBulletTrail;
import com.hashnightflux.vag.network.message.S2CMessageGunSound;
import com.hashnightflux.vag.util.GunEnchantmentHelper;
import com.hashnightflux.vag.util.GunModifierHelper;
import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerPlayHandler {
    private static final Predicate<LivingEntity> HOSTILE_ENTITIES = entity -> entity.m_5720_() == SoundSource.HOSTILE && !(entity instanceof NeutralMob) && !((List)Config.COMMON.aggroMobs.exemptEntities.get()).contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString());

    /*
     * Enabled aggressive block sorting
     */
    public static void handleShoot(C2SMessageShoot message, ServerPlayer player) {
        int level;
        CompoundTag tag;
        ResourceLocation fireSound;
        Gun modifiedGun;
        GunItem item;
        ItemStack heldItem;
        Level world;
        block12: {
            Iterator iterator;
            double z;
            double y;
            double x;
            double radius;
            block13: {
                block11: {
                    if (player.m_5833_()) {
                        return;
                    }
                    if (player.m_21211_().m_41720_() == Items.f_42740_) {
                        return;
                    }
                    world = player.f_19853_;
                    heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
                    Item item2 = heldItem.m_41720_();
                    if (!(item2 instanceof GunItem)) break block11;
                    item = (GunItem)item2;
                    if (!Gun.hasAmmo(heldItem) && !player.m_7500_()) break block11;
                    modifiedGun = item.getModifiedGun(heldItem);
                    if (modifiedGun == null) return;
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre((Player)player, heldItem))) {
                        return;
                    }
                    player.m_146922_(Mth.m_14177_((float)message.getRotationYaw()));
                    player.m_146926_(Mth.m_14036_((float)message.getRotationPitch(), (float)-90.0f, (float)90.0f));
                    ShootTracker tracker = ShootTracker.getShootTracker((Player)player);
                    if (tracker.hasCooldown(item) && tracker.getRemaining(item) > (long)((Integer)Config.SERVER.cooldownThreshold.get()).intValue()) {
                        VanillaAnimatedGuns.LOGGER.warn(player.m_7755_().m_214077_() + "(" + player.m_20148_() + ") tried to fire before cooldown finished or server is lagging? Remaining milliseconds: " + tracker.getRemaining(item));
                        return;
                    }
                    tracker.putCooldown(heldItem, item, modifiedGun);
                    if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    }
                    if (!modifiedGun.getGeneral().isAlwaysSpread() && modifiedGun.getGeneral().getSpread() > 0.0f) {
                        SpreadTracker.get((Player)player).update((Player)player, item);
                    }
                    int count = modifiedGun.getGeneral().getProjectileAmount();
                    Gun.Projectile projectileProps = modifiedGun.getProjectile();
                    ProjectileEntity[] spawnedProjectiles = new ProjectileEntity[count];
                    for (int i = 0; i < count; ++i) {
                        IProjectileFactory factory = ProjectileManager.getInstance().getFactory(projectileProps.getItem());
                        ProjectileEntity projectileEntity = factory.create(world, (LivingEntity)player, heldItem, item, modifiedGun);
                        projectileEntity.setWeapon(heldItem);
                        projectileEntity.setAdditionalDamage(Gun.getAdditionalDamage(heldItem));
                        world.m_7967_((Entity)projectileEntity);
                        spawnedProjectiles[i] = projectileEntity;
                        projectileEntity.m_8119_();
                    }
                    if (!projectileProps.isVisible()) {
                        double spawnX = player.m_20185_();
                        double spawnY = player.m_20186_() + 1.0;
                        double spawnZ = player.m_20189_();
                        double radius2 = (Double)Config.COMMON.network.projectileTrackingRange.get();
                        ParticleOptions data = GunEnchantmentHelper.getParticle(heldItem);
                        S2CMessageBulletTrail messageBulletTrail = new S2CMessageBulletTrail(spawnedProjectiles, projectileProps, player.m_19879_(), data);
                        PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.f_19853_, (double)spawnX, (double)spawnY, (double)spawnZ, (double)radius2), (IMessage)messageBulletTrail);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post((Player)player, heldItem));
                    if (!((Boolean)Config.COMMON.aggroMobs.enabled.get()).booleanValue()) break block12;
                    radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.COMMON.aggroMobs.soundRange.get());
                    x = player.m_20185_();
                    y = player.m_20186_() + 0.5;
                    z = player.m_20189_();
                    AABB box = new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
                    radius *= radius;
                    iterator = world.m_6443_(LivingEntity.class, box, HOSTILE_ENTITIES).iterator();
                    break block13;
                }
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.8f);
                return;
            }
            while (iterator.hasNext()) {
                double dz;
                double dy;
                LivingEntity entity = (LivingEntity)iterator.next();
                double dx = x - entity.m_20185_();
                if (!(dx * dx + (dy = y - entity.m_20186_()) * dy + (dz = z - entity.m_20189_()) * dz <= radius)) continue;
                entity.m_6703_((LivingEntity)((Boolean)Config.COMMON.aggroMobs.angerHostileMobs.get() != false ? player : entity));
            }
        }
        if ((fireSound = ServerPlayHandler.getFireSound(heldItem, modifiedGun)) != null) {
            double posX = player.m_20185_();
            double posY = player.m_20186_() + (double)player.m_20192_();
            double posZ = player.m_20189_();
            float volume = GunModifierHelper.getFireSoundVolume(heldItem);
            float pitch = 0.9f + world.f_46441_.m_188501_() * 0.2f;
            double radius = GunModifierHelper.getModifiedFireSoundRadius(heldItem, (Double)Config.SERVER.gunShotMaxDistance.get());
            boolean muzzle = modifiedGun.getDisplay().getFlash() != null;
            S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.m_19879_(), muzzle, false);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.f_19853_, (double)posX, (double)posY, (double)posZ, (double)radius), (IMessage)messageSound);
        }
        if (!(player.m_7500_() || (tag = heldItem.m_41784_()).m_128471_("IgnoreAmmo") || (level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.RECLAIMED.get()), (ItemStack)heldItem)) != 0 && player.f_19853_.f_46441_.m_188503_(4 - Mth.m_14045_((int)level, (int)1, (int)2)) == 0)) {
            tag.m_128405_("AmmoCount", Math.max(0, tag.m_128451_("AmmoCount") - 1));
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
    }

    private static ResourceLocation getFireSound(ItemStack stack, Gun modifiedGun) {
        ResourceLocation fireSound = null;
        if (GunModifierHelper.isSilencedFire(stack)) {
            fireSound = modifiedGun.getSounds().getSilencedFire();
        } else if (stack.m_41793_()) {
            fireSound = modifiedGun.getSounds().getEnchantedFire();
        }
        if (fireSound != null) {
            return fireSound;
        }
        return modifiedGun.getSounds().getFire();
    }

    public static void handleCraft(ServerPlayer player, ResourceLocation id, BlockPos pos) {
        Level world = player.f_19853_;
    }

    public static void handleUnload(ServerPlayer player) {
        CompoundTag tag;
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof GunItem && (tag = stack.m_41783_()) != null && tag.m_128425_("AmmoCount", 3)) {
            int count = tag.m_128451_("AmmoCount");
            tag.m_128405_("AmmoCount", 0);
            GunItem gunItem = (GunItem)stack.m_41720_();
            Gun gun = gunItem.getModifiedGun(stack);
            ResourceLocation id = gun.getProjectile().getItem();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (item == null) {
                return;
            }
            int maxStackSize = item.m_41459_();
            int stacks = count / maxStackSize;
            for (int i = 0; i < stacks; ++i) {
                ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item, maxStackSize));
            }
            int remaining = count % maxStackSize;
            if (remaining > 0) {
                ServerPlayHandler.spawnAmmo(player, new ItemStack((ItemLike)item, remaining));
            }
        }
    }

    private static void spawnAmmo(ServerPlayer player, ItemStack stack) {
        player.m_150109_().m_36054_(stack);
        if (stack.m_41613_() > 0) {
            player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack.m_41777_()));
        }
    }

    public static void handleAttachments(ServerPlayer player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            // empty if block
        }
    }
}

