/*
 * Decompiled with CFR 0.152.
 */
package com.hashnightflux.vag.item.attachment.impl;

import com.hashnightflux.vag.debug.IDebugWidget;
import com.hashnightflux.vag.debug.IEditorMenu;
import com.hashnightflux.vag.debug.client.screen.widget.DebugSlider;
import com.hashnightflux.vag.interfaces.IGunModifier;
import com.hashnightflux.vag.item.attachment.impl.Attachment;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class Scope
extends Attachment
implements IEditorMenu {
    protected float aimFovModifier;
    protected float additionalZoom;
    protected double reticleOffset;
    protected boolean stable;
    protected double viewFinderDist;

    private Scope() {
        super(new IGunModifier[0]);
    }

    private Scope(float additionalZoom, double reticleOffset, IGunModifier ... modifier) {
        super(modifier);
        this.aimFovModifier = 1.0f;
        this.additionalZoom = additionalZoom;
        this.reticleOffset = reticleOffset;
    }

    private Scope(float aimFovModifier, float additionalZoom, double reticleOffset, boolean stable, double viewFinderDist, IGunModifier ... modifiers) {
        super(modifiers);
        this.aimFovModifier = aimFovModifier;
        this.additionalZoom = additionalZoom;
        this.reticleOffset = reticleOffset;
        this.stable = stable;
        this.viewFinderDist = viewFinderDist;
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public void stabilise() {
        this.stable = true;
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public Scope viewFinderOffset(double offset) {
        this.viewFinderDist = offset;
        return this;
    }

    public float getFovModifier() {
        return this.aimFovModifier;
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public float getAdditionalZoom() {
        return this.additionalZoom;
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public double getCenterOffset() {
        return this.reticleOffset;
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public double getReticleOffset() {
        return this.reticleOffset;
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public boolean isStable() {
        return this.stable;
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public double getViewFinderOffset() {
        return this.viewFinderDist;
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public double getViewFinderDistance() {
        return this.viewFinderDist;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Scope");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            widgets.add(Pair.of((Object)Component.m_237113_((String)"Aim FOV Modifier"), () -> new DebugSlider(0.0, 1.0, this.aimFovModifier, 0.05, 3, value -> {
                this.aimFovModifier = value.floatValue();
            })));
            widgets.add(Pair.of((Object)Component.m_237113_((String)"Zoom (Legacy)"), () -> new DebugSlider(0.0, 0.5, this.additionalZoom, 0.05, 3, value -> {
                this.additionalZoom = value.floatValue();
            })));
            widgets.add(Pair.of((Object)Component.m_237113_((String)"Reticle Offset"), () -> new DebugSlider(0.0, 4.0, this.reticleOffset, 0.025, 4, value -> {
                this.reticleOffset = value;
            })));
            widgets.add(Pair.of((Object)Component.m_237113_((String)"View Finder Distance"), () -> new DebugSlider(0.0, 5.0, this.viewFinderDist, 0.05, 3, value -> {
                this.viewFinderDist = value;
            })));
        });
    }

    public Scope copy() {
        Scope scope = new Scope();
        scope.aimFovModifier = this.aimFovModifier;
        scope.additionalZoom = this.additionalZoom;
        scope.reticleOffset = this.reticleOffset;
        scope.stable = this.stable;
        scope.viewFinderDist = this.viewFinderDist;
        return scope;
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public static Scope create(float additionalZoom, double centerOffset, IGunModifier ... modifiers) {
        return new Scope(additionalZoom, centerOffset, modifiers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private float aimFovModifier = 1.0f;
        private float additionalZoom = 0.0f;
        private double reticleOffset = 0.0;
        private boolean stable = false;
        private double viewFinderDist = 0.0;
        private IGunModifier[] modifiers = new IGunModifier[0];

        private Builder() {
        }

        public Builder aimFovModifier(float fovModifier) {
            this.aimFovModifier = fovModifier;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder additionalZoom(float additionalZoom) {
            this.additionalZoom = additionalZoom;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder centerOffset(double centerOffset) {
            this.reticleOffset = centerOffset;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder reticleOffset(double reticleOffset) {
            this.reticleOffset = reticleOffset;
            return this;
        }

        public Builder stable(boolean stable) {
            this.stable = stable;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder viewFinderOffset(double viewFinderOffset) {
            this.viewFinderDist = viewFinderOffset;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder viewFinderDistance(double viewFinderDist) {
            this.viewFinderDist = viewFinderDist;
            return this;
        }

        public Builder modifiers(IGunModifier ... modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public Scope build() {
            return new Scope(this.aimFovModifier, this.additionalZoom, this.reticleOffset, this.stable, this.viewFinderDist, this.modifiers);
        }
    }
}

