/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.ex_cap;

import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import net.forixaim.ex_cap.Config;
import net.forixaim.ex_cap.api.Registries;
import net.forixaim.ex_cap.api.moveset.ExCapWeaponReloadListener;
import net.forixaim.ex_cap.capabilities.ExCapCategories;
import net.forixaim.ex_cap.capabilities.ExCapStyle;
import net.forixaim.ex_cap.capabilities.weapon_presets.ExCapWeapons;
import net.forixaim.ex_cap.registry.ItemRegistry;
import net.forixaim.ex_cap.skill.ExCapDatakeys;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

@Mod(value="efm_ex")
public class EpicFightEXCapability {
    public static final String MODID = "efm_ex";
    private static final Logger LOGGER = LogUtils.getLogger();

    public EpicFightEXCapability(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::addPackFindersEvent);
        ExCapDatakeys.DATA_KEYS.register(modEventBus);
        ItemRegistry.ITEMS.register(modEventBus);
        ExCapWeapons.EX_CAP_WEAPONS.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(this::addResourceReloader);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Style.ENUM_MANAGER.registerEnumCls(MODID, ExCapStyle.class);
        WeaponCategory.ENUM_MANAGER.registerEnumCls(MODID, ExCapCategories.class);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(EpicFightEXCapability::onFMLLoadComplete);
    }

    private void addResourceReloader(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ExCapWeaponReloadListener());
    }

    public void addPackFindersEvent(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/ex_cap_spears"});
            PathPackResources pack = new PathPackResources(ModList.get().getModFileById(MODID).getFile().getFileName() + ":" + String.valueOf(resourcePath), resourcePath, false);
            Pack.ResourcesSupplier resourcesSupplier = string -> pack;
            Pack.Info info = Pack.m_246334_((String)"ex_cap_spears", (Pack.ResourcesSupplier)resourcesSupplier);
            if (info != null) {
                event.addRepositorySource(source -> source.accept(Pack.m_245512_((String)"ex_cap_spears", (Component)Component.m_237115_((String)"pack.ex_cap_spears.title"), (boolean)false, (Pack.ResourcesSupplier)resourcesSupplier, (Pack.Info)info, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
            }
        }
    }

    public static void onFMLLoadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(Registries::registerMaterials);
        event.enqueueWork(Registries::registerMovesets);
        event.enqueueWork(Registries::registerCapabilities);
    }
}

