/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.ex_cap.api;

import java.util.Collection;
import java.util.Map;
import net.forixaim.ex_cap.api.MaterialPropertyManager;
import net.forixaim.ex_cap.api.events.ExCapMaterialRegistryEvent;
import net.forixaim.ex_cap.api.events.ExCapMovesetRegistryEvent;
import net.forixaim.ex_cap.api.events.MoveSetDefinitionRegistryEvent;
import net.forixaim.ex_cap.api.material.MaterialProperties;
import net.forixaim.ex_cap.api.providers.ProviderConditional;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class Registries {
    public static void registerMovesets() {
        MoveSetDefinitionRegistryEvent event2 = new MoveSetDefinitionRegistryEvent();
        ModLoader.get().postEvent((Event)event2);
        event2.getMoveSets().forEach((moveSet, registryEvent) -> registryEvent.run());
    }

    public static MaterialProperties quickRegister(float pierce, float impact, float maxStrikes) {
        return new MaterialProperties(Map.ofEntries(Map.entry((Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), Double.valueOf(pierce)), Map.entry((Attribute)EpicFightAttributes.IMPACT.get(), Double.valueOf(impact)), Map.entry((Attribute)EpicFightAttributes.MAX_STRIKES.get(), Double.valueOf(maxStrikes))));
    }

    public static void registerMaterials() {
        Map<Tier, MaterialProperties> properties = Map.ofEntries(Map.entry(Tiers.WOOD, Registries.quickRegister(0.0f, 1.0f, 1.0f)), Map.entry(Tiers.STONE, Registries.quickRegister(0.0f, 2.0f, 1.0f)), Map.entry(Tiers.IRON, Registries.quickRegister(5.0f, 3.0f, 1.0f)), Map.entry(Tiers.GOLD, Registries.quickRegister(0.0f, 2.0f, 2.0f)), Map.entry(Tiers.DIAMOND, Registries.quickRegister(7.0f, 3.0f, 2.0f)), Map.entry(Tiers.NETHERITE, Registries.quickRegister(10.0f, 3.0f, 3.0f)));
        MaterialPropertyManager.addAll(properties);
        ExCapMaterialRegistryEvent event = new ExCapMaterialRegistryEvent();
        ModLoader.get().postEvent((Event)event);
        event.getModMap().values().forEach(MaterialPropertyManager::addAll);
    }

    public static void registerCapabilities() {
        ExCapMovesetRegistryEvent event3 = new ExCapMovesetRegistryEvent();
        ModLoader.get().postEvent((Event)event3);
        event3.getCoreCapabilityConditionalMap().forEach((coreCapability, conditionals) -> coreCapability.getStyleComboProviderRegistry().addAll((Collection<ProviderConditional>)conditionals));
        event3.getMoveSetRegistryMap().forEach((coreCapability, styleMoveSetMap) -> styleMoveSetMap.forEach((style, moveSet) -> coreCapability.getAttackSets().put((Style)style, moveSet.build())));
    }
}

