/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.ex_cap.api.moveset;

import com.google.common.collect.Maps;
import com.mna.api.spells.parts.Shape;
import java.util.Map;
import java.util.function.Function;
import net.forixaim.ex_cap.api.moveset.MoveSet;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.guard.GuardSkill;

public class CastingMoveSet
extends MoveSet {
    protected final Map<Shape, AnimationManager.AnimationAccessor<? extends StaticAnimation>> spellAnimations;

    public CastingMoveSet(MoveSetBuilder builder) {
        super(builder);
        this.spellAnimations = builder.spellAnimations;
    }

    public static MoveSetBuilder builder() {
        return new MoveSetBuilder();
    }

    public Map<Shape, AnimationManager.AnimationAccessor<? extends StaticAnimation>> getSpellAnimations() {
        return this.spellAnimations;
    }

    public static class MoveSetBuilder
    extends MoveSet.MoveSetBuilder {
        protected final Map<Shape, AnimationManager.AnimationAccessor<? extends StaticAnimation>> spellAnimations = Maps.newHashMap();

        public MoveSetBuilder addSpellAnimations(Shape shape, AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
            this.spellAnimations.put(shape, animation);
            return this;
        }

        @Override
        public MoveSetBuilder setPassiveSkill(Skill newPassiveSkill) {
            return (MoveSetBuilder)super.setPassiveSkill(newPassiveSkill);
        }

        @Override
        public MoveSetBuilder addAutoAttacks(AnimationManager.AnimationAccessor<? extends AttackAnimation> ... attackAnimations) {
            return (MoveSetBuilder)super.addAutoAttacks(attackAnimations);
        }

        @Override
        public MoveSetBuilder addLivingMotionModifier(LivingMotion livingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
            return (MoveSetBuilder)super.addLivingMotionModifier(livingMotion, animation);
        }

        @Override
        public MoveSetBuilder addInnateSkill(Function<ItemStack, Skill> weaponInnateSkill) {
            return (MoveSetBuilder)super.addInnateSkill(weaponInnateSkill);
        }

        @Override
        public MoveSetBuilder addLivingMotionsRecursive(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, LivingMotion ... motions) {
            return (MoveSetBuilder)super.addLivingMotionsRecursive(animation, motions);
        }

        @SafeVarargs
        public final MoveSetBuilder addGuardAnimations(GuardSkill guardSkill, GuardSkill.BlockType blockType, AnimationManager.AnimationAccessor<? extends StaticAnimation> ... animation) {
            return (MoveSetBuilder)super.addGuardAnimations((Skill)guardSkill, blockType, animation);
        }

        @Override
        public CastingMoveSet build() {
            return new CastingMoveSet(this);
        }
    }
}

