/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.ex_cap.api.moveset;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.forixaim.ex_cap.api.Registries;
import net.forixaim.ex_cap.api.moveset.MoveSet;
import net.forixaim.ex_cap.api.providers.ProviderConditional;
import net.forixaim.ex_cap.api.providers.ProviderConditionalType;
import net.forixaim.ex_cap.api.utilities.JsonUtils;
import net.forixaim.ex_cap.capabilities.weapon_presets.ExCapWeapons;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public class ExCapWeaponReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String DIRECTORY = "capabilities/weapons/ex_cap";

    public ExCapWeaponReloadListener() {
        super(GSON, DIRECTORY);
    }

    private void clear() {
        ExCapWeapons.REGISTRY.get().forEach(weapon -> {
            weapon.getAttackSets().clear();
            weapon.getStyleComboProviderRegistry().clear();
        });
        Registries.registerCapabilities();
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> json, @NotNull ResourceManager manager, @NotNull ProfilerFiller filler) {
        this.clear();
        manager.m_7536_().forEach(pack -> pack.m_5698_(PackType.SERVER_DATA).forEach(namespace -> ExCapWeapons.REGISTRY.get().forEach(weapon -> {
            if (Objects.requireNonNull(ExCapWeapons.REGISTRY.get().getKey(weapon)).m_135827_().equals(namespace)) {
                Map<ResourceLocation, JsonElement> movesets = JsonUtils.getJsonsForNamespace(manager, namespace, "capabilities/weapons/ex_cap/" + Objects.requireNonNull(ExCapWeapons.REGISTRY.get().getKey(weapon)).m_135815_() + "/movesets");
                Map<ResourceLocation, JsonElement> providers = JsonUtils.getJsonsForNamespace(manager, namespace, "capabilities/weapons/ex_cap/" + Objects.requireNonNull(ExCapWeapons.REGISTRY.get().getKey(weapon)).m_135815_() + "/providers");
                if (!providers.isEmpty()) {
                    providers.forEach((key, value) -> {
                        JsonObject gsonObject = value.getAsJsonObject();
                        ProviderConditional.ProviderConditionalBuilder builder = ProviderConditional.builder();
                        ProviderConditionalType type = ProviderConditionalType.valueOf(gsonObject.get("provider_type").getAsString().toUpperCase());
                        Style wieldStyle = (Style)Style.ENUM_MANAGER.get(gsonObject.get("style").getAsString().toUpperCase());
                        boolean visibleOffHand = gsonObject.get("visible_offhand").getAsBoolean();
                        block0 : switch (type) {
                            case DEFAULT: {
                                for (int i = 0; i < weapon.getStyleComboProviderRegistry().size(); ++i) {
                                    if (!weapon.getStyleComboProviderRegistry().get(i).getType().equals((Object)type)) continue;
                                    weapon.getStyleComboProviderRegistry().set(i, ProviderConditional.builder().setType(type).setWieldStyle(wieldStyle).isVisibleOffHand(visibleOffHand).build());
                                    break block0;
                                }
                                break;
                            }
                            case WEAPON_CATEGORY: {
                                builder.setType(type).setWieldStyle(wieldStyle).isVisibleOffHand(visibleOffHand).setCategory((WeaponCategory)WeaponCategory.ENUM_MANAGER.get(gsonObject.get("weapon_category").getAsString().toUpperCase())).setHand(InteractionHand.valueOf((String)gsonObject.get("hand").getAsString().toUpperCase())).build();
                                break;
                            }
                            case SPECIFIC_WEAPON: {
                                builder.setType(type).setWieldStyle(wieldStyle).isVisibleOffHand(visibleOffHand).setWeapon((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)gsonObject.get("specific_weapon").getAsString()))).setHand(InteractionHand.valueOf((String)gsonObject.get("hand").getAsString().toUpperCase())).build();
                                break;
                            }
                            case SKILL_EXISTENCE: 
                            case SKILL_ACTIVATION: {
                                builder.setType(type).setWieldStyle(wieldStyle).isVisibleOffHand(visibleOffHand).setSkillToCheck(SkillManager.getSkill((String)gsonObject.get("skill").getAsString())).setSlot((SkillSlot)SkillSlot.ENUM_MANAGER.get(gsonObject.get("slot").getAsString().toUpperCase())).build();
                                break;
                            }
                            case DATA_KEY: {
                                builder.setType(type).setWieldStyle(wieldStyle).isVisibleOffHand(visibleOffHand).setSkillToCheck(SkillManager.getSkill((String)gsonObject.get("skill").getAsString())).setKey((SkillDataKey<Boolean>)((SkillDataKey)((IForgeRegistry)SkillDataKeys.REGISTRY.get()).getValue(ResourceLocation.parse((String)gsonObject.get("boolean_key").getAsString())))).setSlot((SkillSlot)SkillSlot.ENUM_MANAGER.get(gsonObject.get("slot").getAsString().toUpperCase())).build();
                            }
                        }
                    });
                }
                if (!movesets.isEmpty()) {
                    movesets.forEach((key, value) -> {
                        JsonObject gsonObject = value.getAsJsonObject();
                        if (gsonObject.has("import")) {
                            JsonObject importObject = gsonObject.getAsJsonObject("import");
                            JsonArray styleArray = importObject.getAsJsonArray("styles");
                            ArrayList styles = Lists.newArrayList();
                            styleArray.forEach(styleElement -> styles.add((Style)Style.ENUM_MANAGER.get(styleElement.getAsString())));
                            String[] resource = importObject.get("parent").getAsString().split(":");
                            resource[1] = "capabilities/weapons/types" + resource[1];
                            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)resource[0], (String)resource[1]);
                            Optional importedResource = manager.m_213713_(location);
                            JsonObject element = importedResource.map(JsonUtils::parse).orElseGet(JsonObject::new).getAsJsonObject();
                            Map importedCombos = element.get("combos").getAsJsonObject().asMap();
                            Map importedInnates = element.get("innate_skills").getAsJsonObject().asMap();
                            Map importedLivingMotions = element.get("livingmotion_modifier").getAsJsonObject().asMap();
                            String defaultKey = !importedLivingMotions.isEmpty() ? (String)importedLivingMotions.keySet().stream().findFirst().get() : "common";
                            ArrayList moveSets = Lists.newArrayList();
                            importedCombos.forEach((s, jsonElement) -> {
                                if (!s.equals("mount")) {
                                    MoveSet.MoveSetBuilder moveSetBuilder = MoveSet.builder();
                                    List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> autoComboAnimations = ExCapWeaponReloadListener.getAnimationAccessors(jsonElement);
                                    moveSetBuilder.addAutoAttacks((AnimationManager.AnimationAccessor[])autoComboAnimations.toArray(AnimationManager.AnimationAccessor[]::new));
                                    if (importedCombos.containsKey("mount")) {
                                        moveSetBuilder.addMountAttacks((AnimationManager.AnimationAccessor[])ExCapWeaponReloadListener.getAnimationAccessors((JsonElement)importedCombos.get("mount")).toArray(AnimationManager.AnimationAccessor[]::new));
                                    }
                                    if (importedInnates.containsKey(s)) {
                                        moveSetBuilder.addInnateSkill(itemstack -> SkillManager.getSkill((String)((JsonElement)importedInnates.get(s)).getAsString()));
                                    }
                                    if (!importedLivingMotions.isEmpty()) {
                                        if (importedLivingMotions.containsKey(s)) {
                                            ExCapWeaponReloadListener.getLivingMotionModifiers(((JsonElement)importedLivingMotions.get(s)).getAsJsonObject().asMap()).forEach(moveSetBuilder::addLivingMotionModifier);
                                        } else {
                                            ExCapWeaponReloadListener.getLivingMotionModifiers(((JsonElement)importedLivingMotions.get(defaultKey)).getAsJsonObject().asMap()).forEach(moveSetBuilder::addLivingMotionModifier);
                                        }
                                    }
                                    moveSets.add(moveSetBuilder);
                                }
                            });
                            importedCombos.remove("mount");
                            for (int i = 0; i < Math.min(moveSets.size(), styles.size()); ++i) {
                                weapon.getAttackSets().put((Style)styles.get(i), ((MoveSet.MoveSetBuilder)moveSets.get(i)).build());
                            }
                        } else {
                            MoveSet.MoveSetBuilder moveSetBuilder = MoveSet.builder();
                            Style wieldStyle = (Style)Style.ENUM_MANAGER.get(gsonObject.get("style").getAsString());
                            if (gsonObject.has("combo_attack")) {
                                moveSetBuilder.addAutoAttacks((AnimationManager.AnimationAccessor[])ExCapWeaponReloadListener.getAnimationAccessors((JsonElement)gsonObject.get("combo_attack").getAsJsonArray()).toArray(AnimationManager.AnimationAccessor[]::new));
                            }
                            if (gsonObject.has("mount_attack")) {
                                moveSetBuilder.addMountAttacks((AnimationManager.AnimationAccessor[])ExCapWeaponReloadListener.getAnimationAccessors((JsonElement)gsonObject.get("mount_attack").getAsJsonArray()).toArray(AnimationManager.AnimationAccessor[]::new));
                            }
                            if (gsonObject.has("innate_skill")) {
                                moveSetBuilder.addInnateSkill(itemStack -> SkillManager.getSkill((String)gsonObject.get("innate_skill").getAsString()));
                            }
                            if (gsonObject.has("living_animations")) {
                                ExCapWeaponReloadListener.getLivingMotionModifiers(gsonObject.get("living_animations").getAsJsonObject().asMap()).forEach(moveSetBuilder::addLivingMotionModifier);
                            }
                            if (gsonObject.has("weapon_passive")) {
                                moveSetBuilder.setPassiveSkill(SkillManager.getSkill((String)gsonObject.get("weapon_passive").getAsString()));
                            }
                            if (gsonObject.has("guard_motions")) {
                                gsonObject.get("guard_motions").getAsJsonObject().asMap().forEach((s, jsonElement) -> {
                                    if (SkillManager.getSkill((String)s) != null) {
                                        jsonElement.getAsJsonObject().asMap().forEach((s1, jsonElement1) -> moveSetBuilder.addGuardAnimations(SkillManager.getSkill((String)s), GuardSkill.BlockType.valueOf((String)s1.toUpperCase(Locale.ROOT)), (AnimationManager.AnimationAccessor[])ExCapWeaponReloadListener.getAnimationAccessors(jsonElement1).toArray(AnimationManager.AnimationAccessor[]::new)));
                                    }
                                });
                            }
                            if (gsonObject.has("revelation_attack")) {
                                moveSetBuilder.revelationAttack((AnimationManager.AnimationAccessor<? extends AttackAnimation>)AnimationManager.byKey((String)gsonObject.get("revelation_attack").getAsString()));
                            }
                            weapon.getAttackSets().put(wieldStyle, moveSetBuilder.build());
                        }
                    });
                }
            }
        })));
    }

    private static Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> getLivingMotionModifiers(Map<String, JsonElement> map) {
        HashMap result = Maps.newHashMap();
        map.forEach((key, jsonElement) -> result.put((LivingMotion)LivingMotion.ENUM_MANAGER.get(key), AnimationManager.byKey((String)jsonElement.getAsString())));
        return result;
    }

    @NotNull
    private static List<AnimationManager.AnimationAccessor<? extends StaticAnimation>> getGuardAccessors(JsonElement jsonElement) {
        List attacks = jsonElement.getAsJsonArray().asList();
        ArrayList autocomboAnims = Lists.newArrayList();
        attacks.forEach(attacksElement -> autocomboAnims.add(AnimationManager.byKey((String)attacksElement.getAsString())));
        return autocomboAnims;
    }

    @NotNull
    private static List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> getAnimationAccessors(JsonElement jsonElement) {
        List attacks = jsonElement.getAsJsonArray().asList();
        ArrayList autocomboAnims = Lists.newArrayList();
        attacks.forEach(attacksElement -> autocomboAnims.add(AnimationManager.byKey((String)attacksElement.getAsString())));
        return autocomboAnims;
    }
}

