/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.ex_cap.api.providers;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import net.forixaim.ex_cap.api.providers.ProviderConditional;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.Style;

public class CoreWeaponCapabilityProvider {
    private final List<ProviderConditional> conditionals = Lists.newArrayList();

    public void addConditional(ProviderConditional conditional) {
        this.conditionals.add(conditional);
    }

    private void sortByPriority() {
        if (this.conditionals.size() <= 1) {
            return;
        }
        for (int i = 0; i < this.conditionals.size() - 1; ++i) {
            ProviderConditional conditional = this.conditionals.get(i).copy();
            if (conditional.getPriority() >= this.conditionals.get(i + 1).getPriority()) continue;
            this.conditionals.set(i, this.conditionals.get(i + 1));
            this.conditionals.set(i + 1, conditional);
        }
    }

    public Function<LivingEntityPatch<?>, Style> exportStyle() {
        return entityPatch -> {
            this.sortByPriority();
            for (ProviderConditional conditional : this.conditionals) {
                if (conditional.testConditionalStyle((LivingEntityPatch<?>)entityPatch) == null) continue;
                return conditional.testConditionalStyle((LivingEntityPatch<?>)entityPatch);
            }
            return null;
        };
    }

    public Function<LivingEntityPatch<?>, Boolean> exportCombination() {
        return entityPatch -> {
            this.sortByPriority();
            for (ProviderConditional conditional : this.conditionals) {
                if (conditional.testConditionalCombo((LivingEntityPatch<?>)entityPatch) == null) continue;
                return conditional.testConditionalCombo((LivingEntityPatch<?>)entityPatch);
            }
            return null;
        };
    }
}

