/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.ex_cap.api.providers;

import java.util.function.Predicate;
import net.forixaim.battle_arts_api.battle_arts_skills.BattleArtsSkillSlots;
import net.forixaim.ex_cap.api.providers.HelperFunctions;
import net.forixaim.ex_cap.api.providers.ProviderConditionalType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public class ProviderConditional {
    public static final ResourceKey<Registry<ProviderConditional>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"efm_ex", (String)"conditional"));
    protected final ProviderConditionalType type;
    protected final Style style;
    protected final Boolean combination;
    protected final Skill skillToCheck;
    protected final WeaponCategory category;
    protected final Item weapon;
    protected final ProviderConditional[] providerConditionals;
    protected final SkillSlot slot;
    protected final SkillDataKey<Boolean> key;
    protected final InteractionHand hand;
    protected final Predicate<LivingEntityPatch<?>> customFunction;

    private ProviderConditional(ProviderConditionalType type, Style style, Skill skillToCheck, WeaponCategory category, Item weapon, InteractionHand hand, SkillSlot slot, SkillDataKey<Boolean> key, Boolean combination, Predicate<LivingEntityPatch<?>> customFunction, ProviderConditional[] providerConditionals) {
        this.type = type;
        this.style = style;
        this.skillToCheck = skillToCheck;
        this.category = category;
        this.weapon = weapon;
        this.hand = hand;
        this.slot = slot;
        this.key = key;
        this.combination = combination;
        this.customFunction = customFunction;
        this.providerConditionals = providerConditionals;
    }

    public static ProviderConditionalBuilder builder() {
        return new ProviderConditionalBuilder();
    }

    public ProviderConditional(ProviderConditionalBuilder builder) {
        this.type = builder.type;
        this.style = builder.wieldStyle;
        this.combination = builder.visibleOffHand;
        this.skillToCheck = builder.skillToCheck;
        this.category = builder.category;
        this.weapon = builder.weapon;
        this.providerConditionals = builder.providerConditionals;
        this.slot = builder.slot;
        this.key = builder.key;
        this.hand = builder.hand;
        this.customFunction = builder.customFunction;
    }

    public Boolean testConditionalBoolean(LivingEntityPatch<?> entityPatch) {
        PlayerPatch pPatch;
        if (this.type.equals((Object)ProviderConditionalType.SKILL_ACTIVATION) && entityPatch instanceof PlayerPatch && (pPatch = (PlayerPatch)entityPatch).getSkill(this.slot).isActivated()) {
            return true;
        }
        if (this.type.equals((Object)ProviderConditionalType.SKILL_EXISTENCE) && HelperFunctions.skillCheck(entityPatch, this.skillToCheck, this.slot)) {
            return true;
        }
        if (this.type.equals((Object)ProviderConditionalType.WEAPON_CATEGORY) && HelperFunctions.itemCheck(entityPatch, this.category, this.hand)) {
            return true;
        }
        if (this.type.equals((Object)ProviderConditionalType.DATA_KEY) && entityPatch instanceof PlayerPatch) {
            PlayerPatch playerPatch = (PlayerPatch)entityPatch;
            return playerPatch.getSkill(this.slot).getDataManager().hasData(this.key) && (Boolean)playerPatch.getSkill(this.slot).getDataManager().getDataValue(this.key) != false;
        }
        if (this.type.equals((Object)ProviderConditionalType.SPECIFIC_WEAPON)) {
            assert (this.hand != null);
            return ((LivingEntity)entityPatch.getOriginal()).m_21120_(this.hand).m_150930_(this.weapon);
        }
        if (this.type.equals((Object)ProviderConditionalType.COMPOSITE)) {
            assert (this.providerConditionals != null);
            for (ProviderConditional conditional : this.providerConditionals) {
                if (conditional.testConditionalBoolean(entityPatch).booleanValue()) continue;
                return false;
            }
            return true;
        }
        if (this.type.equals((Object)ProviderConditionalType.CUSTOM)) {
            assert (this.customFunction != null);
            if (this.customFunction.test(entityPatch)) {
                return true;
            }
        }
        return this.type.equals((Object)ProviderConditionalType.DEFAULT);
    }

    public Style testConditionalStyle(LivingEntityPatch<?> entityPatch) {
        PlayerPatch playerPatch;
        PlayerPatch pPatch;
        if (this.type.equals((Object)ProviderConditionalType.SKILL_ACTIVATION) && entityPatch instanceof PlayerPatch && (pPatch = (PlayerPatch)entityPatch).getSkill(this.slot).isActivated()) {
            return this.style;
        }
        if (this.type.equals((Object)ProviderConditionalType.SKILL_EXISTENCE) && HelperFunctions.skillCheck(entityPatch, this.skillToCheck, this.slot)) {
            return this.style;
        }
        if (this.type.equals((Object)ProviderConditionalType.WEAPON_CATEGORY) && HelperFunctions.itemCheck(entityPatch, this.category, this.hand)) {
            return this.style;
        }
        if (this.type.equals((Object)ProviderConditionalType.DATA_KEY) && entityPatch instanceof PlayerPatch && (playerPatch = (PlayerPatch)entityPatch).getSkill(this.slot).getDataManager().hasData(this.key) && ((Boolean)playerPatch.getSkill(this.slot).getDataManager().getDataValue(this.key)).booleanValue()) {
            return this.style;
        }
        if (this.type.equals((Object)ProviderConditionalType.SPECIFIC_WEAPON)) {
            assert (this.hand != null);
            if (((LivingEntity)entityPatch.getOriginal()).m_21120_(this.hand).m_150930_(this.weapon)) {
                return this.style;
            }
        }
        if (this.type.equals((Object)ProviderConditionalType.COMPOSITE)) {
            assert (this.providerConditionals != null);
            for (ProviderConditional conditional : this.providerConditionals) {
                if (conditional.testConditionalBoolean(entityPatch).booleanValue()) continue;
                return null;
            }
            return this.style;
        }
        if (this.type.equals((Object)ProviderConditionalType.CUSTOM)) {
            assert (this.customFunction != null);
            if (this.customFunction.test(entityPatch)) {
                return this.style;
            }
        }
        if (this.type.equals((Object)ProviderConditionalType.DEFAULT)) {
            return this.style;
        }
        return null;
    }

    public Boolean testConditionalCombo(LivingEntityPatch<?> entityPatch) {
        PlayerPatch playerPatch;
        PlayerPatch pPatch;
        if (this.type.equals((Object)ProviderConditionalType.SKILL_ACTIVATION) && entityPatch instanceof PlayerPatch && (pPatch = (PlayerPatch)entityPatch).getSkill(this.slot).isActivated()) {
            return this.combination;
        }
        if (this.type.equals((Object)ProviderConditionalType.SKILL_EXISTENCE) && HelperFunctions.skillCheck(entityPatch, this.skillToCheck, this.slot)) {
            return this.combination;
        }
        if (this.type.equals((Object)ProviderConditionalType.WEAPON_CATEGORY) && HelperFunctions.itemCheck(entityPatch, this.category, this.hand)) {
            return this.combination;
        }
        if (this.type.equals((Object)ProviderConditionalType.DATA_KEY) && entityPatch instanceof PlayerPatch && (playerPatch = (PlayerPatch)entityPatch).getSkill(this.slot).getDataManager().hasData(this.key) && ((Boolean)playerPatch.getSkill(this.slot).getDataManager().getDataValue(this.key)).booleanValue()) {
            return this.combination;
        }
        if (this.type.equals((Object)ProviderConditionalType.SPECIFIC_WEAPON)) {
            assert (this.hand != null);
            if (((LivingEntity)entityPatch.getOriginal()).m_21120_(this.hand).m_150930_(this.weapon)) {
                return this.combination;
            }
        }
        if (this.type.equals((Object)ProviderConditionalType.COMPOSITE)) {
            assert (this.providerConditionals != null);
            for (ProviderConditional conditional : this.providerConditionals) {
                if (conditional.testConditionalBoolean(entityPatch).booleanValue()) continue;
                return null;
            }
            return this.combination;
        }
        if (this.type.equals((Object)ProviderConditionalType.CUSTOM)) {
            assert (this.customFunction != null);
            if (this.customFunction.test(entityPatch)) {
                return this.combination;
            }
        }
        if (this.type.equals((Object)ProviderConditionalType.DEFAULT)) {
            return this.combination;
        }
        return null;
    }

    private boolean checkSubConditionalsForExistence() {
        if (this.type == ProviderConditionalType.COMPOSITE) {
            assert (this.providerConditionals != null);
            for (ProviderConditional conditional : this.providerConditionals) {
                if (conditional.type != ProviderConditionalType.SKILL_EXISTENCE || conditional.slot != BattleArtsSkillSlots.BATTLE_STYLE) continue;
                return true;
            }
        }
        return false;
    }

    public ProviderConditionalType getType() {
        return this.type;
    }

    private boolean checkSubConditionalsForDataKey() {
        if (this.type == ProviderConditionalType.COMPOSITE) {
            assert (this.providerConditionals != null);
            for (ProviderConditional conditional : this.providerConditionals) {
                if (conditional.type != ProviderConditionalType.DATA_KEY || conditional.slot != BattleArtsSkillSlots.BATTLE_STYLE) continue;
                return true;
            }
        }
        return false;
    }

    public int getPriority() {
        if (ModList.get().isLoaded("battlearts_api") && this.type == ProviderConditionalType.SKILL_EXISTENCE && this.slot == BattleArtsSkillSlots.BATTLE_STYLE) {
            return 0x7FFFFFFC;
        }
        if (this.type == ProviderConditionalType.DATA_KEY && ModList.get().isLoaded("battlearts_api") && this.slot == BattleArtsSkillSlots.BATTLE_STYLE) {
            return 0x7FFFFFFD;
        }
        if (this.type == ProviderConditionalType.COMPOSITE && ModList.get().isLoaded("battlearts_api") && this.checkSubConditionalsForExistence()) {
            return 0x7FFFFFFE;
        }
        if (this.type == ProviderConditionalType.COMPOSITE && ModList.get().isLoaded("battlearts_api") && this.checkSubConditionalsForDataKey()) {
            return Integer.MAX_VALUE;
        }
        return this.type.getPriority();
    }

    public ProviderConditional copy() {
        return new ProviderConditional(this.type, this.style, this.skillToCheck, this.category, this.weapon, this.hand, this.slot, this.key, this.combination, this.customFunction, this.providerConditionals);
    }

    public static class ProviderConditionalBuilder {
        private ProviderConditionalType type = ProviderConditionalType.DEFAULT;
        private Style wieldStyle = null;
        private Boolean visibleOffHand = false;
        private Skill skillToCheck = null;
        private WeaponCategory category = null;
        private Item weapon = null;
        private ProviderConditional[] providerConditionals = null;
        private SkillSlot slot = null;
        private SkillDataKey<Boolean> key = null;
        private InteractionHand hand = null;
        private Predicate<LivingEntityPatch<?>> customFunction = null;

        public ProviderConditional build() {
            return new ProviderConditional(this);
        }

        public ProviderConditionalBuilder isVisibleOffHand(boolean visibleOffHand) {
            this.visibleOffHand = visibleOffHand;
            return this;
        }

        public ProviderConditionalBuilder setWieldStyle(Style wieldStyle) {
            this.wieldStyle = wieldStyle;
            return this;
        }

        public ProviderConditionalBuilder setType(@NotNull ProviderConditionalType type) {
            this.type = type;
            return this;
        }

        public ProviderConditionalBuilder setSkillToCheck(Skill skillToCheck) {
            this.skillToCheck = skillToCheck;
            return this;
        }

        public ProviderConditionalBuilder setCategory(WeaponCategory category) {
            this.category = category;
            return this;
        }

        public ProviderConditionalBuilder setWeapon(Item weapon) {
            this.weapon = weapon;
            return this;
        }

        public ProviderConditionalBuilder setProviderConditionals(ProviderConditional ... providerConditionals) {
            this.providerConditionals = providerConditionals;
            return this;
        }

        public ProviderConditionalBuilder setSlot(SkillSlot slot) {
            this.slot = slot;
            return this;
        }

        public ProviderConditionalBuilder setKey(SkillDataKey<Boolean> key) {
            this.key = key;
            return this;
        }

        public ProviderConditionalBuilder setHand(InteractionHand hand) {
            this.hand = hand;
            return this;
        }

        public ProviderConditionalBuilder setCustomFunction(Predicate<LivingEntityPatch<?>> customFunction) {
            this.customFunction = customFunction;
            return this;
        }
    }
}

