/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.ex_cap.capabilities;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.Function;
import net.forixaim.ex_cap.api.MaterialPropertyManager;
import net.forixaim.ex_cap.api.Registries;
import net.forixaim.ex_cap.api.material.MaterialProperties;
import net.forixaim.ex_cap.capabilities.ExCapWeapon;
import net.forixaim.ex_cap.capabilities.weapon_presets.ExCapWeapons;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.forgeevent.WeaponCapabilityPresetRegistryEvent;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCapability;

@Mod.EventBusSubscriber(modid="efm_ex", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CapabilityRegistry {
    private static Function<Item, CapabilityItem.Builder> process(ExCapWeapon weapon) {
        return item -> {
            WeaponCapability.Builder builder0 = weapon.export();
            Map<Attribute, ValueModifier> attributeModifier = weapon.getAttModifiers();
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                if (builder0 instanceof WeaponCapability.Builder) {
                    WeaponCapability.Builder builder = builder0;
                    if (MaterialPropertyManager.getProperties().containsKey(tieredItem.m_43314_())) {
                        MaterialProperties properties = MaterialPropertyManager.getProperties().get(tieredItem.m_43314_());
                        attributeModifier.forEach((attribute, modifier) -> {
                            double finalValue = ValueModifier.calculator().attach(modifier).getResult(properties.attributeModifier().get(attribute).floatValue());
                            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)attribute, (Object)new AttributeModifier("ex_cap_attribute", finalValue, AttributeModifier.Operation.ADDITION)));
                        });
                    } else {
                        MaterialProperties properties = Registries.quickRegister(1.0f, 1.0f, 1.0f);
                        attributeModifier.forEach((attribute, modifier) -> {
                            double finalValue = ValueModifier.calculator().attach(modifier).getResult(properties.attributeModifier().get(attribute).floatValue());
                            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)attribute, (Object)new AttributeModifier("ex_cap_attribute", finalValue, AttributeModifier.Operation.ADDITION)));
                        });
                    }
                    builder.hitSound(tieredItem.m_43314_() == Tiers.WOOD ? (SoundEvent)EpicFightSounds.BLUNT_HIT.get() : (SoundEvent)EpicFightSounds.BLADE_HIT.get());
                    builder.hitParticle(tieredItem.m_43314_() == Tiers.WOOD ? (HitParticleType)EpicFightParticles.HIT_BLUNT.get() : (HitParticleType)EpicFightParticles.HIT_BLADE.get());
                }
            }
            return builder0;
        };
    }

    @SubscribeEvent
    public static void Register(WeaponCapabilityPresetRegistryEvent event) {
        ExCapWeapons.REGISTRY.get().forEach(item -> event.getTypeEntry().put(ExCapWeapons.REGISTRY.get().getKey(item), CapabilityRegistry.process(item)));
    }
}

