/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.ex_cap.capabilities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.forixaim.ex_cap.api.moveset.MoveSet;
import net.forixaim.ex_cap.api.providers.CoreWeaponCapabilityProvider;
import net.forixaim.ex_cap.api.providers.ProviderConditional;
import net.forixaim.ex_cap.capabilities.weaponcaps.EXWeaponCapability;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class ExCapWeapon {
    protected final List<ProviderConditional> styleComboProviderRegistry = new ArrayList<ProviderConditional>();
    protected final Map<Style, Function<Pair<Style, EXWeaponCapability.Builder>, EXWeaponCapability.Builder>> attackCombinationRegistry = Maps.newHashMap();
    protected final CoreWeaponCapabilityProvider provider = new CoreWeaponCapabilityProvider();
    protected static final Map<Item, Item> sheathes = Maps.newHashMap();
    protected final Map<Attribute, ValueModifier> attModifiers = Maps.newHashMap();
    protected Map<Style, MoveSet> AttackSets = Maps.newHashMap();
    protected EXWeaponCapability.Builder builder = EXWeaponCapability.builder();

    ExCapWeapon(float pierceModifier, float impactModifier, float aoeModifier) {
        this.attModifiers.put((Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), ValueModifier.multiplier((float)pierceModifier));
        this.attModifiers.put((Attribute)EpicFightAttributes.IMPACT.get(), ValueModifier.multiplier((float)impactModifier));
        this.attModifiers.put((Attribute)EpicFightAttributes.MAX_STRIKES.get(), ValueModifier.multiplier((float)aoeModifier));
    }

    public static void addSheath(Item target, Item sheath) {
        if (sheathes.containsKey(target)) {
            return;
        }
        sheathes.put(target, sheath);
    }

    protected void registerAttackCombo() {
        this.attackCombinationRegistry.forEach((style, pairBuilderFunction) -> this.builder.createStyleCategory((Style)style, (Function<Pair<Style, EXWeaponCapability.Builder>, EXWeaponCapability.Builder>)pairBuilderFunction));
    }

    protected void registerProviderConditionals() {
        for (ProviderConditional conditional : this.styleComboProviderRegistry) {
            this.provider.addConditional(conditional);
        }
    }

    public Map<Attribute, ValueModifier> getAttModifiers() {
        return ImmutableMap.copyOf(this.attModifiers);
    }

    public Map<Style, MoveSet> getAttackSets() {
        return this.AttackSets;
    }

    @Deprecated(forRemoval=true)
    public static ExCapWeapon quickStart(Consumer<EXWeaponCapability.Builder> quickStart) {
        return ExCapWeapon.quickStart(quickStart, 1.0f, 1.0f, 1.0f);
    }

    public static ExCapWeapon quickStart(Consumer<EXWeaponCapability.Builder> quickStart, float pierceModifier, float impactModifier, float aoeModifier) {
        return new ExCapWeapon(pierceModifier, impactModifier, aoeModifier).start(quickStart);
    }

    private ExCapWeapon start(Consumer<EXWeaponCapability.Builder> qs) {
        qs.accept(this.builder);
        return this;
    }

    public List<ProviderConditional> getStyleComboProviderRegistry() {
        return this.styleComboProviderRegistry;
    }

    public WeaponCapability.Builder export() {
        EXWeaponCapability.Builder exportBuilder = EXWeaponCapability.copy(this.builder);
        this.registerProviderConditionals();
        this.registerAttackCombo();
        for (Map.Entry<Item, Item> entry : sheathes.entrySet()) {
            exportBuilder.addSheath(entry.getKey(), entry.getValue());
        }
        this.AttackSets.forEach(exportBuilder::addMoveset);
        exportBuilder.styleProvider((Function)this.provider.exportStyle()).weaponCombinationPredicator((Function)this.provider.exportCombination());
        return exportBuilder;
    }

    public CapabilityItem.Builder export(boolean test) {
        EXWeaponCapability.Builder exportBuilder = EXWeaponCapability.copy(this.builder);
        this.registerProviderConditionals();
        this.registerAttackCombo();
        for (Map.Entry<Item, Item> entry : sheathes.entrySet()) {
            exportBuilder.addSheath(entry.getKey(), entry.getValue());
        }
        this.AttackSets.forEach(exportBuilder::addMoveset);
        exportBuilder.styleProvider((Function)this.provider.exportStyle()).weaponCombinationPredicator((Function)this.provider.exportCombination());
        return exportBuilder;
    }
}

