/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.ex_cap.capabilities.weaponcaps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.forixaim.ex_cap.api.moveset.MoveSet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.fml.ModList;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeSkill;
import yesman.epicfight.network.server.SPSetRemotePlayerSkill;
import yesman.epicfight.network.server.SPSetSkillContainerValue;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.item.EpicFightItems;

public class EXWeaponCapability
extends WeaponCapability {
    protected final Map<Style, Map<ClashType, List<AnimationManager.AnimationAccessor<? extends StaticAnimation>>>> clashes;
    protected final Map<Style, Skill> weaponPassiveSkill;
    protected final Map<Style, Map<Object, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> chantAnimations;
    protected final Map<Style, Map<Object, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> castAnimations;
    protected final Map<Style, Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> battleModeAnimations;
    protected final Map<Style, AnimationManager.AnimationAccessor<?>> battleTransitionAnimations;
    protected final Map<Style, Map<GuardSkill, Map<GuardSkill.BlockType, List<AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>> guardAnimations;
    protected final Map<Style, Predicate<LivingEntityPatch<?>>> shouldRenderSheath;
    protected final Map<Item, Item> sheath;
    protected final Map<Style, List<AnimationManager.AnimationAccessor<? extends AttackAnimation>>> mountAttackAnimations;
    protected final Map<Style, AnimationManager.AnimationAccessor<? extends AttackAnimation>> punishmentAnimation;

    public LivingMotion getLivingMotion(LivingEntityPatch<?> entityPatch, InteractionHand hand) {
        if (((LivingEntity)entityPatch.getOriginal()).m_6117_() && ((LivingEntity)entityPatch.getOriginal()).m_21211_().m_41780_() == UseAnim.BOW) {
            return LivingMotions.AIM;
        }
        return super.getLivingMotion(entityPatch, hand);
    }

    public List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> getMountAttackEX(Style style) {
        if (this.mountAttackAnimations.get(style) == null) {
            return this.getMountAttackMotion();
        }
        return this.mountAttackAnimations.get(style);
    }

    protected EXWeaponCapability(CapabilityItem.Builder builder) {
        super(builder);
        Builder efbsBuilder = (Builder)builder;
        this.punishmentAnimation = efbsBuilder.punishmentAnimation;
        this.shouldRenderSheath = efbsBuilder.shouldRenderSheath;
        this.battleTransitionAnimations = efbsBuilder.battleTransitionAnimations;
        this.battleModeAnimations = efbsBuilder.battleModeAnimations;
        this.castAnimations = efbsBuilder.castAnimations;
        this.chantAnimations = efbsBuilder.chantAnimations;
        this.guardAnimations = efbsBuilder.guardAnimations;
        this.mountAttackAnimations = efbsBuilder.mountAttackAnimation;
        this.weaponPassiveSkill = efbsBuilder.weaponPassiveSkill;
        this.sheath = efbsBuilder.sheath;
        this.clashes = efbsBuilder.clashes;
    }

    public AnimationManager.AnimationAccessor<? extends AttackAnimation> getRevelationAnimation(PlayerPatch<?> playerPatch) {
        return this.punishmentAnimation.get(this.getStyle((LivingEntityPatch)playerPatch));
    }

    public Item getSheath(Item target) {
        if (!this.sheath.containsKey(target)) {
            return (Item)EpicFightItems.UCHIGATANA_SHEATH.get();
        }
        return this.sheath.get(target);
    }

    public Predicate<LivingEntityPatch<?>> getSheathRenderer(Style style) {
        if (this.sheath == null) {
            return livingEntityPatch -> false;
        }
        if (!this.shouldRenderSheath.containsKey(style)) {
            return livingEntityPatch -> false;
        }
        return this.shouldRenderSheath.get(style);
    }

    public Map<Style, AnimationManager.AnimationAccessor<?>> getBattleTransitionAnimations() {
        return this.battleTransitionAnimations;
    }

    public Map<Style, Map<Object, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> getCastAnimations() {
        return this.castAnimations;
    }

    public Map<Style, Map<Object, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> getChantAnimations() {
        return this.chantAnimations;
    }

    public void changeWeaponInnateSkill(PlayerPatch<?> playerpatch, ItemStack itemstack) {
        Skill weaponInnateSkill = this.getInnateSkill(playerpatch, itemstack);
        EpicFightNetworkManager.PayloadBundleBuilder toLocal = EpicFightNetworkManager.PayloadBundleBuilder.create();
        EpicFightNetworkManager.PayloadBundleBuilder toRemote = EpicFightNetworkManager.PayloadBundleBuilder.create();
        SkillContainer weaponInnateSkillContainer = playerpatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        if (weaponInnateSkill != null) {
            if (weaponInnateSkillContainer.getSkill() != weaponInnateSkill) {
                weaponInnateSkillContainer.setSkill(weaponInnateSkill);
            }
            toLocal.and((Object)new SPChangeSkill((SkillSlot)SkillSlots.WEAPON_INNATE, ((Player)playerpatch.getOriginal()).m_19879_(), weaponInnateSkill));
        } else {
            toLocal.and((Object)SPSetSkillContainerValue.enable((SkillSlot)SkillSlots.WEAPON_INNATE, (boolean)false, (int)((Player)playerpatch.getOriginal()).m_19879_()));
        }
        weaponInnateSkillContainer.setDisabled(weaponInnateSkill == null);
        toRemote.and((Object)new SPSetRemotePlayerSkill(((Player)playerpatch.getOriginal()).m_19879_(), (SkillSlot)SkillSlots.WEAPON_INNATE, weaponInnateSkill));
        Skill skill = this.weaponPassiveSkill.get(this.getStyle((LivingEntityPatch)playerpatch));
        SkillContainer passiveSkillContainer = playerpatch.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE);
        if (skill != null) {
            if (passiveSkillContainer.getSkill() != skill) {
                passiveSkillContainer.setSkill(skill);
                toLocal.and((Object)new SPChangeSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE, ((Player)playerpatch.getOriginal()).m_19879_(), this.passiveSkill));
                toRemote.and((Object)new SPSetRemotePlayerSkill(((Player)playerpatch.getOriginal()).m_19879_(), (SkillSlot)SkillSlots.WEAPON_PASSIVE, this.passiveSkill));
            }
        } else {
            passiveSkillContainer.setSkill(null);
            toLocal.and((Object)new SPChangeSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE, ((Player)playerpatch.getOriginal()).m_19879_(), null));
            toRemote.and((Object)new SPSetRemotePlayerSkill(((Player)playerpatch.getOriginal()).m_19879_(), (SkillSlot)SkillSlots.WEAPON_PASSIVE, null));
        }
        toLocal.send((first, others) -> EpicFightNetworkManager.sendToPlayer((Object)first, (ServerPlayer)((ServerPlayer)playerpatch.getOriginal()), (Object[])others));
        toRemote.send((first, others) -> EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((Object)first, (Entity)playerpatch.getOriginal(), (Object[])others));
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getClashAnimation(ClashType clashType, LivingEntityPatch<?> livingEntityPatch) {
        List<AnimationManager.AnimationAccessor<? extends StaticAnimation>> clashAnimations = this.clashes.get(this.getStyle(livingEntityPatch)).get((Object)clashType);
        return clashAnimations.isEmpty() ? null : clashAnimations.get(0);
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardMotion(GuardSkill skill, GuardSkill.BlockType blockType, PlayerPatch<?> playerpatch) {
        Style style = this.getStyle((LivingEntityPatch)playerpatch);
        if (this.guardAnimations.containsKey(style) && this.guardAnimations.get(style).containsKey(skill) && this.guardAnimations.get(style).get(skill).containsKey(blockType) && playerpatch.getSkill((Skill)skill) != null) {
            List<AnimationManager.AnimationAccessor<? extends StaticAnimation>> animations = this.guardAnimations.get(style).get(skill).get(blockType);
            SkillDataManager dataManager = playerpatch.getSkill((Skill)skill).getDataManager();
            if (animations != null && !animations.isEmpty()) {
                if (dataManager.hasData((SkillDataKey)SkillDataKeys.PARRY_MOTION_COUNTER.get()) && blockType == GuardSkill.BlockType.ADVANCED_GUARD) {
                    int motionCounter = (Integer)dataManager.getDataValue((SkillDataKey)SkillDataKeys.PARRY_MOTION_COUNTER.get());
                    dataManager.setDataF((SkillDataKey)SkillDataKeys.PARRY_MOTION_COUNTER.get(), v -> v + 1);
                    return animations.get(motionCounter %= animations.size());
                }
                return animations.get(((Player)playerpatch.getOriginal()).m_217043_().m_188503_(animations.size()));
            }
        }
        return super.getGuardMotion(skill, blockType, playerpatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder copy(Builder copyFrom) {
        return EXWeaponCapability.builder().collider(copyFrom.colliderCopy).category(copyFrom.copyCategory).constructor(copyFrom.copyConstructor).hitParticle(copyFrom.hitParticleCopy).canBePlacedOffhand(copyFrom.offHandPlacementCopy).swingSound(copyFrom.swingSoundCopy).hitSound(copyFrom.hitSoundCopy);
    }

    public static class Builder
    extends WeaponCapability.Builder {
        protected final Map<Style, Map<ClashType, List<AnimationManager.AnimationAccessor<? extends StaticAnimation>>>> clashes;
        protected final Map<Style, Map<Object, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> castAnimations;
        protected final Map<Style, Map<Object, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> chantAnimations;
        protected Map<Style, Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> battleModeAnimations;
        protected final Map<Style, AnimationManager.AnimationAccessor<?>> battleTransitionAnimations;
        protected final Map<Style, Skill> weaponPassiveSkill;
        protected final Map<Style, Predicate<LivingEntityPatch<?>>> shouldRenderSheath;
        protected final Map<Item, Item> sheath;
        protected final Map<Style, AnimationManager.AnimationAccessor<? extends AttackAnimation>> punishmentAnimation;
        protected final Map<Style, List<AnimationManager.AnimationAccessor<? extends AttackAnimation>>> mountAttackAnimation;
        protected Function<CapabilityItem.Builder, CapabilityItem> copyConstructor = EXWeaponCapability::new;
        protected WeaponCategory copyCategory = CapabilityItem.WeaponCategories.FIST;
        protected SoundEvent swingSoundCopy = (SoundEvent)EpicFightSounds.WHOOSH.get();
        protected SoundEvent hitSoundCopy = (SoundEvent)EpicFightSounds.BLUNT_HIT.get();
        protected HitParticleType hitParticleCopy = (HitParticleType)EpicFightParticles.HIT_BLADE.get();
        protected Collider colliderCopy = ColliderPreset.FIST;
        protected boolean offHandPlacementCopy = true;
        protected final Map<Style, Map<GuardSkill, Map<GuardSkill.BlockType, List<AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>> guardAnimations;

        protected Builder() {
            this.mountAttackAnimation = Maps.newHashMap();
            this.punishmentAnimation = Maps.newHashMap();
            this.shouldRenderSheath = Maps.newHashMap();
            this.constructor(EXWeaponCapability::new);
            this.battleModeAnimations = Maps.newHashMap();
            this.battleTransitionAnimations = Maps.newHashMap();
            this.castAnimations = Maps.newHashMap();
            this.chantAnimations = Maps.newHashMap();
            this.clashes = Maps.newHashMap();
            this.guardAnimations = Maps.newHashMap();
            this.weaponPassiveSkill = Maps.newHashMap();
            this.sheath = Maps.newHashMap();
        }

        @SafeVarargs
        public final void addMountAttacks(Style style, AnimationManager.AnimationAccessor<? extends AttackAnimation> ... mountAttacks) {
            this.mountAttackAnimation.put(style, Arrays.asList(mountAttacks));
        }

        @SafeVarargs
        public final void addGuardMotion(Style wieldStyle, Skill guardSkill, GuardSkill.BlockType blockType, AnimationManager.AnimationAccessor<? extends StaticAnimation> ... animation) {
            if (guardSkill instanceof GuardSkill) {
                GuardSkill skill = (GuardSkill)guardSkill;
                this.guardAnimations.computeIfAbsent(wieldStyle, k -> Maps.newHashMap());
                this.guardAnimations.get(wieldStyle).computeIfAbsent(skill, k -> Maps.newHashMap());
                this.guardAnimations.get(wieldStyle).get(guardSkill).computeIfAbsent(blockType, k -> Lists.newArrayList());
                this.guardAnimations.get(wieldStyle).get(guardSkill).get(blockType).addAll(Arrays.asList(animation));
            }
        }

        public Builder addSheath(Item target, Item sheath) {
            this.sheath.put(target, sheath);
            return this;
        }

        public Builder addRevelationAnimation(Style wieldStyle, AnimationManager.AnimationAccessor<? extends AttackAnimation> animation) {
            this.punishmentAnimation.put(wieldStyle, animation);
            return this;
        }

        public Builder addCastAnimation(Style style, Object castType, AnimationManager.AnimationAccessor<? extends StaticAnimation> provider) {
            this.castAnimations.computeIfAbsent(style, k -> Maps.newHashMap());
            if (ModList.get().isLoaded("irons_spellbooks")) {
                this.castAnimations.get(style).put(castType, provider);
            }
            return this;
        }

        public Builder addTransitionAnimation(Style wieldStyle, AnimationManager.AnimationAccessor<? extends StaticAnimation> transitionAnimations) {
            this.battleTransitionAnimations.put(wieldStyle, transitionAnimations);
            return this;
        }

        public Builder renderSheath(Style style, Predicate<LivingEntityPatch<?>> shouldRenderSheath) {
            this.shouldRenderSheath.put(style, shouldRenderSheath);
            return this;
        }

        public Builder constructor(Function<CapabilityItem.Builder, CapabilityItem> constructor) {
            this.copyConstructor = constructor;
            return (Builder)super.constructor(constructor);
        }

        public Builder category(WeaponCategory category) {
            this.copyCategory = category;
            return (Builder)super.category(category);
        }

        public Builder styleProvider(Function<LivingEntityPatch<?>, Style> styleProvider) {
            return (Builder)super.styleProvider(styleProvider);
        }

        public Builder passiveSkill(Skill passiveSkill) {
            return (Builder)super.passiveSkill(passiveSkill);
        }

        public Builder swingSound(SoundEvent swingSound) {
            this.swingSoundCopy = swingSound;
            return (Builder)super.swingSound(swingSound);
        }

        public Builder hitSound(SoundEvent hitSound) {
            this.hitSoundCopy = hitSound;
            return (Builder)super.hitSound(hitSound);
        }

        public Builder hitParticle(HitParticleType hitParticle) {
            this.hitParticleCopy = hitParticle;
            return (Builder)super.hitParticle(hitParticle);
        }

        public Builder collider(Collider collider) {
            this.colliderCopy = collider;
            return (Builder)super.collider(collider);
        }

        public Builder canBePlacedOffhand(boolean canBePlacedOffhand) {
            this.offHandPlacementCopy = canBePlacedOffhand;
            return (Builder)super.canBePlacedOffhand(canBePlacedOffhand);
        }

        public void exCapLMMs(Style wieldStyle, LivingMotion livingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
            this.livingMotionModifier(wieldStyle, livingMotion, animation);
        }

        @SafeVarargs
        public final void addClashAnimation(Style wieldStyle, ClashType clashType, AnimationManager.AnimationAccessor<? extends StaticAnimation> ... animation) {
            this.clashes.computeIfAbsent(wieldStyle, k -> Maps.newHashMap()).computeIfAbsent(clashType, k -> Lists.newArrayList((Object[])animation));
        }

        public Builder addStyleAttibutes(Style style, Pair<Attribute, AttributeModifier> attributePair) {
            return (Builder)super.addStyleAttibutes(style, attributePair);
        }

        public Builder weaponCombinationPredicator(Function<LivingEntityPatch<?>, Boolean> predicator) {
            return (Builder)super.weaponCombinationPredicator(predicator);
        }

        public Builder innateSkill(Style style, Function<ItemStack, Skill> innateSkill) {
            return (Builder)super.innateSkill(style, innateSkill);
        }

        public Builder comboCancel(Function<Style, Boolean> comboCancel) {
            return (Builder)super.comboCancel(comboCancel);
        }

        public void createStyleCategory(Style style, Function<Pair<Style, Builder>, Builder> weaponCombo) {
            weaponCombo.apply((Pair<Style, Builder>)new Pair((Object)style, (Object)this));
        }

        public void addMoveset(Style style, MoveSet moveSet) {
            this.newStyleCombo(style, (AnimationManager.AnimationAccessor[])moveSet.getAutoAttackAnimations().toArray(AnimationManager.AnimationAccessor[]::new));
            this.renderSheath(style, moveSet.shouldRenderSheath());
            moveSet.getLivingMotionModifiers().forEach((motion, animation) -> this.exCapLMMs(style, (LivingMotion)motion, (AnimationManager.AnimationAccessor<? extends StaticAnimation>)animation));
            moveSet.getGuardAnimations().forEach((guardSkill, blockTypeListMap) -> blockTypeListMap.forEach((blockType, animationProviders) -> this.addGuardMotion(style, (Skill)guardSkill, (GuardSkill.BlockType)blockType, (AnimationManager.AnimationAccessor<? extends StaticAnimation>[])((AnimationManager.AnimationAccessor[])animationProviders.toArray(AnimationManager.AnimationAccessor[]::new)))));
            this.innateSkill(style, (Function)moveSet.getWeaponInnateSkill());
            this.weaponPassiveSkill.put(style, moveSet.getWeaponPassiveSkill());
            if (!moveSet.getMountAttackAnimations().isEmpty()) {
                this.addMountAttacks(style, (AnimationManager.AnimationAccessor[])moveSet.getMountAttackAnimations().toArray(AnimationManager.AnimationAccessor[]::new));
            }
            if (moveSet.getRevelation() != null) {
                this.addRevelationAnimation(style, moveSet.getRevelation());
            }
        }

        public Builder zoomInType(CapabilityItem.ZoomInType zoomInType) {
            return (Builder)super.zoomInType(zoomInType);
        }
    }

    public static enum ClashType {
        BLADE,
        BLUNT;

    }
}

