/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.ex_cap.kjs.moveset;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.forixaim.ex_cap.api.moveset.MoveSet;
import net.forixaim.ex_cap.kjs.ExCapKubeJSPlugin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class CustomMoveSet
extends MoveSet {
    private final ResourceLocation id;
    private final List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> autoAttackAnimations;
    private final List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> mountAttackAnimations;
    private final Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> livingMotionModifiers;
    private Function<ItemStack, Skill> weaponInnateSkill;
    private final Map<Skill, Map<GuardSkill.BlockType, List<AnimationManager.AnimationAccessor<? extends StaticAnimation>>>> guardAnimations;
    private final Skill weaponPassiveSkill;
    private Predicate<LivingEntityPatch<?>> sheathRender;
    private AnimationManager.AnimationAccessor<? extends AttackAnimation> revelationAnimation;

    public CustomMoveSet(CustomMoveSetBuilder builder) {
        super(builder.toMainBuilder());
        this.id = builder.id;
        this.autoAttackAnimations = builder.autoAttackAnimations;
        this.mountAttackAnimations = builder.mountAttackAnimations;
        this.livingMotionModifiers = builder.livingMotionModifiers;
        this.weaponInnateSkill = builder.weaponInnateSkill;
        this.guardAnimations = builder.guardAnimations;
        this.weaponPassiveSkill = builder.weaponPassiveSkill;
        this.sheathRender = builder.sheathRender;
        this.revelationAnimation = builder.revelationAnimation;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public static class CustomMoveSetBuilder
    extends BuilderBase<MoveSet> {
        private final ResourceLocation id;
        private final List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> autoAttackAnimations;
        private final List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> mountAttackAnimations;
        private final Map<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> livingMotionModifiers;
        private Function<ItemStack, Skill> weaponInnateSkill;
        private final Map<Skill, Map<GuardSkill.BlockType, List<AnimationManager.AnimationAccessor<? extends StaticAnimation>>>> guardAnimations;
        private Skill weaponPassiveSkill;
        private Predicate<LivingEntityPatch<?>> sheathRender;
        private AnimationManager.AnimationAccessor<? extends AttackAnimation> revelationAnimation;

        public CustomMoveSetBuilder(ResourceLocation id) {
            super(id);
            this.id = id;
            this.autoAttackAnimations = Lists.newArrayList();
            this.mountAttackAnimations = Lists.newArrayList();
            this.livingMotionModifiers = Maps.newHashMap();
            this.weaponInnateSkill = null;
            this.guardAnimations = Maps.newHashMap();
            this.revelationAnimation = null;
            this.weaponInnateSkill = null;
            this.sheathRender = livingEntityPatch -> false;
        }

        public CustomMoveSetBuilder revelationAttack(AnimationManager.AnimationAccessor<? extends AttackAnimation> attack) {
            this.revelationAnimation = attack;
            return this;
        }

        public CustomMoveSetBuilder shouldRenderSheath(Predicate<LivingEntityPatch<?>> sheathRender) {
            this.sheathRender = sheathRender;
            return this;
        }

        @Info(value="So this is the passive skill\n")
        public CustomMoveSetBuilder setPassiveSkill(Skill newPassiveSkill) {
            this.weaponPassiveSkill = newPassiveSkill;
            return this;
        }

        @SafeVarargs
        public final CustomMoveSetBuilder addMountAttacks(AnimationManager.AnimationAccessor<? extends AttackAnimation> ... attackAnimations) {
            this.mountAttackAnimations.addAll(Arrays.asList(attackAnimations));
            return this;
        }

        public CustomMoveSetBuilder addAutoAttacks(AnimationManager.AnimationAccessor<? extends AttackAnimation> ... attackAnimations) {
            this.autoAttackAnimations.addAll(Arrays.asList(attackAnimations));
            return this;
        }

        public CustomMoveSetBuilder addLivingMotionModifier(LivingMotion livingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation> animation) {
            this.livingMotionModifiers.put(livingMotion, animation);
            return this;
        }

        public CustomMoveSetBuilder addInnateSkill(Function<ItemStack, Skill> weaponInnateSkill) {
            this.weaponInnateSkill = weaponInnateSkill;
            return this;
        }

        public CustomMoveSetBuilder addLivingMotionsRecursive(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, LivingMotion ... motions) {
            for (LivingMotion livingMotion : motions) {
                this.livingMotionModifiers.put(livingMotion, animation);
            }
            return this;
        }

        public MoveSet.MoveSetBuilder toMainBuilder() {
            MoveSet.MoveSetBuilder builder = MoveSet.builder();
            this.livingMotionModifiers.forEach(builder::addLivingMotionModifier);
            builder.addAutoAttacks(this.autoAttackAnimations.toArray(new AnimationManager.AnimationAccessor[0]));
            builder.setPassiveSkill(this.weaponPassiveSkill);
            builder.addInnateSkill(this.weaponInnateSkill);
            builder.addMountAttacks(this.mountAttackAnimations.toArray(new AnimationManager.AnimationAccessor[0]));
            builder.shouldRenderSheath(this.sheathRender);
            builder.revelationAttack(this.revelationAnimation);
            this.guardAnimations.forEach(builder::easyAddGuardAnimations);
            return builder;
        }

        public CustomMoveSet build() {
            return new CustomMoveSet(this);
        }

        public RegistryInfo<MoveSet> getRegistryType() {
            return ExCapKubeJSPlugin.MOVESET_REGISTRY;
        }

        public MoveSet createObject() {
            return this.build();
        }
    }
}

