/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.ex_cap.mixin;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.UUID;
import net.forixaim.ex_cap.capabilities.weaponcaps.EXWeaponCapability;
import net.forixaim.ex_cap.skill.ExCapDatakeys;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PlayerRideableJumping;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.BasicAttack;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.BasicAttackEvent;
import yesman.epicfight.world.entity.eventlistener.ComboCounterHandleEvent;
import yesman.epicfight.world.entity.eventlistener.DetachablePlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;

@Mixin(value={BasicAttack.class}, remap=false)
public class MixinBasicAttack {
    @Shadow
    @Final
    private static UUID EVENT_UUID;

    @Unique
    private static void exCap$setComboCounterWithEventEX(ComboCounterHandleEvent.Causal reason, ServerPlayerPatch playerpatch, SkillContainer container, AnimationManager.AnimationAccessor<? extends StaticAnimation> causalAnimation, int value) {
        int prevValue = (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get());
        ComboCounterHandleEvent comboResetEvent = new ComboCounterHandleEvent(reason, playerpatch, causalAnimation, prevValue, value);
        container.getExecutor().getEventListener().triggerEvents(PlayerEventListener.EventType.COMBO_COUNTER_HANDLE_EVENT, (DetachablePlayerEvent)comboResetEvent);
        container.getDataManager().setData((SkillDataKey)ExCapDatakeys.COMBO_COUNTER.get(), (Object)comboResetEvent.getNextValue());
    }

    @Inject(method={"updateContainer"}, at={@At(value="RETURN")}, remap=false)
    public void updateContainer(SkillContainer container, CallbackInfo ci) {
        if (!container.getExecutor().isLogicalClient() && container.getExecutor().getTickSinceLastAction() > 16 && (Integer)container.getDataManager().getDataValue((SkillDataKey)ExCapDatakeys.COMBO_COUNTER.get()) > 0) {
            MixinBasicAttack.exCap$setComboCounterWithEventEX(ComboCounterHandleEvent.Causal.TIME_EXPIRED, container.getServerExecutor(), container, null, 0);
        }
    }

    @Inject(method={"executeOnServer"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args, CallbackInfo ci) {
        CapabilityItem capabilityItem = skillContainer.getServerExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND);
        if (capabilityItem instanceof EXWeaponCapability) {
            EXWeaponCapability eX = (EXWeaponCapability)capabilityItem;
            ServerPlayerPatch executor = skillContainer.getServerExecutor();
            SkillConsumeEvent event = new SkillConsumeEvent((PlayerPatch)executor, (Skill)((BasicAttack)this), ((BasicAttack)this).getResourceType(), args);
            executor.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (DetachablePlayerEvent)event);
            if (!event.isCanceled()) {
                event.getResourceType().consumer.consume(skillContainer, executor, event.getAmount());
            }
            if (!executor.getEventListener().triggerEvents(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, (DetachablePlayerEvent)new BasicAttackEvent(executor))) {
                AnimationManager.AnimationAccessor<? extends AttackAnimation> attackMotion = null;
                ServerPlayer player = (ServerPlayer)executor.getOriginal();
                SkillDataManager dataManager = skillContainer.getDataManager();
                int comboCounter = (Integer)dataManager.getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get());
                int mountedComboCounter = (Integer)dataManager.getDataValue((SkillDataKey)ExCapDatakeys.COMBO_COUNTER.get());
                if (player.m_20159_()) {
                    PlayerRideableJumping rideable;
                    Entity entity = player.m_20202_();
                    if (entity instanceof PlayerRideableJumping && (rideable = (PlayerRideableJumping)entity).m_7132_() && eX.availableOnHorse() && eX.getMountAttackEX(eX.getStyle((LivingEntityPatch)executor)) != null) {
                        List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> combo = eX.getMountAttackEX(eX.getStyle((LivingEntityPatch)executor));
                        if (combo == null) {
                            return;
                        }
                        int comboSize = combo.size();
                        attackMotion = combo.get(mountedComboCounter %= comboSize);
                        MixinBasicAttack.exCap$setComboCounterWithEventEX(ComboCounterHandleEvent.Causal.ANOTHER_ACTION_ANIMATION, executor, skillContainer, attackMotion, ++mountedComboCounter);
                        LogUtils.getLogger().debug("Combo Count: {}", (Object)mountedComboCounter);
                    }
                } else {
                    List combo = eX.getAutoAttackMotion((PlayerPatch)executor);
                    if (combo == null) {
                        return;
                    }
                    int comboSize = combo.size();
                    boolean dashAttack = player.m_20142_();
                    comboCounter = dashAttack ? comboSize - 2 : (comboCounter %= comboSize - 2);
                    attackMotion = (AnimationManager.AnimationAccessor<? extends AttackAnimation>)combo.get(comboCounter);
                    comboCounter = dashAttack ? 0 : comboCounter + 1;
                    BasicAttack.setComboCounterWithEvent((ComboCounterHandleEvent.Causal)ComboCounterHandleEvent.Causal.ANOTHER_ACTION_ANIMATION, (ServerPlayerPatch)executor, (SkillContainer)skillContainer, (AnimationManager.AnimationAccessor)attackMotion, (int)comboCounter);
                }
                if (attackMotion != null) {
                    executor.playAnimationSynchronized(attackMotion, 0.0f);
                }
                executor.updateEntityState();
            }
            ci.cancel();
        }
    }
}

